/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatShort1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort2D;
import mitiv.array.impl.StriddenShort1D;
import mitiv.array.impl.StriddenShort2D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ShortGenerator;

public class FlatShort2D
extends Short2D {
    static final int order = 1;
    final short[] data;

    public FlatShort2D(int dim1, int dim2) {
        super(dim1, dim2);
        this.data = new short[this.number];
    }

    public FlatShort2D(int[] dims) {
        super(dims);
        this.data = new short[this.number];
    }

    public FlatShort2D(Shape shape) {
        super(shape);
        this.data = new short[this.number];
    }

    public FlatShort2D(short[] arr, int dim1, int dim2) {
        super(dim1, dim2);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatShort2D(short[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatShort2D(short[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null.");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small.");
        }
    }

    private void checkSize(short[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small.");
        }
    }

    final int index(int i1, int i2) {
        return this.dim1 * i2 + i1;
    }

    @Override
    public final short get(int i1, int i2) {
        return this.data[this.dim1 * i2 + i1];
    }

    @Override
    public final void set(int i1, int i2, short value) {
        this.data[this.dim1 * i2 + i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(short value) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = value;
            ++j;
        }
    }

    @Override
    public void fill(ShortGenerator generator) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = generator.nextShort();
            ++j;
        }
    }

    @Override
    public void increment(short value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (short)(this.data[n] + value);
        }
    }

    @Override
    public void decrement(short value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (short)(this.data[n] - value);
        }
    }

    @Override
    public void scale(short value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (short)(this.data[n] * value);
        }
    }

    @Override
    public void map(ShortFunction function) {
        int j = 0;
        while (j < this.number) {
            this.data[j] = function.apply(this.data[j]);
            ++j;
        }
    }

    @Override
    public void scan(ShortScanner scanner) {
        scanner.initialize(this.data[0]);
        int j = 1;
        while (j < this.number) {
            scanner.update(this.data[j]);
            ++j;
        }
    }

    @Override
    public short[] flatten(boolean forceCopy) {
        if (forceCopy) {
            short[] result = new short[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public Short1D slice(int idx) {
        if ((idx = Helper.fixIndex(idx, this.dim2)) == 0) {
            return new FlatShort1D(this.data, this.dim1);
        }
        return new StriddenShort1D(this.data, this.dim1 * idx, 1, this.dim1);
    }

    @Override
    public Short1D slice(int idx, int dim) {
        int sliceDim1;
        int sliceStride1;
        int sliceOffset;
        if ((dim = Helper.fixSliceIndex(dim, 2)) == 0) {
            sliceOffset = Helper.fixIndex(idx, this.dim1);
            sliceStride1 = this.dim1;
            sliceDim1 = this.dim2;
        } else {
            sliceOffset = this.dim1 * Helper.fixIndex(idx, this.dim2);
            sliceStride1 = 1;
            sliceDim1 = this.dim1;
        }
        return new StriddenShort1D(this.data, sliceOffset, sliceStride1, sliceDim1);
    }

    @Override
    public Short2D view(Range rng1, Range rng2) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.dim1);
        if (cr1.doesNothing() && cr2.doesNothing()) {
            return this;
        }
        return new StriddenShort2D(this.data, cr1.getOffset() + cr2.getOffset(), cr1.getStride(), cr2.getStride(), cr1.getNumber(), cr2.getNumber());
    }

    @Override
    public Short2D view(int[] sel1, int[] sel2) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.dim1, this.dim2, sel2);
        return new SelectedShort2D(this.data, idx1, idx2);
    }

    @Override
    public Short1D as1D() {
        return new FlatShort1D(this.data, this.number);
    }
}

