/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.deconv.Convolution;
import mitiv.deconv.impl.WeightedConvolutionDouble1D;
import mitiv.deconv.impl.WeightedConvolutionDouble2D;
import mitiv.deconv.impl.WeightedConvolutionDouble3D;
import mitiv.deconv.impl.WeightedConvolutionFloat1D;
import mitiv.deconv.impl.WeightedConvolutionFloat2D;
import mitiv.deconv.impl.WeightedConvolutionFloat3D;
import mitiv.exception.IllegalTypeException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.Timer;

public abstract class WeightedConvolutionCost
implements DifferentiableCostFunction {
    protected final ShapedVectorSpace objectSpace;
    protected final ShapedVectorSpace dataSpace;
    protected Timer timerForFFT = new Timer();
    protected Timer timer = new Timer();

    protected WeightedConvolutionCost(ShapedVectorSpace objectSpace, ShapedVectorSpace dataSpace) {
        this.objectSpace = objectSpace;
        this.dataSpace = dataSpace;
    }

    public VectorSpace getObjectSpace() {
        return this.objectSpace;
    }

    @Override
    public VectorSpace getInputSpace() {
        return this.objectSpace;
    }

    public VectorSpace getDataSpace() {
        return this.dataSpace;
    }

    public static WeightedConvolutionCost build(ShapedVectorSpace space) {
        return WeightedConvolutionCost.build(space, space);
    }

    public static WeightedConvolutionCost build(ShapedVectorSpace objectSpace, ShapedVectorSpace dataSpace) {
        int rank = Math.min(objectSpace.getRank(), dataSpace.getRank());
        int[] dataOffset = new int[rank];
        int k = 0;
        while (k < rank) {
            dataOffset[k] = objectSpace.getDimension(k) / 2 - dataSpace.getDimension(k) / 2;
            ++k;
        }
        return WeightedConvolutionCost.build(objectSpace, dataSpace, dataOffset);
    }

    public static WeightedConvolutionCost build(ShapedVectorSpace objectSpace, ShapedVectorSpace dataSpace, int[] dataOffset) {
        int type = objectSpace.getType();
        if (dataSpace.getType() != type) {
            throw new IllegalTypeException("Input and output spaces must have same element type.");
        }
        int rank = objectSpace.getRank();
        if (dataSpace.getShape().rank() != rank) {
            throw new IllegalTypeException("Input and output spaces must have same rank.");
        }
        switch (type) {
            case 4: {
                switch (rank) {
                    case 1: {
                        return new WeightedConvolutionFloat1D(objectSpace, dataSpace, dataOffset);
                    }
                    case 2: {
                        return new WeightedConvolutionFloat2D(objectSpace, dataSpace, dataOffset);
                    }
                    case 3: {
                        return new WeightedConvolutionFloat3D(objectSpace, dataSpace, dataOffset);
                    }
                }
                break;
            }
            case 5: {
                switch (rank) {
                    case 1: {
                        return new WeightedConvolutionDouble1D(objectSpace, dataSpace, dataOffset);
                    }
                    case 2: {
                        return new WeightedConvolutionDouble2D(objectSpace, dataSpace, dataOffset);
                    }
                    case 3: {
                        return new WeightedConvolutionDouble3D(objectSpace, dataSpace, dataOffset);
                    }
                }
                break;
            }
            default: {
                throw new IllegalTypeException("Only float and double types are implemented.");
            }
        }
        throw new IllegalArgumentException("Only 1D, 2D and 3D convolution are implemented.");
    }

    private final void checkObject(Vector x) {
        if (!x.belongsTo(this.objectSpace)) {
            throw new IllegalArgumentException("Variables X does not belong to the object space.");
        }
    }

    private final void checkGradient(Vector gx) {
        if (!gx.belongsTo(this.objectSpace)) {
            throw new IllegalArgumentException("Gradient GX does not belong to the object space.");
        }
    }

    @Override
    public double evaluate(double alpha, Vector x) {
        this.checkObject(x);
        if (alpha == 0.0) {
            return 0.0;
        }
        return this.cost(alpha, x);
    }

    @Override
    public double computeCostAndGradient(double alpha, Vector x, Vector gx, boolean clr) {
        this.checkObject(x);
        this.checkGradient(gx);
        if (alpha == 0.0) {
            if (clr) {
                gx.zero();
            }
            return 0.0;
        }
        return this.cost(alpha, x, gx, clr);
    }

    protected abstract double cost(double var1, Vector var3);

    protected abstract double cost(double var1, Vector var3, Vector var4, boolean var5);

    public abstract void setWeightsAndData(ShapedVector var1, ShapedVector var2);

    public abstract void setWeightsAndData(ShapedArray var1, ShapedArray var2);

    protected static void badWeights() {
        throw new IllegalArgumentException("Weights must be finite and non-negative.");
    }

    public abstract void setPSF(ShapedVector var1);

    public void setPSF(ShapedArray psf) {
        this.setPSF(psf, Convolution.center(psf.getShape()));
    }

    public abstract void setPSF(ShapedArray var1, int[] var2);

    protected static int outputOffset(int rank, Shape inputShape, Shape outputShape, int[] offset) {
        if (inputShape.rank() != rank) {
            throw new IllegalArgumentException("Bad rank for input space.");
        }
        if (outputShape.rank() != rank) {
            throw new IllegalArgumentException("Bad rank for output space.");
        }
        if (offset != null && offset.length != rank) {
            throw new IllegalArgumentException("Bad number of coordinates for the first position");
        }
        int totalOffset = 0;
        int stride = 1;
        int k = 0;
        while (k < rank) {
            int thisOffset;
            int inpDim = inputShape.dimension(k);
            int outDim = outputShape.dimension(k);
            if (outDim > inpDim) {
                throw new IllegalArgumentException("Output dimensions must be at most as large as input dimensions");
            }
            if (offset == null) {
                thisOffset = inpDim / 2 - outDim / 2;
            } else {
                thisOffset = offset[k];
                if (thisOffset < 0 || thisOffset + outDim > inpDim) {
                    throw new IllegalArgumentException("Output region is outside bounds");
                }
            }
            totalOffset += stride * thisOffset;
            stride *= inpDim;
            ++k;
        }
        return totalOffset;
    }

    public void resetTimers() {
        this.timerForFFT.stop();
        this.timerForFFT.reset();
        this.timer.stop();
        this.timer.reset();
    }

    public double getElapsedTime() {
        return this.timer.getElapsedTime();
    }

    public double getElapsedTimeInFFT() {
        return this.timerForFFT.getElapsedTime();
    }
}

