/*
 * Decompiled with CFR 0.152.
 */
package plugins.lagache.etrack;

import icy.file.FileUtil;
import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.math.ArrayMath;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.util.XLSUtil;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3i;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import plugins.adufour.connectedcomponents.ConnectedComponent;
import plugins.adufour.connectedcomponents.ConnectedComponents;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.detector.LocalMaximaDetector;
import plugins.fab.spotDetector.detector.UDWTScale;
import plugins.fab.spotDetector.detector.wavelets.UDWT.B3SplineUDWT;
import plugins.fab.spotDetector.detector.wavelets.UDWT.WaveletConfigException;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;
import plugins.fab.trackmanager.TrackSegment;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.lagache.etrack.Tube;
import plugins.nchenouard.spot.Detection;
import plugins.nchenouard.spot.Point3D;
import plugins.nchenouard.spot.Spot;

public class eTrack
extends EzPlug {
    EzVarSequence sequence = new EzVarSequence("Input Sequence");
    EzVarBoolean bright = new EzVarBoolean("detect bright spots in dark background ", true);
    EzVarInteger scale = new EzVarInteger("Scale for spot detection", 2, 1, 5, 1);
    EzVarDouble threshold = new EzVarDouble("Threshold for spot detection", 100.0, 0.0, 500.0, 1.0);
    EzVarBoolean displayCumulativeSpotsCheckBox = new EzVarBoolean("Display Putative Endocytosis Sites", false);
    EzVarBoolean displayEndoCheckBox = new EzVarBoolean("Display Endocytosis Sites", false);
    EzVarBoolean advanced = new EzVarBoolean("Show advanced parameters", false);
    EzVarDouble minTubesDistance = new EzVarDouble("Min. distance between endocytosis sites", 5.0, 0.0, 100.0, 1.0);
    EzVarDouble maxSearchDistance = new EzVarDouble("Max. search distance of spots to sites", 10.0, 0.0, 100.0, 1.0);
    EzVarDouble TubeThreshold = new EzVarDouble("Threshold to detect endocytosis sites", 10.0, 0.0, 100.0, 1.0);
    EzVarDouble maxGap = new EzVarDouble("Max. gap closing", 5.0, 0.0, 100.0, 1.0);
    EzVarDouble minDuration = new EzVarDouble("Min. tube duration", 5.0, 0.0, 100000.0, 1.0);
    EzVarDouble maxDuration = new EzVarDouble("Max. tube duration", 1000.0, 0.0, 1000000.0, 1.0);
    protected EzVarBoolean exportExcel = new EzVarBoolean("Export to Excel", false);
    protected EzVarFile exportExcelFile = new EzVarFile("Excel file", "");
    ArrayList<UDWTScale> UDWTScaleArrayList = new ArrayList();

    private int getNumberOfMaxEnabledScale() {
        int maxScale = 0;
        for (UDWTScale scale : this.UDWTScaleArrayList) {
            if (!scale.isEnabled() || scale.scaleNumber <= maxScale) continue;
            maxScale = scale.scaleNumber;
        }
        return maxScale;
    }

    private int getNumberOfScale() {
        return this.UDWTScaleArrayList.size();
    }

    private double getScaleThreshold(int scale) {
        return this.UDWTScaleArrayList.get(scale).getThreshold();
    }

    private boolean isScaleEnabled(int scale) {
        return this.UDWTScaleArrayList.get(scale).isEnabled();
    }

    private double getMinTubesDistance() {
        double minDist;
        try {
            minDist = (Double)this.minTubesDistance.getValue();
        }
        catch (NumberFormatException nfe) {
            minDist = 0.0;
        }
        return minDist;
    }

    private double getMinTubesDuration() {
        double minDur;
        try {
            minDur = (Double)this.minDuration.getValue();
        }
        catch (NumberFormatException nfe) {
            minDur = 0.0;
        }
        return minDur;
    }

    private double getMaxTubesDuration() {
        double maxDur;
        try {
            maxDur = (Double)this.maxDuration.getValue();
        }
        catch (NumberFormatException nfe) {
            maxDur = 0.0;
        }
        return maxDur;
    }

    private double getMaxSearchDistance() {
        double maxDist;
        try {
            maxDist = (Double)this.maxSearchDistance.getValue();
        }
        catch (NumberFormatException nfe) {
            maxDist = 0.0;
        }
        return maxDist;
    }

    private double getTubeThreshold() {
        double tubeThres;
        try {
            tubeThres = (Double)this.TubeThreshold.getValue();
        }
        catch (NumberFormatException nfe) {
            tubeThres = 0.0;
        }
        return tubeThres;
    }

    private double getMaxGapClosing() {
        double maxGapp;
        try {
            maxGapp = (Double)this.maxGap.getValue();
        }
        catch (NumberFormatException nfe) {
            maxGapp = 0.0;
        }
        return maxGapp;
    }

    public double getVar(double[] data) {
        if (data.length <= 1) {
            return 0.0;
        }
        double sum = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < data.length) {
            double val = data[i];
            sum2 += val * val;
            sum += val;
            ++i;
        }
        return (sum2 - sum * sum / (double)data.length) / (double)(data.length - 1);
    }

    public double getMean(float[] data) {
        double mean = 0.0;
        double sum = 0.0;
        int i = 0;
        while (i < data.length) {
            sum += (double)data[i];
            ++i;
        }
        if (data.length > 0) {
            mean = sum / (double)data.length;
        }
        return mean;
    }

    public double getMeanAverageDistance(float[] data) {
        double mean = this.getMean(data);
        double a = 0.0;
        int i = 0;
        while (i < data.length) {
            double s = (double)data[i] - mean;
            a += Math.abs(s);
            ++i;
        }
        if (data.length > 0) {
            return a / (double)data.length;
        }
        return 0.0;
    }

    private ImageMathInfo avesigma(float[] image) {
        ImageMathInfo ic = new ImageMathInfo();
        ic.mad = this.getMeanAverageDistance(image);
        return ic;
    }

    private void filter_wat(float[] data, int depth, int width, int height) {
        if (!this.isScaleEnabled(depth)) {
            int i = 0;
            while (i < data.length) {
                data[i] = 0.0f;
                ++i;
            }
            return;
        }
        double[] lambdac = new double[this.getNumberOfScale() + 2];
        int i = 0;
        while (i < this.getNumberOfScale() + 2) {
            lambdac[i] = Math.sqrt(2.0 * Math.log(width * height / (1 << 2 * i)));
            ++i;
        }
        ImageMathInfo imageCaract = this.avesigma(data);
        double[] dcoeff = new double[5];
        int i2 = 0;
        while (i2 < this.getNumberOfMaxEnabledScale()) {
            dcoeff[i2] = this.getScaleThreshold(i2) / 100.0;
            ++i2;
        }
        double coeffThr = lambdac[depth + 1] * imageCaract.mad / dcoeff[depth];
        int inc = 0;
        int i3 = 0;
        while (i3 < data.length) {
            if ((double)data[i3] < coeffThr) {
                data[i3] = 0.0f;
            }
            if ((double)data[i3] > coeffThr) {
                ++inc;
            }
            ++i3;
        }
        inc += 0;
    }

    private double[][] detectionResults(Sequence sequence) {
        int numScales = this.getNumberOfMaxEnabledScale();
        int width = sequence.getImage(0, 0).getWidth();
        int height = sequence.getImage(0, 0).getHeight();
        double[][] detectionResults = new double[sequence.getSizeT()][width * height];
        if (sequence.getSizeZ() == 1) {
            int t = 0;
            while (t < sequence.getSizeT()) {
                IcyBufferedImage image = sequence.getImage(t, 0);
                float[] DetectionResult = new float[image.getWidth() * image.getHeight()];
                if (image != null) {
                    float[][] scales;
                    float[] dataIn = Array1DUtil.arrayToFloatArray((Object)image.getDataXY(0), (boolean)image.getDataType_().isSigned());
                    B3SplineUDWT waveletTransform = new B3SplineUDWT();
                    try {
                        scales = waveletTransform.b3WaveletScales2D(dataIn, image.getWidth(), image.getHeight(), numScales);
                    }
                    catch (WaveletConfigException e1) {
                        e1.printStackTrace();
                        return detectionResults;
                    }
                    float[][] coefficients = waveletTransform.b3WaveletCoefficients2D(scales, dataIn, numScales, image.getWidth() * image.getHeight());
                    int i = 0;
                    while (i < coefficients.length - 1) {
                        if (!((Boolean)this.bright.getValue()).booleanValue()) {
                            int ii = 0;
                            while (ii < coefficients[i].length) {
                                coefficients[i][ii] = -coefficients[i][ii];
                                ++ii;
                            }
                        }
                        this.filter_wat(coefficients[i], i, sequence.getWidth(), sequence.getHeight());
                        ++i;
                    }
                    waveletTransform.b3SpotConstruction2D(coefficients, DetectionResult, numScales, image.getWidth() * image.getHeight(), this.UDWTScaleArrayList);
                }
                int i = 0;
                while (i < detectionResults[t].length) {
                    detectionResults[t][i] = DetectionResult[i];
                    ++i;
                }
                ++t;
            }
            return detectionResults;
        }
        return detectionResults;
    }

    private ArrayList<plugins.fab.spotDetector.Point3D> getTubesPositions(Sequence sequence, double[][] detectionResults, double minDistance, int height, int width) {
        double[] cumulativeSpot = new double[detectionResults[0].length];
        int j = 0;
        while (j < detectionResults[0].length) {
            cumulativeSpot[j] = 0.0;
            ++j;
        }
        double mean = 0.0;
        int inc = 0;
        int i = 0;
        while (i < detectionResults.length) {
            int ii = 0;
            while (ii < detectionResults[i].length) {
                int n = ii;
                cumulativeSpot[n] = cumulativeSpot[n] + detectionResults[i][ii];
                if (detectionResults[i][ii] > 0.0) {
                    mean += detectionResults[i][ii];
                    ++inc;
                }
                ++ii;
            }
            ++i;
        }
        mean /= (double)inc;
        double thresholdValue = this.getTubeThreshold();
        System.out.println(" - Max: " + ArrayMath.max((double[])cumulativeSpot));
        System.out.println(" - Mean: " + ArrayMath.mean((double[])cumulativeSpot));
        ArrayList<plugins.fab.spotDetector.Point3D> tubesPositions = new ArrayList<plugins.fab.spotDetector.Point3D>(50);
        IcyBufferedImage cumulativeImage = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);
        Array1DUtil.arrayToArray((Object)cumulativeSpot, (Object)cumulativeImage.getDataXY(0), (boolean)cumulativeImage.getDataType_().isSigned());
        cumulativeImage.dataChanged();
        double[] cumulativeTab = Array1DUtil.arrayToDoubleArray((Object)cumulativeImage.getDataXY(0), (boolean)cumulativeImage.isSignedDataType());
        LocalMaximaDetector lmd = new LocalMaximaDetector(cumulativeImage);
        lmd.detectLocalMaxima(minDistance);
        ArrayList roiArrayList = sequence.getROI2Ds();
        if (roiArrayList.size() == 0) {
            ROI2DRectangle roi = new ROI2DRectangle((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(sequence.getWidth(), sequence.getHeight()));
            roiArrayList.add(roi);
        }
        for (double[] max : lmd.maxima) {
            if (!(cumulativeTab[(int)max[0] + (int)max[1] * width] > mean * thresholdValue)) continue;
            plugins.fab.spotDetector.Point3D point = new plugins.fab.spotDetector.Point3D(max);
            for (ROI2D roi : roiArrayList) {
                if (!roi.contains(max[0], max[1])) continue;
                tubesPositions.add(point);
            }
        }
        return tubesPositions;
    }

    private void tubesUpdate2(Sequence sequence, ArrayList<Tube> Tubes, double maxDistance, int width, Vector<Spot> detections, int t) {
        ArrayList roiArrayList = sequence.getROI2Ds();
        HashMap<ROI2D, Vector<Spot>> ROI2Detection = this.detectionsInRoi(sequence, detections, roiArrayList);
        double d = maxDistance + 1.0;
        int index = 0;
        for (ROI2D roi : ROI2Detection.keySet()) {
            Vector<Spot> detect = ROI2Detection.get(roi);
            int isp = 0;
            while (isp < detect.size()) {
                Spot spot1 = detect.get(isp);
                plugins.fab.spotDetector.Point3D p = new plugins.fab.spotDetector.Point3D();
                p.x = spot1.mass_center.x;
                p.y = spot1.mass_center.y;
                d = maxDistance + 1.0;
                int j = 0;
                while (j < Tubes.size()) {
                    double dist;
                    if (Tubes.get((int)j).on && (dist = this.computeDistance(p, Tubes.get((int)j).position)) < d) {
                        d = dist;
                        index = j;
                    }
                    ++j;
                }
                if (d < maxDistance) {
                    if (Tubes.get((int)index).DetectionList == null) {
                        DetectionSpot spot = new DetectionSpot();
                        spot.points.add(p);
                        spot.computeMassCenter();
                        spot.setT(t);
                        spot.minIntensity = spot1.minIntensity;
                        spot.meanIntensity = spot1.meanIntensity;
                        spot.maxIntensity = spot1.maxIntensity;
                        Tubes.get(index).addNewSpotToTube(spot);
                    } else {
                        DetectionSpot spot = new DetectionSpot();
                        int pi = 0;
                        while (pi < spot1.point3DList.size()) {
                            plugins.fab.spotDetector.Point3D pt = new plugins.fab.spotDetector.Point3D();
                            pt.x = ((Point3D)spot1.point3DList.get((int)pi)).x;
                            pt.y = ((Point3D)spot1.point3DList.get((int)pi)).y;
                            spot.points.add(pt);
                            ++pi;
                        }
                        spot.computeMassCenter();
                        spot.setT(t);
                        spot.minIntensity = spot1.minIntensity;
                        spot.meanIntensity = spot1.meanIntensity;
                        spot.maxIntensity = spot1.maxIntensity;
                        ArrayList<DetectionSpot> DetectionListe = Tubes.get((int)index).DetectionList;
                        DetectionSpot s = DetectionListe.get(DetectionListe.size() - 1);
                        if (s.getT() == t) {
                            plugins.fab.spotDetector.Point3D pp = s.getMassCenter();
                            double dista = this.computeDistance(pp, Tubes.get((int)index).position);
                            if (d < dista) {
                                Tubes.get(index).setLastDetectionSpot(spot);
                            }
                        } else {
                            DetectionSpot lastSpot = Tubes.get(index).getLastDetectionSpot();
                            if ((double)(t - lastSpot.getT()) > this.getMaxGapClosing()) {
                                Tubes.get((int)index).on = false;
                                ArrayList<DetectionSpot> DetectionList = new ArrayList<DetectionSpot>();
                                DetectionList.add(spot);
                                Tube neo = new Tube(Tubes.get((int)index).position, DetectionList);
                                Tubes.add(neo);
                            } else {
                                Tubes.get(index).addNewSpotToTube(spot);
                            }
                        }
                    }
                }
                ++isp;
            }
        }
    }

    private HashMap<ROI2D, Vector<Spot>> detectionsInRoi(Sequence sequence, Vector<Spot> detection, ArrayList<ROI2D> roiArrayList) {
        HashMap<ROI2D, Vector<Spot>> ROI2Detection = new HashMap<ROI2D, Vector<Spot>>();
        if (roiArrayList.size() == 0) {
            ROI2Detection.put((ROI2D)new ROI2DRectangle((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(sequence.getWidth(), sequence.getHeight())), (Vector)detection.clone());
        } else {
            for (ROI2D roi : roiArrayList) {
                ROI2Detection.put(roi, new Vector());
            }
            for (ROI2D roi : roiArrayList) {
                for (Spot spot : detection) {
                    if (!roi.contains(spot.mass_center.x, spot.mass_center.y)) continue;
                    ROI2Detection.get(roi).add(spot);
                }
            }
        }
        detection.clear();
        for (ROI2D roi : ROI2Detection.keySet()) {
            for (Spot s : ROI2Detection.get(roi)) {
                detection.add(s);
            }
        }
        if (detection.size() == 0) {
            new AnnounceFrame("There is no detection associated with the ROI(s)");
        }
        return ROI2Detection;
    }

    private double computeDistance(plugins.fab.spotDetector.Point3D p3d, plugins.fab.spotDetector.Point3D coord) {
        double d = 0.0;
        d += (p3d.x - coord.x) * (p3d.x - coord.x);
        Math.sqrt(d += (p3d.y - coord.y) * (p3d.y - coord.y));
        return d;
    }

    public static void sendTracksToPool(final TrackGroup trackGroup, final Sequence sequence) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwimmingObject result = new SwimmingObject((Object)trackGroup);
                Icy.getMainInterface().getSwimmingPool().add(result);
                TrackManager manager = new TrackManager();
                if (sequence != null) {
                    manager.setDisplaySequence(sequence);
                }
                new AnnounceFrame("Tracking results exported to Track manager plugin");
            }
        });
    }

    public void clean() {
    }

    protected void execute() {
        int row = 0;
        WritableWorkbook WW = null;
        WritableSheet WS = null;
        if (((Boolean)this.exportExcel.getValue()).booleanValue()) {
            int page = 1;
            try {
                File f = (File)this.exportExcelFile.getValue(true);
                if (!FileUtil.getFileExtension((String)f.getPath(), (boolean)false).equalsIgnoreCase("xls")) {
                    f = new File(String.valueOf(f.getPath()) + ".xls");
                }
                WW = XLSUtil.loadWorkbookForWrite((File)f);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            WS = XLSUtil.createNewPage((WritableWorkbook)WW, (String)("Page" + page));
            XLSUtil.setCellString((WritableSheet)WS, (int)0, (int)0, (String)"Date of XLS page:");
            XLSUtil.setCellString((WritableSheet)WS, (int)0, (int)(++row), (String)new Date().toString());
            ++row;
        }
        this.UDWTScaleArrayList.clear();
        int i = 0;
        while (i < (Integer)this.scale.getValue() - 1) {
            UDWTScale sc = new UDWTScale(i + 1, false, ((Double)this.threshold.getValue()).doubleValue());
            this.UDWTScaleArrayList.add(sc);
            ++i;
        }
        UDWTScale sc = new UDWTScale(((Integer)this.scale.getValue()).intValue(), true, ((Double)this.threshold.getValue()).doubleValue());
        this.UDWTScaleArrayList.add(sc);
        double[][] detections = this.detectionResults((Sequence)this.sequence.getValue());
        int height = ((Sequence)this.sequence.getValue()).getHeight();
        int width = ((Sequence)this.sequence.getValue()).getWidth();
        Sequence SpotsSequence = new Sequence();
        SpotsSequence.setName("Spots");
        Sequence endoSequence = new Sequence();
        endoSequence.setName("Spots endo");
        Sequence CumulativeSpotsSequence = new Sequence();
        CumulativeSpotsSequence.setName("Cumulative Spots");
        IcyBufferedImage cumulativeSpots = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);
        double[] cumulativeSpot = new double[width * height];
        int i2 = 0;
        while (i2 < cumulativeSpot.length) {
            cumulativeSpot[i2] = 0.0;
            ++i2;
        }
        double minDist = this.getMinTubesDistance();
        double maxDist = this.getMaxSearchDistance();
        ArrayList<plugins.fab.spotDetector.Point3D> TubesPositions = this.getTubesPositions((Sequence)this.sequence.getValue(), detections, minDist, height, width);
        ArrayList<Tube> tubes = new ArrayList<Tube>();
        int j = 0;
        while (j < TubesPositions.size()) {
            plugins.fab.spotDetector.Point3D position = TubesPositions.get(j);
            Tube tube = new Tube(position);
            tubes.add(j, tube);
            ++j;
        }
        int t = 0;
        while (t < ((Sequence)this.sequence.getValue()).getSizeT()) {
            IcyBufferedImage image = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);
            Array1DUtil.arrayToArray((Object)detections[t], (Object)image.getDataXY(0), (boolean)image.getDataType_().isSigned());
            image.dataChanged();
            Sequence s = new Sequence(image);
            Map m = ConnectedComponents.extractConnectedComponents((Sequence)s, null);
            List l = (List)m.get(0);
            Vector<Spot> detectionsSpots = new Vector<Spot>();
            for (ConnectedComponent CC : l) {
                double[] minI = CC.computeMinIntensity((Sequence)this.sequence.getValue());
                double[] maxI = CC.computeMaxIntensity((Sequence)this.sequence.getValue());
                double[] meanI = CC.computeMeanIntensity((Sequence)this.sequence.getValue());
                Spot sp = new Spot(CC.getMassCenter().x, CC.getMassCenter().y, CC.getMassCenter().z, minI[0], maxI[0], meanI[0]);
                Point3i[] point3iArray = CC.getPoints();
                int n = point3iArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Point3i pt = point3iArray[n2];
                    Point3D p = new Point3D((double)pt.x, (double)pt.y, (double)pt.z);
                    sp.point3DList.add(p);
                    ++n2;
                }
                detectionsSpots.add(sp);
            }
            Vector detectionsSpotsFiltre = (Vector)detectionsSpots.clone();
            this.tubesUpdate2((Sequence)this.sequence.getValue(), tubes, maxDist, width, detectionsSpotsFiltre, t);
            IcyBufferedImage imageOut = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);
            int i3 = 0;
            while (i3 < cumulativeSpot.length) {
                int n = i3;
                cumulativeSpot[n] = cumulativeSpot[n] + detections[t][i3];
                ++i3;
            }
            Array1DUtil.arrayToArray((Object)detections[t], (Object)imageOut.getDataXY(0), (boolean)imageOut.getDataType_().isSigned());
            imageOut.dataChanged();
            SpotsSequence.setImage(t, 0, (BufferedImage)imageOut);
            ++t;
        }
        ArrayList TubesFiltre = (ArrayList)tubes.clone();
        for (Tube tube_ : TubesFiltre) {
            if (!((double)(tube_.t_final - tube_.t_init) < this.getMinTubesDuration()) && !((double)(tube_.t_final - tube_.t_init) > this.getMaxTubesDuration())) continue;
            tubes.remove(tube_);
        }
        TrackGroup tG = new TrackGroup((Sequence)this.sequence.getValue());
        tG.setDescription(((Sequence)this.sequence.getValue()).getName());
        for (Tube tube : tubes) {
            ArrayList<Detection> detectionList = new ArrayList<Detection>();
            if (tube.DetectionList == null) continue;
            for (DetectionSpot ds : tube.DetectionList) {
                plugins.fab.spotDetector.Point3D p3 = ds.getMassCenter();
                Detection d = new Detection(p3.x, p3.y, p3.z, ds.getT());
                detectionList.add(d);
            }
            TrackSegment ts = new TrackSegment(detectionList);
            tG.addTrackSegment(ts);
        }
        eTrack.sendTracksToPool(tG, (Sequence)this.sequence.getValue());
        if (((Boolean)this.displayCumulativeSpotsCheckBox.getValue()).booleanValue()) {
            Array1DUtil.arrayToArray((Object)cumulativeSpot, (Object)cumulativeSpots.getDataXY(0), (boolean)cumulativeSpots.getDataType_().isSigned());
            cumulativeSpots.dataChanged();
            CumulativeSpotsSequence.setImage(0, 0, (BufferedImage)cumulativeSpots);
            SpotsSequence.dataChanged();
            CumulativeSpotsSequence.dataChanged();
            SpotsSequence.removeAllROI();
            CumulativeSpotsSequence.removeAllROI();
            int r = 2;
            for (Tube tube : tubes) {
                if (!((double)tube.t_final < (double)((Sequence)this.sequence.getValue()).getSizeT() - this.getMaxGapClosing())) continue;
                tube.endo = true;
                plugins.fab.spotDetector.Point3D p = tube.position;
                Rectangle2D.Double rect = new Rectangle2D.Double(p.x - (double)r, p.y - (double)r, 2 * r, 2 * r);
                ROI2DRectangle roi = new ROI2DRectangle((Rectangle2D)rect);
                roi.setReadOnly(true);
                SpotsSequence.addROI((ROI)roi);
                CumulativeSpotsSequence.addROI((ROI)roi);
            }
            this.addSequence(CumulativeSpotsSequence);
        }
        if (((Boolean)this.displayEndoCheckBox.getValue()).booleanValue()) {
            Sequence endo2Sequence = new Sequence();
            endo2Sequence.setName("Spots endo2");
            int t2 = 0;
            while (t2 < ((Sequence)this.sequence.getValue()).getSizeT()) {
                IcyBufferedImage imageOut2 = new IcyBufferedImage(width, height, 1, DataType.DOUBLE);
                imageOut2.dataChanged();
                endo2Sequence.setImage(t2, 0, (BufferedImage)imageOut2);
                ++t2;
            }
            for (Tube tube : tubes) {
                if (!tube.endo) continue;
                int t3 = tube.t_init;
                while (t3 < tube.t_final) {
                    IcyBufferedImage imageEndo2 = endo2Sequence.getImage(t3, 0);
                    IcyBufferedImage imageIn = SpotsSequence.getImage(t3, 0);
                    double[] tabOutEndo = Array1DUtil.arrayToDoubleArray((Object)imageEndo2.getDataXY(0), (boolean)imageEndo2.isSignedDataType());
                    double[] tabIn = Array1DUtil.arrayToDoubleArray((Object)imageIn.getDataXY(0), (boolean)imageIn.isSignedDataType());
                    for (DetectionSpot spot : tube.DetectionList) {
                        for (plugins.fab.spotDetector.Point3D p : spot.points) {
                            int x = (int)p.x;
                            int y = (int)p.y;
                            tabOutEndo[x + y * width] = tabIn[x + y * width];
                        }
                    }
                    Array1DUtil.arrayToArray((Object)tabOutEndo, (Object)imageEndo2.getDataXY(0), (boolean)imageEndo2.getDataType_().isSigned());
                    imageEndo2.dataChanged();
                    ++t3;
                }
            }
            endo2Sequence.dataChanged();
            this.addSequence(endo2Sequence);
        }
        if (((Boolean)this.exportExcel.getValue()).booleanValue()) {
            int nb = 1;
            int col = 0;
            XLSUtil.setCellString((WritableSheet)WS, (int)col, (int)row, (String)"tube : ");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 1), (int)row, (String)"position x: ");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 2), (int)row, (String)"position y: ");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 3), (int)row, (String)"t_init  ");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 4), (int)row, (String)"t_final  ");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 5), (int)row, (String)"duration ");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 6), (int)row, (String)"nb spots ");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 7), (int)row, (String)"mean spots size");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 8), (int)row, (String)"max spots size");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 9), (int)row, (String)"mean intensity");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 10), (int)row, (String)"max intensity");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 11), (int)row, (String)" mean spots size*mean intensity ");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 12), (int)row, (String)"ratio");
            XLSUtil.setCellString((WritableSheet)WS, (int)(col + 13), (int)row, (String)"endocytosis");
            ++row;
            for (Tube tube : tubes) {
                XLSUtil.setCellNumber((WritableSheet)WS, (int)col, (int)row, (double)nb);
                XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 1), (int)row, (double)tube.position.x);
                XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 2), (int)row, (double)tube.position.y);
                XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 3), (int)row, (double)tube.t_init);
                XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 4), (int)row, (double)tube.t_final);
                double duration = tube.t_final - tube.t_init + 1;
                XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 5), (int)row, (double)duration);
                if (tube.DetectionList != null) {
                    double[] arrayMeanSizeSpot = new double[tube.DetectionList.size()];
                    double[] arrayMaxSizeSpot = new double[tube.DetectionList.size()];
                    double[] arrayMeanIntensitySpot = new double[tube.DetectionList.size()];
                    double[] arrayMaxIntensitySpot = new double[tube.DetectionList.size()];
                    int ind = 0;
                    for (DetectionSpot spot : tube.DetectionList) {
                        arrayMeanSizeSpot[ind] = spot.points.size();
                        arrayMaxSizeSpot[ind] = spot.points.size();
                        arrayMeanIntensitySpot[ind] = spot.meanIntensity;
                        arrayMaxIntensitySpot[ind] = spot.maxIntensity;
                        ++ind;
                    }
                    XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 6), (int)row, (double)ind);
                    if (ind > 0) {
                        XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 7), (int)row, (double)ArrayMath.mean((double[])arrayMeanSizeSpot));
                        XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 8), (int)row, (double)ArrayMath.max((double[])arrayMaxSizeSpot));
                        XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 9), (int)row, (double)ArrayMath.mean((double[])arrayMeanIntensitySpot));
                        XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 10), (int)row, (double)ArrayMath.max((double[])arrayMaxIntensitySpot));
                        XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 11), (int)row, (double)(ArrayMath.mean((double[])arrayMeanIntensitySpot) * ArrayMath.mean((double[])arrayMeanSizeSpot)));
                    }
                    XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 12), (int)row, (double)((double)ind / duration));
                }
                if (tube.endo) {
                    XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 13), (int)row, (double)1.0);
                } else {
                    XLSUtil.setCellNumber((WritableSheet)WS, (int)(col + 13), (int)row, (double)0.0);
                }
                ++row;
                ++nb;
            }
        }
        if (((Boolean)this.exportExcel.getValue()).booleanValue()) {
            try {
                XLSUtil.saveAndClose((WritableWorkbook)WW);
            }
            catch (WriteException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void initialize() {
        super.addEzComponent((EzComponent)this.sequence);
        super.addEzComponent((EzComponent)this.bright);
        super.addEzComponent((EzComponent)this.scale);
        super.addEzComponent((EzComponent)this.threshold);
        super.addEzComponent((EzComponent)this.displayCumulativeSpotsCheckBox);
        super.addEzComponent((EzComponent)this.displayEndoCheckBox);
        this.addEzComponent((EzComponent)new EzGroup("Advanced parameters", new EzComponent[]{this.advanced, this.TubeThreshold, this.minTubesDistance, this.maxSearchDistance, this.maxGap, this.minDuration, this.maxDuration}));
        this.advanced.addVisibilityTriggerTo((EzComponent)this.TubeThreshold, (Object[])new Boolean[]{true});
        this.advanced.addVisibilityTriggerTo((EzComponent)this.minTubesDistance, (Object[])new Boolean[]{true});
        this.advanced.addVisibilityTriggerTo((EzComponent)this.maxSearchDistance, (Object[])new Boolean[]{true});
        this.advanced.addVisibilityTriggerTo((EzComponent)this.maxGap, (Object[])new Boolean[]{true});
        this.advanced.addVisibilityTriggerTo((EzComponent)this.minDuration, (Object[])new Boolean[]{true});
        this.advanced.addVisibilityTriggerTo((EzComponent)this.maxDuration, (Object[])new Boolean[]{true});
        this.addEzComponent((EzComponent)new EzGroup("Export", new EzComponent[]{this.exportExcel, this.exportExcelFile}));
        this.exportExcel.addVisibilityTriggerTo((EzComponent)this.exportExcelFile, (Object[])new Boolean[]{true});
    }

    private class ImageMathInfo {
        double mad;

        private ImageMathInfo() {
        }
    }
}

