/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BoundProjector;

public class SimpleLowerBound
extends BoundProjector {
    private final double lowerBound;
    private final boolean single;

    public SimpleLowerBound(ShapedVectorSpace vsp, double lowerBound) {
        super(vsp);
        if (vsp.getType() == 5) {
            this.single = false;
        } else if (vsp.getType() == 4) {
            this.single = true;
        } else {
            throw new IllegalArgumentException("Only double/double type supported");
        }
        this.checkLowerBound(lowerBound, this.single);
        this.lowerBound = lowerBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    protected void _projectVariables(Vector dst, Vector src) {
        int n = src.getNumber();
        if (this.single) {
            float xmin = this.convertToFloat(this.getLowerBound());
            float[] x = ((FloatShapedVector)src).getData();
            float[] xp = ((FloatShapedVector)dst).getData();
            int j = 0;
            while (j < n) {
                xp[j] = SimpleLowerBound.max(x[j], xmin);
                ++j;
            }
        } else {
            double xmin = this.getLowerBound();
            double[] x = ((DoubleShapedVector)src).getData();
            double[] xp = ((DoubleShapedVector)dst).getData();
            int j = 0;
            while (j < n) {
                xp[j] = SimpleLowerBound.max(x[j], xmin);
                ++j;
            }
        }
    }

    @Override
    protected void _projectDirection(Vector vx, Vector vd, boolean ascent, Vector vdp, double[] bnd) {
        int n = vx.getNumber();
        if (this.single) {
            float zero = 0.0f;
            float xmin = this.convertToFloat(this.getLowerBound());
            float[] x = ((FloatShapedVector)vx).getData();
            float[] d = ((FloatShapedVector)vd).getData();
            float[] dp = ((FloatShapedVector)vdp).getData();
            if (bnd == null) {
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] < 0.0f || x[j] > xmin ? d[j] : 0.0f;
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] > 0.0f || x[j] > xmin ? d[j] : 0.0f;
                        ++j;
                    }
                }
            } else {
                float amin = Float.POSITIVE_INFINITY;
                float amax = 0.0f;
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        if (d[j] < 0.0f) {
                            dp[j] = d[j];
                            amax = Float.POSITIVE_INFINITY;
                        } else if (d[j] > 0.0f) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Float.NEGATIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    float tmp = (x[j] - xmin) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else {
                            dp[j] = 0.0f;
                        }
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        if (d[j] > 0.0f) {
                            dp[j] = d[j];
                            amax = Float.POSITIVE_INFINITY;
                        } else if (d[j] < 0.0f) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Float.NEGATIVE_INFINITY) {
                                    amax = Float.POSITIVE_INFINITY;
                                } else {
                                    float tmp = (xmin - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0f;
                            }
                        } else {
                            dp[j] = 0.0f;
                        }
                        ++j;
                    }
                }
                bnd[0] = amin;
                bnd[1] = amax;
            }
        } else {
            double zero = 0.0;
            double xmin = this.getLowerBound();
            double[] x = ((DoubleShapedVector)vx).getData();
            double[] d = ((DoubleShapedVector)vd).getData();
            double[] dp = ((DoubleShapedVector)vdp).getData();
            if (bnd == null) {
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] < 0.0 || x[j] > xmin ? d[j] : 0.0;
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        dp[j] = d[j] > 0.0 || x[j] > xmin ? d[j] : 0.0;
                        ++j;
                    }
                }
            } else {
                double amin = Double.POSITIVE_INFINITY;
                double amax = 0.0;
                if (ascent) {
                    int j = 0;
                    while (j < n) {
                        if (d[j] < 0.0) {
                            dp[j] = d[j];
                            amax = Double.POSITIVE_INFINITY;
                        } else if (d[j] > 0.0) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Double.NEGATIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    double tmp = (x[j] - xmin) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else {
                            dp[j] = 0.0;
                        }
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < n) {
                        if (d[j] > 0.0) {
                            dp[j] = d[j];
                            amax = Double.POSITIVE_INFINITY;
                        } else if (d[j] < 0.0) {
                            if (x[j] > xmin) {
                                dp[j] = d[j];
                                if (xmin == Double.NEGATIVE_INFINITY) {
                                    amax = Double.POSITIVE_INFINITY;
                                } else {
                                    double tmp = (xmin - x[j]) / d[j];
                                    if (tmp < amin) {
                                        amin = tmp;
                                    }
                                    if (tmp > amax) {
                                        amax = tmp;
                                    }
                                }
                            } else {
                                dp[j] = 0.0;
                            }
                        } else {
                            dp[j] = 0.0;
                        }
                        ++j;
                    }
                }
                bnd[0] = amin;
                bnd[1] = amax;
            }
        }
    }
}

