/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array7D;
import mitiv.array.Byte7D;
import mitiv.array.Double7D;
import mitiv.array.Float7D;
import mitiv.array.Int7D;
import mitiv.array.Long7D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.Short6D;
import mitiv.array.ShortArray;
import mitiv.array.impl.FlatShort7D;
import mitiv.array.impl.StriddenShort7D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short7D
extends Array7D
implements ShortArray {
    protected Short7D(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        super(dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    protected Short7D(int[] dims) {
        super(dims);
    }

    protected Short7D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, short var8);

    @Override
    public void fill(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, value);
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, value);
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void increment(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, (short)(this.get(i1, i2, i3, i4, i5, i6, i7) + value));
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, (short)(this.get(i1, i2, i3, i4, i5, i6, i7) + value));
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void decrement(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, (short)(this.get(i1, i2, i3, i4, i5, i6, i7) - value));
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, (short)(this.get(i1, i2, i3, i4, i5, i6, i7) - value));
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void scale(short value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, (short)(this.get(i1, i2, i3, i4, i5, i6, i7) * value));
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, (short)(this.get(i1, i2, i3, i4, i5, i6, i7) * value));
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void map(ShortFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7)));
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7)));
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void fill(ShortGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, generator.nextShort());
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, generator.nextShort());
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void scan(ShortScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        if (initialized) {
                                            scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7));
                                        } else {
                                            scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7));
                                            initialized = true;
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        if (initialized) {
                                            scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7));
                                        } else {
                                            scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7));
                                            initialized = true;
                                        }
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public short[] flatten(boolean forceCopy) {
        short[] out = new short[this.number];
        int i = -1;
        int i7 = 0;
        while (i7 < this.dim7) {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
            ++i7;
        }
        return out;
    }

    @Override
    public short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short minValue = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        if (skip) {
                                            skip = false;
                                        } else {
                                            short value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                            if (value < minValue) {
                                                minValue = value;
                                            }
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        if (skip) {
                                            skip = false;
                                        } else {
                                            short value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                            if (value < minValue) {
                                                minValue = value;
                                            }
                                        }
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
        return minValue;
    }

    @Override
    public short max() {
        short maxValue = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        if (skip) {
                                            skip = false;
                                        } else {
                                            short value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                            if (value > maxValue) {
                                                maxValue = value;
                                            }
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        if (skip) {
                                            skip = false;
                                        } else {
                                            short value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                            if (value > maxValue) {
                                                maxValue = value;
                                            }
                                        }
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
        return maxValue;
    }

    @Override
    public short[] getMinAndMax() {
        short[] result = new short[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(short[] mm) {
        short minValue;
        short maxValue = minValue = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        if (skip) {
                                            skip = false;
                                        } else {
                                            short value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                            if (value < minValue) {
                                                minValue = value;
                                            }
                                            if (value > maxValue) {
                                                maxValue = value;
                                            }
                                        }
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        if (skip) {
                                            skip = false;
                                        } else {
                                            short value = this.get(i1, i2, i3, i4, i5, i6, i7);
                                            if (value < minValue) {
                                                minValue = value;
                                            }
                                            if (value > maxValue) {
                                                maxValue = value;
                                            }
                                        }
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = 0;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        totalValue += this.get(i1, i2, i3, i4, i5, i6, i7);
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        totalValue += this.get(i1, i2, i3, i4, i5, i6, i7);
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte7D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i7 = 0;
        while (i7 < this.dim7) {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    out[++i] = (byte)this.get(i1, i2, i3, i4, i5, i6, i7);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
            ++i7;
        }
        return Byte7D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7);
    }

    @Override
    public Short7D toShort() {
        return this;
    }

    @Override
    public Int7D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i7 = 0;
        while (i7 < this.dim7) {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
            ++i7;
        }
        return Int7D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7);
    }

    @Override
    public Long7D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i7 = 0;
        while (i7 < this.dim7) {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
            ++i7;
        }
        return Long7D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7);
    }

    @Override
    public Float7D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i7 = 0;
        while (i7 < this.dim7) {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
            ++i7;
        }
        return Float7D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7);
    }

    @Override
    public Double7D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i7 = 0;
        while (i7 < this.dim7) {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
            ++i7;
        }
        return Double7D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7);
    }

    @Override
    public Short7D copy() {
        return new FlatShort7D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Short7D src = arr.getType() == 1 ? (Short7D)arr : (Short7D)arr.toShort();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    int i7 = 0;
                                    while (i7 < this.dim7) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, src.get(i1, i2, i3, i4, i5, i6, i7));
                                        ++i7;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, src.get(i1, i2, i3, i4, i5, i6, i7));
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, (short)src.get(++i));
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i7 = 0;
            while (i7 < this.dim7) {
                int i6 = 0;
                while (i6 < this.dim6) {
                    int i5 = 0;
                    while (i5 < this.dim5) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i3 = 0;
                            while (i3 < this.dim3) {
                                int i2 = 0;
                                while (i2 < this.dim2) {
                                    int i1 = 0;
                                    while (i1 < this.dim1) {
                                        this.set(i1, i2, i3, i4, i5, i6, i7, (short)src.get(++i));
                                        ++i1;
                                    }
                                    ++i2;
                                }
                                ++i3;
                            }
                            ++i4;
                        }
                        ++i5;
                    }
                    ++i6;
                }
                ++i7;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short7D create() {
        return new FlatShort7D(this.getShape());
    }

    public static Short7D create(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return new FlatShort7D(dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    public static Short7D create(int[] dims) {
        return new FlatShort7D(dims);
    }

    public static Short7D create(Shape shape) {
        return new FlatShort7D(shape);
    }

    public static Short7D wrap(short[] data, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return new FlatShort7D(data, dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    public static Short7D wrap(short[] data, int[] dims) {
        return new FlatShort7D(data, dims);
    }

    public static Short7D wrap(short[] data, Shape shape) {
        return new FlatShort7D(data, shape);
    }

    public static Short7D wrap(short[] data, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int stride6, int stride7, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7) {
        return new StriddenShort7D(data, offset, stride1, stride2, stride3, stride4, stride5, stride6, stride7, dim1, dim2, dim3, dim4, dim5, dim6, dim7);
    }

    @Override
    public abstract Short6D slice(int var1);

    @Override
    public abstract Short6D slice(int var1, int var2);

    @Override
    public abstract Short7D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7);

    @Override
    public abstract Short7D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    @Override
    public abstract Short1D as1D();
}

