/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.function.tdouble.LongDoubleProcedure;
import cern.colt.map.tdouble.AbstractLongDoubleMap;
import cern.colt.map.tdouble.OpenLongDoubleHashMap;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SelectedSparseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCMDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCMDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.math.tdouble.DoubleMult;
import cern.jet.math.tdouble.DoublePlusMultSecond;
import java.io.IOException;

public class SparseDoubleMatrix2D
extends DoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongDoubleMap elements;

    public SparseDoubleMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseDoubleMatrix2D(int rows, int columns) {
        this(rows, columns, rows * (columns / 1000), 0.2, 0.5);
    }

    public SparseDoubleMatrix2D(int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongDoubleHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    public SparseDoubleMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, double value) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongDoubleHashMap(rowIndexes.length);
        this.insert(rowIndexes, columnIndexes, value);
    }

    public SparseDoubleMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, double[] values) {
        block2: {
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new OpenLongDoubleHashMap(rowIndexes.length);
        this.insert(rowIndexes, columnIndexes, values);
    }

    public SparseDoubleMatrix2D(MatrixVectorReader reader) throws IOException {
        block11: {
            double[] values;
            int[] rowIndexes;
            int[] columnIndexes;
            int numEntries;
            MatrixInfo info;
            block10: {
                MatrixSize size;
                block9: {
                    info = reader.hasInfo() ? reader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                    if (info.isPattern()) {
                        throw new UnsupportedOperationException("Pattern matrices are not supported");
                    }
                    if (info.isDense()) {
                        throw new UnsupportedOperationException("Dense matrices are not supported");
                    }
                    if (info.isComplex()) {
                        throw new UnsupportedOperationException("Complex matrices are not supported");
                    }
                    size = reader.readMatrixSize(info);
                    try {
                        this.setUp(size.numRows(), size.numColumns());
                    }
                    catch (IllegalArgumentException exc) {
                        if ("matrix too large".equals(exc.getMessage())) break block9;
                        throw exc;
                    }
                }
                numEntries = size.numEntries();
                columnIndexes = new int[numEntries];
                rowIndexes = new int[numEntries];
                values = new double[numEntries];
                reader.readCoordinate(rowIndexes, columnIndexes, values);
                this.elements = info.isSymmetric() || info.isSkewSymmetric() ? new OpenLongDoubleHashMap(2 * rowIndexes.length) : new OpenLongDoubleHashMap(rowIndexes.length);
                this.insert(rowIndexes, columnIndexes, values);
                if (!info.isSymmetric()) break block10;
                int i = 0;
                while (i < numEntries) {
                    if (rowIndexes[i] != columnIndexes[i]) {
                        this.set(columnIndexes[i], rowIndexes[i], values[i]);
                    }
                    ++i;
                }
                break block11;
            }
            if (!info.isSkewSymmetric()) break block11;
            int i = 0;
            while (i < numEntries) {
                if (rowIndexes[i] != columnIndexes[i]) {
                    this.set(columnIndexes[i], rowIndexes[i], -values[i]);
                }
                ++i;
            }
        }
    }

    protected SparseDoubleMatrix2D(int rows, int columns, AbstractLongDoubleMap elements, int rowZero, int columnZero, int rowStride, int columnStride) {
        block2: {
            try {
                this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public DoubleMatrix2D assign(DoubleFunction function) {
        if (this.isNoView && function instanceof DoubleMult) {
            this.elements.assign(function);
        } else {
            super.assign(function);
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(double value) {
        if (this.isNoView && value == 0.0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D source) {
        if (!(source instanceof SparseDoubleMatrix2D)) {
            return super.assign(source);
        }
        SparseDoubleMatrix2D other = (SparseDoubleMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.isNoView && other.isNoView) {
            this.elements.assign(other.elements);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public DoubleMatrix2D assign(final DoubleMatrix2D y, DoubleDoubleFunction function) {
        if (!this.isNoView) {
            return super.assign(y, function);
        }
        this.checkShape(y);
        if (function instanceof DoublePlusMultSecond) {
            final double alpha = ((DoublePlusMultSecond)function).multiplicator;
            if (alpha == 0.0) {
                return this;
            }
            y.forEachNonZero(new IntIntDoubleFunction(){

                @Override
                public double apply(int i, int j, double value) {
                    SparseDoubleMatrix2D.this.setQuick(i, j, SparseDoubleMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
        } else if (function == DoubleFunctions.mult) {
            this.elements.forEachPair(new LongDoubleProcedure(){

                @Override
                public boolean apply(long key, double value) {
                    int j;
                    int i = (int)(key / (long)SparseDoubleMatrix2D.this.columns);
                    double r = value * y.getQuick(i, j = (int)(key % (long)SparseDoubleMatrix2D.this.columns));
                    if (r != value) {
                        SparseDoubleMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else if (function == DoubleFunctions.div) {
            this.elements.forEachPair(new LongDoubleProcedure(){

                @Override
                public boolean apply(long key, double value) {
                    int j;
                    int i = (int)(key / (long)SparseDoubleMatrix2D.this.columns);
                    double r = value / y.getQuick(i, j = (int)(key % (long)SparseDoubleMatrix2D.this.columns));
                    if (r != value) {
                        SparseDoubleMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else {
            super.assign(y, function);
        }
        return this;
    }

    public SparseDoubleMatrix2D assign(int[] rowIndexes, int[] columnIndexes, double value, DoubleDoubleFunction function) {
        int size = rowIndexes.length;
        if (function == DoubleFunctions.plus) {
            int i = 0;
            while (i < size) {
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                double elem = this.elements.get(index);
                double sum = elem + value;
                if (sum != 0.0) {
                    this.elements.put(index, sum);
                } else {
                    this.elements.removeKey(index);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                double elem = this.elements.get(index);
                double result = function.apply(elem, value);
                if (result != 0.0) {
                    this.elements.put(index, result);
                } else {
                    this.elements.removeKey(index);
                }
                ++i;
            }
        }
        return this;
    }

    public SparseDoubleMatrix2D assign(int[] rowIndexes, int[] columnIndexes, double[] values, DoubleDoubleFunction function) {
        int size = rowIndexes.length;
        if (function == DoubleFunctions.plus) {
            int i = 0;
            while (i < size) {
                double value = values[i];
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                double elem = this.elements.get(index);
                if ((value += elem) != 0.0) {
                    this.elements.put(index, value);
                } else {
                    this.elements.removeKey(index);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                double value = values[i];
                long row = rowIndexes[i];
                long column = columnIndexes[i];
                if (row >= (long)this.rows || column >= (long)this.columns) {
                    throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
                }
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                double elem = this.elements.get(index);
                value = function.apply(elem, value);
                if (value != 0.0) {
                    this.elements.put(index, value);
                } else {
                    this.elements.removeKey(index);
                }
                ++i;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public SparseCCDoubleMatrix2D getColumnCompressed(boolean sortRowIndexes) {
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        double[] values = this.elements.values().elements();
        int[] rowIndexes = new int[nnz];
        int[] columnIndexes = new int[nnz];
        int k = 0;
        while (k < nnz) {
            long key = keys[k];
            rowIndexes[k] = (int)(key / (long)this.columns);
            columnIndexes[k] = (int)(key % (long)this.columns);
            ++k;
        }
        return new SparseCCDoubleMatrix2D(this.rows, this.columns, rowIndexes, columnIndexes, values, false, false, sortRowIndexes);
    }

    public SparseCCMDoubleMatrix2D getColumnCompressedModified() {
        SparseCCMDoubleMatrix2D A = new SparseCCMDoubleMatrix2D(this.rows, this.columns);
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        double[] values = this.elements.values().elements();
        int i = 0;
        while (i < nnz) {
            int row = (int)(keys[i] / (long)this.columns);
            int column = (int)(keys[i] % (long)this.columns);
            A.setQuick(row, column, values[i]);
            ++i;
        }
        return A;
    }

    public SparseRCDoubleMatrix2D getRowCompressed(boolean sortColumnIndexes) {
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        double[] values = this.elements.values().elements();
        int[] rowIndexes = new int[nnz];
        int[] columnIndexes = new int[nnz];
        int k = 0;
        while (k < nnz) {
            long key = keys[k];
            rowIndexes[k] = (int)(key / (long)this.columns);
            columnIndexes[k] = (int)(key % (long)this.columns);
            ++k;
        }
        return new SparseRCDoubleMatrix2D(this.rows, this.columns, rowIndexes, columnIndexes, values, false, false, sortColumnIndexes);
    }

    public SparseRCMDoubleMatrix2D getRowCompressedModified() {
        SparseRCMDoubleMatrix2D A = new SparseRCMDoubleMatrix2D(this.rows, this.columns);
        int nnz = this.cardinality();
        long[] keys = this.elements.keys().elements();
        double[] values = this.elements.values().elements();
        int i = 0;
        while (i < nnz) {
            int row = (int)(keys[i] / (long)this.columns);
            int column = (int)(keys[i] % (long)this.columns);
            A.setQuick(row, column, values[i]);
            ++i;
        }
        return A;
    }

    @Override
    public AbstractLongDoubleMap elements() {
        return this.elements;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction function) {
        if (this.isNoView) {
            this.elements.forEachPair(new LongDoubleProcedure(){

                @Override
                public boolean apply(long key, double value) {
                    int j;
                    int i = (int)(key / (long)SparseDoubleMatrix2D.this.columns);
                    double r = function.apply(i, j = (int)(key % (long)SparseDoubleMatrix2D.this.columns), value);
                    if (r != value) {
                        SparseDoubleMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else {
            super.forEachNonZero(function);
        }
        return this;
    }

    @Override
    public synchronized double getQuick(int row, int column) {
        return this.elements.get((long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride);
    }

    @Override
    public long index(int row, int column) {
        return (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
    }

    @Override
    public DoubleMatrix2D like(int rows, int columns) {
        return new SparseDoubleMatrix2D(rows, columns);
    }

    @Override
    public DoubleMatrix1D like1D(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    @Override
    public synchronized void setQuick(int row, int column, double value) {
        long index = (long)this.rowZero + (long)row * (long)this.rowStride + (long)this.columnZero + (long)column * (long)this.columnStride;
        if (value == 0.0) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.columns) {
                double elem = this.getQuick(r, c);
                if (elem != 0.0) {
                    builder.append('(').append(r).append(',').append(c).append(')').append('\t').append(elem).append('\n');
                }
                ++c;
            }
            ++r;
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    public DoubleMatrix1D vectorize() {
        SparseDoubleMatrix1D v = new SparseDoubleMatrix1D((int)this.size());
        int idx = 0;
        int c = 0;
        while (c < this.columns) {
            int r = 0;
            while (r < this.rows) {
                double elem = this.getQuick(r, c);
                v.setQuick(idx++, elem);
                ++r;
            }
            ++c;
        }
        return v;
    }

    @Override
    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, final double alpha, double beta, final boolean transposeA) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        boolean bl = ignore = z == null;
        if (z == null) {
            z = new DenseDoubleMatrix1D(rowsA);
        }
        if (!(this.isNoView && y instanceof DenseDoubleMatrix1D && z instanceof DenseDoubleMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!ignore) {
            z.assign(DoubleFunctions.mult(beta));
        }
        DenseDoubleMatrix1D zz = (DenseDoubleMatrix1D)z;
        final double[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)z.index(0);
        DenseDoubleMatrix1D yy = (DenseDoubleMatrix1D)y;
        final double[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)y.index(0);
        if (elementsY == null || elementsZ == null) {
            throw new InternalError();
        }
        this.elements.forEachPair(new LongDoubleProcedure(){

            @Override
            public boolean apply(long key, double value) {
                int i = (int)(key / (long)SparseDoubleMatrix2D.this.columns);
                int j = (int)(key % (long)SparseDoubleMatrix2D.this.columns);
                if (transposeA) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + alpha * value * elementsY[zeroY + strideY * j];
                return true;
            }
        });
        return z;
    }

    @Override
    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, final double alpha, double beta, final boolean transposeA, boolean transposeB) {
        boolean ignore;
        if (!this.isNoView) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (transposeB) {
            B = B.viewDice();
        }
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int p = B.columns();
        boolean bl = ignore = C == null;
        if (C == null) {
            C = new DenseDoubleMatrix2D(rowsA, p);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore) {
            C.assign(DoubleFunctions.mult(beta));
        }
        final DoubleMatrix1D[] Brows = new DoubleMatrix1D[columnsA];
        int i = columnsA;
        while (--i >= 0) {
            Brows[i] = B.viewRow(i);
        }
        final DoubleMatrix1D[] Crows = new DoubleMatrix1D[rowsA];
        int i2 = rowsA;
        while (--i2 >= 0) {
            Crows[i2] = C.viewRow(i2);
        }
        final DoublePlusMultSecond fun = DoublePlusMultSecond.plusMult(0.0);
        this.elements.forEachPair(new LongDoubleProcedure(){

            @Override
            public boolean apply(long key, double value) {
                int i = (int)(key / (long)SparseDoubleMatrix2D.this.columns);
                int j = (int)(key % (long)SparseDoubleMatrix2D.this.columns);
                fun.multiplicator = value * alpha;
                if (!transposeA) {
                    Crows[i].assign(Brows[j], fun);
                } else {
                    Crows[j].assign(Brows[i], fun);
                }
                return true;
            }
        });
        return C;
    }

    private void insert(int[] rowIndexes, int[] columnIndexes, double value) {
        int size = rowIndexes.length;
        int i = 0;
        while (i < size) {
            long row = rowIndexes[i];
            long column = columnIndexes[i];
            if (row >= (long)this.rows || column >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
            }
            if (value != 0.0) {
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                double elem = this.elements.get(index);
                if (elem == 0.0) {
                    this.elements.put(index, value);
                } else {
                    double sum = elem + value;
                    if (sum == 0.0) {
                        this.elements.removeKey(index);
                    } else {
                        this.elements.put(index, sum);
                    }
                }
            }
            ++i;
        }
    }

    private void insert(int[] rowIndexes, int[] columnIndexes, double[] values) {
        int size = rowIndexes.length;
        int i = 0;
        while (i < size) {
            double value = values[i];
            long row = rowIndexes[i];
            long column = columnIndexes[i];
            if (row >= (long)this.rows || column >= (long)this.columns) {
                throw new IndexOutOfBoundsException("row: " + row + ", column: " + column);
            }
            if (value != 0.0) {
                long index = (long)this.rowZero + row * (long)this.rowStride + (long)this.columnZero + column * (long)this.columnStride;
                double elem = this.elements.get(index);
                if (elem == 0.0) {
                    this.elements.put(index, value);
                } else {
                    double sum = elem + value;
                    if (sum == 0.0) {
                        this.elements.removeKey(index);
                    } else {
                        this.elements.put(index, sum);
                    }
                }
            }
            ++i;
        }
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix2D other) {
        if (other instanceof SelectedSparseDoubleMatrix2D) {
            SelectedSparseDoubleMatrix2D otherMatrix = (SelectedSparseDoubleMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDoubleMatrix2D) {
            SparseDoubleMatrix2D otherMatrix = (SparseDoubleMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected DoubleMatrix1D like1D(int size, int offset, int stride) {
        return new SparseDoubleMatrix1D(size, this.elements, offset, stride);
    }

    @Override
    protected DoubleMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseDoubleMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

