/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.ShapedArray;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.random.DoubleGenerator;

public class DoubleShapedVector
extends ShapedVector {
    protected double[] data;

    public DoubleShapedVector(DoubleShapedVectorSpace owner) {
        super(owner);
        this.data = new double[owner.getNumber()];
    }

    public DoubleShapedVector(DoubleShapedVectorSpace owner, double[] data) {
        super(owner);
        if (data == null || data.length != owner.getNumber()) {
            throw new IllegalArgumentException("Array size not compatible with vector space.");
        }
        this.data = data;
    }

    @Override
    public DoubleShapedVectorSpace getOwner() {
        return (DoubleShapedVectorSpace)this.space;
    }

    @Override
    public DoubleShapedVectorSpace getSpace() {
        return this.getOwner();
    }

    @Override
    public final double get(int i) {
        return this.data[i];
    }

    @Override
    public final void set(int i, double value) {
        this.data[i] = value;
    }

    public void set(double[] arr) {
        ArrayOps.copy(this.data, arr);
    }

    public double[] getData() {
        return this.data;
    }

    public void fill(DoubleGenerator generator) {
        int k = 0;
        while (k < this.number) {
            this.data[k] = generator.nextDouble();
            ++k;
        }
    }

    @Override
    public DoubleShapedVector clone() {
        return ((DoubleShapedVectorSpace)this.space)._clone(this);
    }

    @Override
    public void assign(ShapedArray arr) {
        ((ShapedVectorSpace)this.space).checkShape(arr);
        double[] arrData = arr.toDouble().flatten();
        if (arrData != this.data) {
            System.arraycopy(arrData, 0, this.data, 0, this.getNumber());
        }
    }
}

