/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleCGS
extends AbstractDoubleIterativeSolver {
    private DoubleMatrix1D p;
    private DoubleMatrix1D q;
    private DoubleMatrix1D u;
    private DoubleMatrix1D phat;
    private DoubleMatrix1D qhat;
    private DoubleMatrix1D vhat;
    private DoubleMatrix1D uhat;
    private DoubleMatrix1D sum;
    private DoubleMatrix1D r;
    private DoubleMatrix1D rtilde;

    public DoubleCGS(DoubleMatrix1D template) {
        this.p = template.copy();
        this.q = template.copy();
        this.u = template.copy();
        this.phat = template.copy();
        this.qhat = template.copy();
        this.vhat = template.copy();
        this.uhat = template.copy();
        this.sum = template.copy();
        this.r = template.copy();
        this.rtilde = template.copy();
    }

    @Override
    public DoubleMatrix1D solve(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(A, b, x);
        double rho_1 = 0.0;
        double rho_2 = 0.0;
        double alpha = 0.0;
        double beta = 0.0;
        A.zMult(x, this.r.assign(b), -1.0, 1.0, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            rho_1 = this.rtilde.zDotProduct(this.r);
            if (rho_1 == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (this.iter.isFirst()) {
                this.u.assign(this.r);
                this.p.assign(this.u);
            } else {
                beta = rho_1 / rho_2;
                this.u.assign(this.r).assign(this.q, DoubleFunctions.plusMultSecond(beta));
                this.sum.assign(this.q).assign(this.p, DoubleFunctions.plusMultSecond(beta));
                this.p.assign(this.u).assign(this.sum, DoubleFunctions.plusMultSecond(beta));
            }
            this.M.apply(this.p, this.phat);
            A.zMult(this.phat, this.vhat);
            alpha = rho_1 / this.rtilde.zDotProduct(this.vhat);
            this.q.assign(this.vhat, DoubleFunctions.multSecond(-alpha)).assign(this.u, DoubleFunctions.plus);
            this.M.apply(this.sum.assign(this.u).assign(this.q, DoubleFunctions.plus), this.uhat);
            x.assign(this.uhat, DoubleFunctions.plusMultSecond(alpha));
            A.zMult(this.uhat, this.qhat);
            this.r.assign(this.qhat, DoubleFunctions.plusMultSecond(-alpha));
            rho_2 = rho_1;
            this.iter.next();
        }
        return x;
    }
}

