package plugins.tprovoost.note;

import icy.canvas.Canvas2D;
import icy.canvas.IcyCanvas;
import icy.canvas.Layer;
import icy.file.xml.XMLPersistent;
import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.painter.AbstractPainter;
import icy.sequence.Sequence;
import icy.util.XMLUtil;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import org.w3c.dom.Node;

public class PainterNotes extends AbstractPainter implements XMLPersistent {

	private ArrayList<Note> notes = new ArrayList<Note>();

	public PainterNotes() {
	}

	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
		if (!(canvas instanceof Canvas2D))
			return;
		for (Note n : notes) {
			if (n.getAnchor() == null)
				return;
			g.setColor(n.getColor());
			g.setFont(n.getFont());

			// variables
			int x = (int) n.getAnchor().getX();
			int y = (int) n.getAnchor().getY();
			FontMetrics fm = g.getFontMetrics();
			int textHeight = fm.getHeight();
			int maxWidth = 0;
			int indentY = textHeight;

			// DRAW
			if (!n.getText().contains("\n")) {
				g.drawString(n.getText(), x, y + indentY);
				maxWidth = fm.charsWidth(n.getText().toCharArray(), 0, n.getText().length());
				n.boundingRect.setRect(x - 5, y - 5, maxWidth + 10, indentY + fm.getDescent() + 10);
			} else {
				// variables
				int startIdx = n.getText().indexOf("\n");
				String textLoop = n.getText().substring(0);
				String tmp;

				// first step
				tmp = textLoop.substring(0, startIdx);
				int charWidth = fm.charsWidth(tmp.toCharArray(), 0, tmp.length());
				if (charWidth > maxWidth)
					maxWidth = charWidth;
				g.drawString(tmp, x, y + indentY);
				indentY += textHeight;

				// all other steps
				while (startIdx != -1) {
					textLoop = textLoop.substring(startIdx + 1);
					int nextIdx = textLoop.indexOf("\n");
					if (nextIdx != -1) {
						tmp = textLoop.substring(0, nextIdx);
					} else {
						tmp = textLoop.substring(0);
					}
					charWidth = fm.charsWidth(tmp.toCharArray(), 0, tmp.length());
					if (charWidth > maxWidth)
						maxWidth = charWidth;
					g.drawString(tmp, x, y + indentY);
					startIdx = textLoop.indexOf("\n");
					indentY += textHeight;
				}
				n.boundingRect.setRect(x - 5, y - 5, maxWidth + 10, indentY - textHeight + fm.getDescent() + 10);
			}
			if (AnnotationFrame.getAnnotationFrame().getCurrentPainter() == n) {
				g.draw(n.boundingRect);
			}
		}
	}

	@Override
	public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
		if (!e.isConsumed()) {
			if (e.getKeyCode() == KeyEvent.VK_DELETE) {
				AnnotationFrame frame = AnnotationFrame.getAnnotationFrame();
				Note current = frame.getCurrentPainter();
				if (current != null) {
					notes.remove(current);
					canvas.getSequence().removePainter(current.getAnchor());
				}
			}
		}
	}

	@Override
	public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
		if (e.isConsumed())
			return;
		for (int i = 0; i < notes.size(); ++i) {
			final Note n = notes.get(i);
			if (n.boundingRect.contains(imagePoint)) {
				final AnnotationFrame frame = AnnotationFrame.getAnnotationFrame();

				if (frame.isEditing() && e.getButton() == MouseEvent.BUTTON1) {
					frame.setCurrentNote(n);

					// consume the event
					e.consume();
				} else if (e.getButton() == MouseEvent.BUTTON3) {
					JPopupMenu popup = new JPopupMenu();
					popup.setLocation(e.getLocationOnScreen());
					
					if (frame.getCurrentPainter() != n) {
						JMenuItem itemDeleteBand = new JMenuItem("Edit");
						itemDeleteBand.addActionListener(new ActionListener() {

							@Override
							public void actionPerformed(ActionEvent e) {
								frame.setVisible(true);
								frame.setCurrentNote(n);
								frame.setEditing(true);
							}
						});
						popup.add(itemDeleteBand);
					} else {
						JMenuItem itemDelete = new JMenuItem("Stop Editing");
						itemDelete.addActionListener(new ActionListener() {

							@Override
							public void actionPerformed(ActionEvent e) {
								frame.setVisible(true);
								frame.setCurrentNote(null);
								frame.setEditing(false);
							}
						});
						popup.add(itemDelete);
					}

					popup.show(e.getComponent(), e.getX(), e.getY());

					// consume the event
					e.consume();
				}
			}
		}
	}

	@Override
	public boolean loadFromXML(Node node) {
		return true;
	}

	@Override
	public boolean saveToXML(Node node) {
		for (Note n : notes) {
			XMLUtil.addElement(node, "Note");
			n.saveToXML(node);
		}
		return true;
	}

	@Override
	public String toString() {
		String toReturn = "Painter Note";
		Viewer v = Icy.getMainInterface().getFocusedViewer();
		if (v != null) {
			Layer l = v.getCanvas().getLayer(this);
			if (l != null)
				toReturn = l.getName();
		}
		return toReturn;
	}

	public void addNote(Note note) {
		notes.add(note);
	}
	
	public void removeNote(Note note) {
		notes.remove(note);
	}

	public ArrayList<Note> getNotes() {
		return notes;
	}

}
