/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.PersistentObject;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix3D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix3D;
import cern.jet.math.tlong.LongFunctions;

public class LongFactory3D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final LongFactory3D dense = new LongFactory3D();
    public static final LongFactory3D sparse = new LongFactory3D();

    protected LongFactory3D() {
    }

    public LongMatrix3D ascending(int slices, int rows, int columns) {
        LongFunctions F = LongFunctions.longFunctions;
        return this.descending(slices, rows, columns).assign(LongFunctions.chain(LongFunctions.neg, LongFunctions.minus(slices * rows * columns)));
    }

    public LongMatrix3D descending(int slices, int rows, int columns) {
        LongMatrix3D matrix = this.make(slices, rows, columns);
        int v = 0;
        int slice = slices;
        while (--slice >= 0) {
            int row = rows;
            while (--row >= 0) {
                int column = columns;
                while (--column >= 0) {
                    matrix.setQuick(slice, row, column, v++);
                }
            }
        }
        return matrix;
    }

    public LongMatrix3D make(long[][][] values) {
        if (this == sparse) {
            return new SparseLongMatrix3D(values);
        }
        return new DenseLongMatrix3D(values);
    }

    public LongMatrix3D make(int slices, int rows, int columns) {
        if (this == sparse) {
            return new SparseLongMatrix3D(slices, rows, columns);
        }
        return new DenseLongMatrix3D(slices, rows, columns);
    }

    public LongMatrix3D make(int slices, int rows, int columns, long initialValue) {
        return this.make(slices, rows, columns).assign(initialValue);
    }

    public LongMatrix3D random(int slices, int rows, int columns) {
        return this.make(slices, rows, columns).assign(LongFunctions.random());
    }
}

