/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import ij.IJ;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcib3d.geom.Object3D;
import mcib3d.geom.Objects3DPopulation;

public class Objects3DPopulationAnalysis
extends Objects3DPopulation {
    ArrayList<Object3D>[] orderedDistancesCenter = null;
    ArrayList<Object3D>[] orderedDistancesBorder = null;

    public Objects3DPopulationAnalysis(ImagePlus imagePlus) {
        super(imagePlus);
        for (int i = 0; i < this.getNbObjects(); ++i) {
            this.getObject(i).computeContours();
        }
    }

    public Objects3DPopulationAnalysis() {
    }

    private void computeOrderedDistancesCenter() {
        this.orderedDistancesCenter = new ArrayList[this.getNbObjects()];
        for (int i = 0; i < this.getNbObjects(); ++i) {
            this.orderedDistancesCenter[i] = this.orderedDistancesCenterObjects(this.getObject(i));
        }
    }

    private void computeOrderedDistancesBorder() {
        this.orderedDistancesBorder = new ArrayList[this.getNbObjects()];
        for (int i = 0; i < this.getNbObjects(); ++i) {
            IJ.showStatus((String)("ordered border " + i));
            this.orderedDistancesBorder[i] = this.orderedDistancesBorderObjects(this.getObject(i));
        }
    }

    public ArrayList<Object3D> orderedDistancesBorderObjects(Object3D object3D) {
        ArrayList<Object3D> arrayList = new ArrayList<Object3D>();
        arrayList.add(object3D);
        for (int i = 1; i < this.getNbObjects(); ++i) {
            Object3D object3D2 = this.kClosestBorder(object3D, i);
            if (object3D2 == null) continue;
            arrayList.add(object3D2);
        }
        return arrayList;
    }

    public ArrayList<Object3D> orderedDistancesCenterObjects(Object3D object3D) {
        ArrayList<Object3D> arrayList = new ArrayList<Object3D>();
        arrayList.add(object3D);
        for (int i = 1; i < this.getNbObjects(); ++i) {
            Object3D object3D2 = this.kClosestCenter(object3D, i, true);
            if (object3D2 == null) continue;
            arrayList.add(object3D2);
        }
        return arrayList;
    }

    public boolean separatedCenter(int n, int n2) {
        if (n == n2) {
            return false;
        }
        if (this.orderedDistancesCenter == null) {
            this.computeOrderedDistancesCenter();
        }
        ArrayList<Object3D> arrayList = this.orderedDistancesCenter[n];
        ArrayList<Object3D> arrayList2 = this.orderedDistancesCenter[n2];
        int n3 = arrayList.indexOf(this.getObject(n2));
        int n4 = arrayList2.indexOf(this.getObject(n));
        if (n3 >= 0 && n4 >= 0) {
            List<Object3D> list;
            List<Object3D> list2 = arrayList.subList(1, n3);
            return !Collections.disjoint(list2, list = arrayList2.subList(1, n4));
        }
        return true;
    }

    public boolean separatedBorder(int n, int n2) {
        if (n == n2) {
            return false;
        }
        if (this.orderedDistancesBorder == null) {
            this.computeOrderedDistancesBorder();
        }
        ArrayList<Object3D> arrayList = this.orderedDistancesBorder[n];
        ArrayList<Object3D> arrayList2 = this.orderedDistancesBorder[n2];
        int n3 = arrayList.indexOf(this.getObject(n2));
        int n4 = arrayList2.indexOf(this.getObject(n));
        if (n3 >= 0 && n4 >= 0) {
            List<Object3D> list;
            List<Object3D> list2 = arrayList.subList(1, arrayList.indexOf(this.getObject(n2)));
            return !Collections.disjoint(list2, list = arrayList2.subList(1, arrayList2.indexOf(this.getObject(n))));
        }
        return true;
    }
}

