/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.gallery.oob;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.skin.SkinInfo;
import org.pushingpixels.substance.flamingo.ribbon.gallery.oob.SkinResizableIcon;

public class SubstanceSkinRibbonGallery {
    public static void addSkinGallery(JRibbonBand ribbonBand) {
        HashMap<RibbonElementPriority, Integer> prefWidths = new HashMap<RibbonElementPriority, Integer>();
        prefWidths.put(RibbonElementPriority.LOW, 2);
        prefWidths.put(RibbonElementPriority.MEDIUM, 4);
        prefWidths.put(RibbonElementPriority.TOP, 8);
        ArrayList<StringValuePair> skinGroups = new ArrayList<StringValuePair>();
        ArrayList<JCommandToggleButton> skinButtons = new ArrayList<JCommandToggleButton>();
        Map skins = SubstanceLookAndFeel.getAllSkins();
        for (Map.Entry entry : skins.entrySet()) {
            try {
                final SubstanceSkin skin = (SubstanceSkin)Class.forName(((SkinInfo)entry.getValue()).getClassName()).newInstance();
                SkinResizableIcon icon = new SkinResizableIcon(skin, 60, 40);
                JCommandToggleButton skinButton = new JCommandToggleButton(skin.getDisplayName(), (ResizableIcon)icon);
                skinButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SubstanceLookAndFeel.setSkin((SubstanceSkin)skin);
                            }
                        });
                    }
                });
                skinButtons.add(skinButton);
            }
            catch (Exception exc) {}
        }
        skinGroups.add(new StringValuePair("Skins", skinButtons));
        ribbonBand.addRibbonGallery("Skins", skinGroups, prefWidths, 5, 3, RibbonElementPriority.TOP);
    }
}

