/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.util.CancelTask;

public class GIEFConvention
extends CoordSysBuilder {
    public GIEFConvention() {
        this.conventionName = "GIEF";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        NcMLReader.wrapNcMLresource(ds, "resources/nj22/coords/GIEF.ncml", cancelTask);
        Variable timeVar = ds.findVariable("time");
        String time_units = ds.findAttValueIgnoreCase(null, "time_units", null);
        timeVar.addAttribute(new Attribute("units", time_units));
        Variable levelVar = ds.findVariable("level");
        String level_units = ds.findAttValueIgnoreCase(null, "level_units", null);
        String level_name = ds.findAttValueIgnoreCase(null, "level_name", null);
        levelVar.addAttribute(new Attribute("units", level_units));
        levelVar.addAttribute(new Attribute("long_name", level_name));
        String unit_name = ds.findAttValueIgnoreCase(null, "unit_name", null);
        String parameter_name = ds.findAttValueIgnoreCase(null, "parameter_name", null);
        List<Variable> vlist = ds.getVariables();
        for (Variable v : vlist) {
            if (v.getRank() <= 1) continue;
            v.addAttribute(new Attribute("units", unit_name));
            v.addAttribute(new Attribute("long_name", v.getShortName() + " " + parameter_name));
            v.addAttribute(new Attribute("_CoordinateAxes", "time level latitude longitude"));
        }
        Attribute translation = ds.findGlobalAttributeIgnoreCase("translation");
        Attribute affine = ds.findGlobalAttributeIgnoreCase("affine_transformation");
        double startLat = translation.getNumericValue(1).doubleValue();
        double incrLat = affine.getNumericValue(6).doubleValue();
        Dimension latDim = ds.findDimension("row");
        Variable latVar = ds.findVariable("latitude");
        ds.setValues(latVar, latDim.getLength(), startLat, incrLat);
        double startLon = translation.getNumericValue(0).doubleValue();
        double incrLon = affine.getNumericValue(3).doubleValue();
        Dimension lonDim = ds.findDimension("column");
        Variable lonVar = ds.findVariable("longitude");
        ds.setValues(lonVar, lonDim.getLength(), startLon, incrLon);
    }
}

