/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfloat.Float27Function;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SelectedDenseFloatMatrix3D;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_3D;
import edu.emory.mathcs.jtransforms.dht.FloatDHT_3D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_3D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseFloatMatrix3D
extends FloatMatrix3D {
    private static final long serialVersionUID = 1L;
    private FloatFFT_3D fft3;
    private FloatDCT_3D dct3;
    private FloatDST_3D dst3;
    private FloatDHT_3D dht3;
    protected float[] elements;

    public DenseFloatMatrix3D(float[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public DenseFloatMatrix3D(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns);
        this.elements = new float[slices * rows * columns];
    }

    public DenseFloatMatrix3D(int slices, int rows, int columns, float[] elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride, boolean isView) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    @Override
    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float a = 0.0f;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(DenseFloatMatrix3D.this.elements[zero + firstSlice * DenseFloatMatrix3D.this.sliceStride]);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    a = aggr.apply(a, f.apply(DenseFloatMatrix3D.this.elements[zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride + c * DenseFloatMatrix3D.this.columnStride]));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero]);
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        a = aggr.apply(a, f.apply(this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride]));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, final FloatProcedure cond) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float a = 0.0f;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float elem = DenseFloatMatrix3D.this.elements[zero + firstSlice * DenseFloatMatrix3D.this.sliceStride];
                        float a = 0.0f;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    elem = DenseFloatMatrix3D.this.elements[zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride + c * DenseFloatMatrix3D.this.columnStride];
                                    if (cond.apply(elem)) {
                                        a = aggr.apply(a, f.apply(elem));
                                    }
                                    d = 0;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            float elem = this.elements[zero];
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        d = 0;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        if (sliceList.size() == 0 || rowList.size() == 0 || columnList.size() == 0) {
            return Float.NaN;
        }
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final int zero = (int)this.index(0, 0, 0);
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(DenseFloatMatrix3D.this.elements[zero + sliceElements[firstIdx] * DenseFloatMatrix3D.this.sliceStride + rowElements[firstIdx] * DenseFloatMatrix3D.this.rowStride + columnElements[firstIdx] * DenseFloatMatrix3D.this.columnStride]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            float elem = DenseFloatMatrix3D.this.elements[zero + sliceElements[i] * DenseFloatMatrix3D.this.sliceStride + rowElements[i] * DenseFloatMatrix3D.this.rowStride + columnElements[i] * DenseFloatMatrix3D.this.columnStride];
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + sliceElements[0] * this.sliceStride + rowElements[0] * this.rowStride + columnElements[0] * this.columnStride]);
            int i = 1;
            while (i < size) {
                float elem = this.elements[zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride];
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    @Override
    public float aggregate(FloatMatrix3D other, final FloatFloatFunction aggr, final FloatFloatFunction f) {
        if (!(other instanceof DenseFloatMatrix3D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            return Float.NaN;
        }
        float a = 0.0f;
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int columnStrideOther = other.columnStride();
        final float[] elementsOther = (float[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        int idx = zero + firstSlice * DenseFloatMatrix3D.this.sliceStride;
                        int idxOther = zeroOther + firstSlice * sliceStrideOther;
                        float a = f.apply(DenseFloatMatrix3D.this.elements[idx], elementsOther[idxOther]);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride + c * DenseFloatMatrix3D.this.columnStride;
                                    idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * columnStrideOther;
                                    a = aggr.apply(a, f.apply(DenseFloatMatrix3D.this.elements[idx], elementsOther[idxOther]));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * columnStrideOther;
                        a = aggr.apply(a, f.apply(this.elements[idx], elementsOther[idxOther]));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public FloatMatrix3D assign(final FloatFunction function) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    DenseFloatMatrix3D.this.elements[idx] = function.apply(DenseFloatMatrix3D.this.elements[idx]);
                                    idx += DenseFloatMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = function.apply(this.elements[idx]);
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix3D assign(final FloatProcedure cond, final FloatFunction f) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    float elem = DenseFloatMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseFloatMatrix3D.this.elements[idx] = f.apply(elem);
                                    }
                                    idx += DenseFloatMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        float elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = f.apply(elem);
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix3D assign(final FloatProcedure cond, final float value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    float elem = DenseFloatMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseFloatMatrix3D.this.elements[idx] = value;
                                    }
                                    idx += DenseFloatMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        float elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = value;
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix3D assign(final float value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    DenseFloatMatrix3D.this.elements[idx] = value;
                                    idx += DenseFloatMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = value;
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix3D assign(final float[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstSlice * DenseFloatMatrix3D.this.rows * DenseFloatMatrix3D.this.columns;
                            int s = firstSlice;
                            while (s < lastSlice) {
                                int r = 0;
                                while (r < DenseFloatMatrix3D.this.rows) {
                                    int idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride;
                                    int c = 0;
                                    while (c < DenseFloatMatrix3D.this.columns) {
                                        DenseFloatMatrix3D.this.elements[idx] = values[idxOther++];
                                        idx += DenseFloatMatrix3D.this.columnStride;
                                        ++c;
                                    }
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                try {
                    j = 0;
                    while (j < nthreads) {
                        futures[j].get();
                        ++j;
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                int idxOther = 0;
                int s = 0;
                while (s < this.slices) {
                    int r = 0;
                    while (r < this.rows) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int c = 0;
                        while (c < this.columns) {
                            this.elements[idx] = values[idxOther++];
                            idx += this.columnStride;
                            ++c;
                        }
                        ++r;
                    }
                    ++s;
                }
            }
        }
        return this;
    }

    @Override
    public FloatMatrix3D assign(final float[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstSlice * DenseFloatMatrix3D.this.sliceStride;
                            int s = firstSlice;
                            while (s < lastSlice) {
                                float[][] currentSlice = values[s];
                                if (currentSlice.length != DenseFloatMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseFloatMatrix3D.this.rows());
                                }
                                int r = 0;
                                while (r < DenseFloatMatrix3D.this.rows) {
                                    float[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseFloatMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseFloatMatrix3D.this.columns());
                                    }
                                    System.arraycopy(currentRow, 0, DenseFloatMatrix3D.this.elements, i, DenseFloatMatrix3D.this.columns);
                                    i += DenseFloatMatrix3D.this.columns;
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                try {
                    j = 0;
                    while (j < nthreads) {
                        futures[j].get();
                        ++j;
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                int i = 0;
                int s = 0;
                while (s < this.slices) {
                    float[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    int r = 0;
                    while (r < this.rows) {
                        float[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                        i += this.columns;
                        ++r;
                    }
                    ++s;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int s = firstSlice;
                            while (s < lastSlice) {
                                float[][] currentSlice = values[s];
                                if (currentSlice.length != DenseFloatMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseFloatMatrix3D.this.rows());
                                }
                                int r = 0;
                                while (r < DenseFloatMatrix3D.this.rows) {
                                    int idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride;
                                    float[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseFloatMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseFloatMatrix3D.this.columns());
                                    }
                                    int c = 0;
                                    while (c < DenseFloatMatrix3D.this.columns) {
                                        DenseFloatMatrix3D.this.elements[idx] = currentRow[c];
                                        idx += DenseFloatMatrix3D.this.columnStride;
                                        ++c;
                                    }
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                try {
                    j = 0;
                    while (j < nthreads) {
                        futures[j].get();
                        ++j;
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                int s = 0;
                while (s < this.slices) {
                    float[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    int r = 0;
                    while (r < this.rows) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        float[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        int c = 0;
                        while (c < this.columns) {
                            this.elements[idx] = currentRow[c];
                            idx += this.columnStride;
                            ++c;
                        }
                        ++r;
                    }
                    ++s;
                }
            }
        }
        return this;
    }

    @Override
    public FloatMatrix3D assign(FloatMatrix3D source) {
        if (!(source instanceof DenseFloatMatrix3D)) {
            super.assign(source);
            return this;
        }
        DenseFloatMatrix3D other = (DenseFloatMatrix3D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            FloatMatrix3D c = other.copy();
            if (!(c instanceof DenseFloatMatrix3D)) {
                super.assign(source);
                return this;
            }
            other = (DenseFloatMatrix3D)c;
        }
        DenseFloatMatrix3D other_final = other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other_final.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other_final.index(0, 0, 0);
        final int sliceStrideOther = other_final.sliceStride;
        final int rowStrideOther = other_final.rowStride;
        final int columnStrideOther = other_final.columnStride;
        final float[] elementsOther = other_final.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                int c = 0;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    DenseFloatMatrix3D.this.elements[idx] = elementsOther[idxOther];
                                    idx += DenseFloatMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    futures[j].get();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = elementsOther[idxOther];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix3D assign(FloatMatrix3D y, final FloatFloatFunction function) {
        if (!(y instanceof DenseFloatMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final float[] elementsOther = (float[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                int c = 0;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    DenseFloatMatrix3D.this.elements[idx] = function.apply(DenseFloatMatrix3D.this.elements[idx], elementsOther[idxOther]);
                                    idx += DenseFloatMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = function.apply(this.elements[idx], elementsOther[idxOther]);
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public FloatMatrix3D assign(FloatMatrix3D y, final FloatFloatFunction function, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (!(y instanceof DenseFloatMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final float[] elementsOther = (float[])y.elements();
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int idx = zero + sliceElements[i] * DenseFloatMatrix3D.this.sliceStride + rowElements[i] * DenseFloatMatrix3D.this.rowStride + columnElements[i] * DenseFloatMatrix3D.this.columnStride;
                            int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseFloatMatrix3D.this.elements[idx] = function.apply(DenseFloatMatrix3D.this.elements[idx], elementsOther[idxOther]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                int idx = zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], elementsOther[idxOther]);
                ++i;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    if (DenseFloatMatrix3D.this.elements[idx] != 0.0f) {
                                        ++cardinality;
                                    }
                                    idx += DenseFloatMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        if (this.elements[idx] != 0.0f) {
                            ++cardinality;
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return cardinality;
    }

    public void dct2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(s)).dct2(scale);
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseFloatMatrix2D)this.viewSlice(s)).dct2(scale);
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dct3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct3 == null) {
            this.dct3 = new FloatDCT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct3.forward(this.elements, scale);
        } else {
            FloatMatrix3D copy = this.copy();
            this.dct3.forward((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dht2Slices() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(s)).dht2();
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseFloatMatrix2D)this.viewSlice(s)).dht2();
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dht3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht3 == null) {
            this.dht3 = new FloatDHT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht3.forward(this.elements);
        } else {
            FloatMatrix3D copy = this.copy();
            this.dht3.forward((float[])copy.elements());
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dst2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(s)).dst2(scale);
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseFloatMatrix2D)this.viewSlice(s)).dst2(scale);
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dst3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst3 == null) {
            this.dst3 = new FloatDST_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst3.forward(this.elements, scale);
        } else {
            FloatMatrix3D copy = this.copy();
            this.dst3.forward((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public float[] elements() {
        return this.elements;
    }

    public void fft3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.realForward(this.elements);
        } else {
            FloatMatrix3D copy = this.copy();
            this.fft3.realForward((float[])copy.elements());
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public DenseFComplexMatrix3D getFft2Slices() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseFComplexMatrix3D C = new DenseFComplexMatrix3D(this.slices, this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            C.viewSlice(s).assign(((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(s)).getFft2());
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                C.viewSlice(s).assign(((DenseFloatMatrix2D)this.viewSlice(s)).getFft2());
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseFComplexMatrix3D getFft3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        DenseFComplexMatrix3D C = new DenseFComplexMatrix3D(this.slices, this.rows, this.columns);
        final int sliceStride = this.rows * this.columns;
        final int rowStride = this.columns;
        final float[] elems = this.isNoView ? this.elements : (float[])this.copy().elements();
        final float[] cElems = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int idx = s * sliceStride + r * rowStride;
                                System.arraycopy(elems, idx, cElems, idx, DenseFloatMatrix3D.this.columns);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = s * sliceStride + r * rowStride;
                    System.arraycopy(elems, idx, cElems, idx, this.columns);
                    ++r;
                }
                ++s;
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realForwardFull(cElems);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseFComplexMatrix3D getIfft2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseFComplexMatrix3D C = new DenseFComplexMatrix3D(this.slices, this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            C.viewSlice(s).assign(((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(s)).getIfft2(scale));
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                C.viewSlice(s).assign(((DenseFloatMatrix2D)this.viewSlice(s)).getIfft2(scale));
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseFComplexMatrix3D getIfft3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        DenseFComplexMatrix3D C = new DenseFComplexMatrix3D(this.slices, this.rows, this.columns);
        final int sliceStride = this.rows * this.columns;
        final int rowStride = this.columns;
        final float[] cElems = C.elements();
        final float[] elems = this.isNoView ? this.elements : (float[])this.copy().elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int idx = s * sliceStride + r * rowStride;
                                System.arraycopy(elems, idx, cElems, idx, DenseFloatMatrix3D.this.columns);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = s * sliceStride + r * rowStride;
                    System.arraycopy(elems, idx, cElems, idx, this.columns);
                    ++r;
                }
                ++s;
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realInverseFull(cElems, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    @Override
    public float[] getMaxLocation() {
        final int zero = (int)this.index(0, 0, 0);
        int slice_loc = 0;
        int row_loc = 0;
        int col_loc = 0;
        float maxValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int slice_loc = firstSlice;
                        int row_loc = 0;
                        int col_loc = 0;
                        float maxValue = DenseFloatMatrix3D.this.elements[zero + firstSlice * DenseFloatMatrix3D.this.sliceStride];
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    float elem = DenseFloatMatrix3D.this.elements[zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride + c * DenseFloatMatrix3D.this.columnStride];
                                    if (maxValue < elem) {
                                        maxValue = elem;
                                        slice_loc = s;
                                        row_loc = r;
                                        col_loc = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new float[]{maxValue, slice_loc, row_loc, col_loc};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                slice_loc = (int)results[0][1];
                row_loc = (int)results[0][2];
                col_loc = (int)results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        slice_loc = (int)results[j][1];
                        row_loc = (int)results[j][2];
                        col_loc = (int)results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero];
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        float elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (maxValue < elem) {
                            maxValue = elem;
                            slice_loc = s;
                            row_loc = r;
                            col_loc = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new float[]{maxValue, slice_loc, row_loc, col_loc};
    }

    @Override
    public float[] getMinLocation() {
        final int zero = (int)this.index(0, 0, 0);
        int slice_loc = 0;
        int row_loc = 0;
        int col_loc = 0;
        float minValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int slice_loc = firstSlice;
                        int row_loc = 0;
                        int col_loc = 0;
                        float minValue = DenseFloatMatrix3D.this.elements[zero + slice_loc * DenseFloatMatrix3D.this.sliceStride];
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    float elem = DenseFloatMatrix3D.this.elements[zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride + c * DenseFloatMatrix3D.this.columnStride];
                                    if (minValue > elem) {
                                        minValue = elem;
                                        slice_loc = s;
                                        row_loc = r;
                                        col_loc = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new float[]{minValue, slice_loc, row_loc, col_loc};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                slice_loc = (int)results[0][1];
                row_loc = (int)results[0][2];
                col_loc = (int)results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        slice_loc = (int)results[j][1];
                        row_loc = (int)results[j][2];
                        col_loc = (int)results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero];
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        float elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (minValue > elem) {
                            minValue = elem;
                            slice_loc = s;
                            row_loc = r;
                            col_loc = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new float[]{minValue, slice_loc, row_loc, col_loc};
    }

    @Override
    public void getNegativeValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    float value = this.elements[idx];
                    if (value < 0.0f) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    float value = this.elements[idx];
                    if (value != 0.0f) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, FloatArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    float value = this.elements[idx];
                    if (value > 0.0f) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public float getQuick(int slice, int row, int column) {
        return this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    public void idct2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(s)).idct2(scale);
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseFloatMatrix2D)this.viewSlice(s)).idct2(scale);
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idct3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct3 == null) {
            this.dct3 = new FloatDCT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct3.inverse(this.elements, scale);
        } else {
            FloatMatrix3D copy = this.copy();
            this.dct3.inverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idht2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(s)).idht2(scale);
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseFloatMatrix2D)this.viewSlice(s)).idht2(scale);
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idht3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht3 == null) {
            this.dht3 = new FloatDHT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht3.inverse(this.elements, scale);
        } else {
            FloatMatrix3D copy = this.copy();
            this.dht3.inverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idst2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseFloatMatrix2D)DenseFloatMatrix3D.this.viewSlice(s)).idst2(scale);
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseFloatMatrix2D)this.viewSlice(s)).idst2(scale);
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idst3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst3 == null) {
            this.dst3 = new FloatDST_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst3.inverse(this.elements, scale);
        } else {
            FloatMatrix3D copy = this.copy();
            this.dst3.inverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifft3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new FloatFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.realInverse(this.elements, scale);
        } else {
            FloatMatrix3D copy = this.copy();
            this.fft3.realInverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public long index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public FloatMatrix3D like(int slices, int rows, int columns) {
        return new DenseFloatMatrix3D(slices, rows, columns);
    }

    @Override
    public FloatMatrix2D like2D(int rows, int columns) {
        return new DenseFloatMatrix2D(rows, columns);
    }

    @Override
    public void setQuick(int slice, int row, int column, float value) {
        this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public float[][][] toArray() {
        final float[][][] values = new float[this.slices][this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            float[][] currentSlice = values[s];
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride;
                                float[] currentRow = currentSlice[r];
                                int c = 0;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    currentRow[c] = DenseFloatMatrix3D.this.elements[idx];
                                    idx += DenseFloatMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                float[][] currentSlice = values[s];
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    float[] currentRow = currentSlice[r];
                    int c = 0;
                    while (c < this.columns) {
                        currentRow[c] = this.elements[idx];
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return values;
    }

    @Override
    public FloatMatrix1D vectorize() {
        DenseFloatMatrix1D v = new DenseFloatMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        int s = 0;
        while (s < this.slices) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
            ++s;
        }
        return v;
    }

    @Override
    public void zAssign27Neighbors(FloatMatrix3D B, Float27Function function) {
        if (!(B instanceof DenseFloatMatrix3D)) {
            super.zAssign27Neighbors(B, function);
            return;
        }
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        int r = this.rows - 1;
        int c = this.columns - 1;
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        DenseFloatMatrix3D BB = (DenseFloatMatrix3D)B;
        int A_ss = this.sliceStride;
        int A_rs = this.rowStride;
        int B_rs = BB.rowStride;
        int A_cs = this.columnStride;
        int B_cs = BB.columnStride;
        float[] elems = this.elements;
        float[] B_elems = BB.elements;
        if (elems == null || B_elems == null) {
            throw new InternalError();
        }
        int k = 1;
        while (k < this.slices - 1) {
            int A_index = (int)this.index(k, 1, 1);
            int B_index = (int)BB.index(k, 1, 1);
            int i = 1;
            while (i < r) {
                int A002 = A_index - A_ss - A_rs - A_cs;
                int A012 = A002 + A_rs;
                int A022 = A012 + A_rs;
                int A102 = A002 + A_ss;
                int A112 = A102 + A_rs;
                int A122 = A112 + A_rs;
                int A202 = A102 + A_ss;
                int A212 = A202 + A_rs;
                int A222 = A212 + A_rs;
                float a000 = elems[A002];
                float a001 = elems[A002 += A_cs];
                float a010 = elems[A012];
                float a011 = elems[A012 += A_cs];
                float a020 = elems[A022];
                float a021 = elems[A022 += A_cs];
                float a100 = elems[A102];
                float a101 = elems[A102 += A_cs];
                float a110 = elems[A112];
                float a111 = elems[A112 += A_cs];
                float a120 = elems[A122];
                float a121 = elems[A122 += A_cs];
                float a200 = elems[A202];
                float a201 = elems[A202 += A_cs];
                float a210 = elems[A212];
                float a211 = elems[A212 += A_cs];
                float a220 = elems[A222];
                float a221 = elems[A222 += A_cs];
                int B11 = B_index;
                int j = 1;
                while (j < c) {
                    float a002 = elems[A002 += A_cs];
                    float a012 = elems[A012 += A_cs];
                    float a022 = elems[A022 += A_cs];
                    float a102 = elems[A102 += A_cs];
                    float a112 = elems[A112 += A_cs];
                    float a122 = elems[A122 += A_cs];
                    float a202 = elems[A202 += A_cs];
                    float a212 = elems[A212 += A_cs];
                    float a222 = elems[A222 += A_cs];
                    B_elems[B11] = function.apply(a000, a001, a002, a010, a011, a012, a020, a021, a022, a100, a101, a102, a110, a111, a112, a120, a121, a122, a200, a201, a202, a210, a211, a212, a220, a221, a222);
                    B11 += B_cs;
                    a000 = a001;
                    a001 = a002;
                    a010 = a011;
                    a011 = a012;
                    a020 = a021;
                    a021 = a022;
                    a100 = a101;
                    a101 = a102;
                    a110 = a111;
                    a111 = a112;
                    a120 = a121;
                    a121 = a122;
                    a200 = a201;
                    a201 = a202;
                    a210 = a211;
                    a211 = a212;
                    a220 = a221;
                    a221 = a222;
                    ++j;
                }
                A_index += A_rs;
                B_index += B_rs;
                ++i;
            }
            ++k;
        }
    }

    @Override
    public float zSum() {
        float sum = 0.0f;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float sum = 0.0f;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseFloatMatrix3D.this.rows) {
                                int idx = zero + s * DenseFloatMatrix3D.this.sliceStride + r * DenseFloatMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseFloatMatrix3D.this.columns) {
                                    sum += DenseFloatMatrix3D.this.elements[idx];
                                    idx += DenseFloatMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return Float.valueOf(sum);
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    sum += ((Float)futures[j].get()).floatValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        sum += this.elements[idx];
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(FloatMatrix3D other) {
        if (other instanceof SelectedDenseFloatMatrix3D) {
            SelectedDenseFloatMatrix3D otherMatrix = (SelectedDenseFloatMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseFloatMatrix3D) {
            DenseFloatMatrix3D otherMatrix = (DenseFloatMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected FloatMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new DenseFloatMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride, true);
    }

    @Override
    protected FloatMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseFloatMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

