/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.optim.SimpleBoxedSet;

public class DoubleBoxedSet
extends SimpleBoxedSet {
    private double[] lo = null;
    private double[] up = null;
    private int bound = 0;

    public DoubleBoxedSet(DoubleShapedVectorSpace space) {
        super(space);
    }

    private double[] getData(Vector vec) {
        this.space.check(vec);
        return ((DoubleShapedVector)vec).getData();
    }

    @Override
    public void setLowerBound(double val) {
        if (val > Double.NEGATIVE_INFINITY) {
            this.lo = new double[]{val};
            this.bound = this.bound / 3 * 3 + 1;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setLowerBound(Vector vec) {
        if (vec != null) {
            this.lo = this.getData(vec);
            this.bound = this.bound / 3 * 3 + 2;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setUpperBound(double val) {
        if (val < Double.POSITIVE_INFINITY) {
            this.up = new double[]{val};
            this.bound = this.bound % 3 + 3;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public void setUpperBound(Vector vec) {
        if (vec != null) {
            this.up = this.getData(vec);
            this.bound = this.bound % 3 + 6;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public final void projectVariables(Vector dst, Vector vec) {
        double[] xp = this.getData(dst);
        double[] x = this.getData(vec);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                if (xp == x) break;
                System.arraycopy(xp, 0, x, 0, n);
                break;
            }
            case 1: {
                double a = this.lo[0];
                int i = 0;
                while (i < n) {
                    double t = x[i];
                    if (t < a) {
                        t = a;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < n) {
                    double t = x[i];
                    double a = this.lo[i];
                    if (t < a) {
                        t = a;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 3: {
                double b = this.up[0];
                int i = 0;
                while (i < n) {
                    double t = x[i];
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 4: {
                double a = this.lo[0];
                double b = this.up[0];
                int i = 0;
                while (i < n) {
                    double t = x[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 5: {
                double b = this.up[0];
                int i = 0;
                while (i < n) {
                    double t = x[i];
                    double a = this.lo[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                while (i < n) {
                    double t = x[i];
                    double b = this.up[i];
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 7: {
                double a = this.lo[0];
                int i = 0;
                while (i < n) {
                    double t = x[i];
                    double b = this.up[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < n) {
                    double a = this.lo[i];
                    double t = x[i];
                    double b = this.up[i];
                    if (t < a) {
                        t = a;
                    }
                    if (t > b) {
                        t = b;
                    }
                    xp[i] = t;
                    ++i;
                }
                break;
            }
        }
    }

    @Override
    public void projectDirection(Vector dst, Vector vec, Vector dir, int orient) {
        double[] dp = this.getData(dst);
        double[] x = this.getData(vec);
        double[] d = this.getData(dir);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                if (dp == d) break;
                System.arraycopy(dp, 0, d, 0, n);
                break;
            }
            case 1: {
                double a = this.lo[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] >= 0.0 || x[i] > a ? d[i] : 0.0;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] <= 0.0 || x[i] > a ? d[i] : 0.0;
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] >= 0.0 || x[i] > this.lo[i] ? d[i] : 0.0;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] <= 0.0 || x[i] > this.lo[i] ? d[i] : 0.0;
                        ++i;
                    }
                }
                break;
            }
            case 3: {
                double b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] <= 0.0 || x[i] < b ? d[i] : 0.0;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] >= 0.0 || x[i] < b ? d[i] : 0.0;
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                double a = this.lo[0];
                double b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] < 0.0 ? (x[i] > a ? d[i] : 0.0) : (d[i] > 0.0 ? (x[i] < b ? d[i] : 0.0) : 0.0);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] > 0.0 ? (x[i] > a ? d[i] : 0.0) : (d[i] < 0.0 ? (x[i] < b ? d[i] : 0.0) : 0.0);
                        ++i;
                    }
                }
                break;
            }
            case 5: {
                double b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] < 0.0 ? (x[i] > this.lo[i] ? d[i] : 0.0) : (d[i] > 0.0 ? (x[i] < b ? d[i] : 0.0) : 0.0);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] > 0.0 ? (x[i] > this.lo[i] ? d[i] : 0.0) : (d[i] < 0.0 ? (x[i] < b ? d[i] : 0.0) : 0.0);
                        ++i;
                    }
                }
                break;
            }
            case 6: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] <= 0.0 || x[i] < this.up[i] ? d[i] : 0.0;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] >= 0.0 || x[i] < this.up[i] ? d[i] : 0.0;
                        ++i;
                    }
                }
                break;
            }
            case 7: {
                double a = this.lo[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] < 0.0 ? (x[i] > a ? d[i] : 0.0) : (d[i] > 0.0 ? (x[i] < this.up[i] ? d[i] : 0.0) : 0.0);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] > 0.0 ? (x[i] > a ? d[i] : 0.0) : (d[i] < 0.0 ? (x[i] < this.up[i] ? d[i] : 0.0) : 0.0);
                        ++i;
                    }
                }
                break;
            }
            case 8: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] < 0.0 ? (x[i] > this.lo[i] ? d[i] : 0.0) : (d[i] > 0.0 ? (x[i] < this.up[i] ? d[i] : 0.0) : 0.0);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        dp[i] = d[i] > 0.0 ? (x[i] > this.lo[i] ? d[i] : 0.0) : (d[i] < 0.0 ? (x[i] < this.up[i] ? d[i] : 0.0) : 0.0);
                        ++i;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void findFreeVariables(Vector dst, Vector vec, Vector dir, int orient) {
        double[] w = this.getData(dst);
        double[] x = this.getData(vec);
        double[] d = this.getData(dir);
        int n = x.length;
        switch (this.bound) {
            case 0: {
                int i = 0;
                while (i < n) {
                    w[i] = 1.0;
                    ++i;
                }
                break;
            }
            case 1: {
                double a = this.lo[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] < 0.0 ? x[i] > a : d[i] > 0.0);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] > 0.0 ? x[i] > a : d[i] < 0.0);
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] < 0.0 ? x[i] > this.lo[i] : d[i] > 0.0);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] > 0.0 ? x[i] > this.lo[i] : d[i] < 0.0);
                        ++i;
                    }
                }
                break;
            }
            case 3: {
                double b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] < 0.0 ? true : (d[i] > 0.0 ? x[i] < b : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] > 0.0 ? true : (d[i] < 0.0 ? x[i] < b : false));
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                double a = this.lo[0];
                double b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] < 0.0 ? x[i] > a : (d[i] > 0.0 ? x[i] < b : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] > 0.0 ? x[i] > a : (d[i] < 0.0 ? x[i] < b : false));
                        ++i;
                    }
                }
                break;
            }
            case 5: {
                double b = this.up[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] < 0.0 ? x[i] > this.lo[i] : (d[i] > 0.0 ? x[i] < b : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] > 0.0 ? x[i] > this.lo[i] : (d[i] < 0.0 ? x[i] < b : false));
                        ++i;
                    }
                }
                break;
            }
            case 6: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] < 0.0 ? true : (d[i] > 0.0 ? x[i] < this.up[i] : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] > 0.0 ? true : (d[i] < 0.0 ? x[i] < this.up[i] : false));
                        ++i;
                    }
                }
                break;
            }
            case 7: {
                double a = this.lo[0];
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] < 0.0 ? x[i] > a : (d[i] > 0.0 ? x[i] < this.up[i] : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] > 0.0 ? x[i] > a : (d[i] < 0.0 ? x[i] < this.up[i] : false));
                        ++i;
                    }
                }
                break;
            }
            case 8: {
                if (orient > 0) {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] < 0.0 ? x[i] > this.lo[i] : (d[i] > 0.0 ? x[i] < this.up[i] : false));
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < n) {
                        w[i] = (double)(d[i] > 0.0 ? x[i] > this.lo[i] : (d[i] < 0.0 ? x[i] < this.up[i] : false));
                        ++i;
                    }
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double[] findStepLimits(Vector vec, Vector dir, int orient) {
        x = this.getData(vec);
        d = this.getData(dir);
        n = x.length;
        s3 = Infinity;
        s2 = Infinity;
        s1 = Infinity;
        switch (this.bound) {
            case 1: {
                s3 = 0.0;
                a = this.lo[0];
                if (orient > 0) {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p < 0.0) {
                            s = (a - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p > 0.0) {
                            s3 = Infinity;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p > 0.0) {
                            s = (x[i] - a) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p < 0.0) {
                            s3 = Infinity;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                s3 = 0.0;
                if (orient > 0) {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p < 0.0) {
                            s = (this.lo[i] - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p > 0.0) {
                            s3 = Infinity;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p > 0.0) {
                            s = (x[i] - this.lo[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p < 0.0) {
                            s3 = Infinity;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 3: {
                s3 = 0.0;
                b = this.up[0];
                if (orient > 0) {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p > 0.0) {
                            s = (b - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p < 0.0) {
                            s3 = Infinity;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p < 0.0) {
                            s = (x[i] - b) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p > 0.0) {
                            s3 = Infinity;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                s3 = 0.0;
                a = this.lo[0];
                b = this.up[0];
                if (orient <= 0) ** GOTO lbl143
                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p > 0.0)) ** GOTO lbl132
                    s = (b - x[i]) / p;
                    ** GOTO lbl134
lbl132:
                    // 1 sources

                    if (!(p < 0.0)) ** GOTO lbl140
                    s = (a - x[i]) / p;
lbl134:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl140:
                    // 4 sources

                    ++i;
                }
                break;
lbl143:
                // 1 sources

                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p < 0.0)) ** GOTO lbl149
                    s = (x[i] - b) / p;
                    ** GOTO lbl151
lbl149:
                    // 1 sources

                    if (!(p > 0.0)) ** GOTO lbl157
                    s = (x[i] - a) / p;
lbl151:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl157:
                    // 4 sources

                    ++i;
                }
                break;
            }
            case 5: {
                s3 = 0.0;
                b = this.up[0];
                if (orient <= 0) ** GOTO lbl181
                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p > 0.0)) ** GOTO lbl170
                    s = (b - x[i]) / p;
                    ** GOTO lbl172
lbl170:
                    // 1 sources

                    if (!(p < 0.0)) ** GOTO lbl178
                    s = (this.lo[i] - x[i]) / p;
lbl172:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl178:
                    // 4 sources

                    ++i;
                }
                break;
lbl181:
                // 1 sources

                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p < 0.0)) ** GOTO lbl187
                    s = (x[i] - b) / p;
                    ** GOTO lbl189
lbl187:
                    // 1 sources

                    if (!(p > 0.0)) ** GOTO lbl195
                    s = (x[i] - this.lo[i]) / p;
lbl189:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl195:
                    // 4 sources

                    ++i;
                }
                break;
            }
            case 6: {
                s3 = 0.0;
                if (orient > 0) {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p > 0.0) {
                            s = (this.up[i] - x[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p < 0.0) {
                            s3 = Infinity;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < n) {
                        p = d[i];
                        if (p < 0.0) {
                            s = (x[i] - this.up[i]) / p;
                            if (s < s1) {
                                s1 = s;
                            }
                            if (s < s2 && s > 0.0) {
                                s2 = s;
                            }
                            if (s > s3) {
                                s3 = s;
                            }
                        } else if (p > 0.0) {
                            s3 = Infinity;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 7: {
                s3 = 0.0;
                a = this.lo[0];
                if (orient <= 0) ** GOTO lbl256
                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p > 0.0)) ** GOTO lbl245
                    s = (this.up[i] - x[i]) / p;
                    ** GOTO lbl247
lbl245:
                    // 1 sources

                    if (!(p < 0.0)) ** GOTO lbl253
                    s = (a - x[i]) / p;
lbl247:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl253:
                    // 4 sources

                    ++i;
                }
                break;
lbl256:
                // 1 sources

                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p < 0.0)) ** GOTO lbl262
                    s = (x[i] - this.up[i]) / p;
                    ** GOTO lbl264
lbl262:
                    // 1 sources

                    if (!(p > 0.0)) ** GOTO lbl270
                    s = (x[i] - a) / p;
lbl264:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl270:
                    // 4 sources

                    ++i;
                }
                break;
            }
            case 8: {
                s3 = 0.0;
                if (orient <= 0) ** GOTO lbl293
                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p > 0.0)) ** GOTO lbl282
                    s = (this.up[i] - x[i]) / p;
                    ** GOTO lbl284
lbl282:
                    // 1 sources

                    if (!(p < 0.0)) ** GOTO lbl290
                    s = (this.lo[i] - x[i]) / p;
lbl284:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl290:
                    // 4 sources

                    ++i;
                }
                break;
lbl293:
                // 1 sources

                i = 0;
                while (i < n) {
                    p = d[i];
                    if (!(p < 0.0)) ** GOTO lbl299
                    s = (x[i] - this.up[i]) / p;
                    ** GOTO lbl301
lbl299:
                    // 1 sources

                    if (!(p > 0.0)) ** GOTO lbl307
                    s = (x[i] - this.lo[i]) / p;
lbl301:
                    // 2 sources

                    if (s < s1) {
                        s1 = s;
                    }
                    if (s < s2 && s > 0.0) {
                        s2 = s;
                    }
                    if (s > s3) {
                        s3 = s;
                    }
lbl307:
                    // 4 sources

                    ++i;
                }
                break;
            }
        }
        return new double[]{s1, s2, s3};
    }
}

