/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class ThreadLister
implements PlugIn {
    public void run(String arg) {
        if (IJ.getApplet() != null) {
            return;
        }
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(caw);
        try {
            ThreadLister.listAllThreads(pw);
            new TextWindow("Threads", caw.toString(), 420, 420);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void print_thread_info(PrintWriter out, Thread t, String indent) {
        if (t == null) {
            return;
        }
        out.print(indent + "Thread: " + t.getName() + "  Priority: " + t.getPriority() + (t.isDaemon() ? " Daemon" : "") + (t.isAlive() ? "" : " Not Alive") + "\n");
    }

    private static void list_group(PrintWriter out, ThreadGroup g, String indent) {
        int i;
        if (g == null) {
            return;
        }
        int num_threads = g.activeCount();
        int num_groups = g.activeGroupCount();
        Thread[] threads = new Thread[num_threads];
        ThreadGroup[] groups = new ThreadGroup[num_groups];
        g.enumerate(threads, false);
        g.enumerate(groups, false);
        out.println(indent + "Thread Group: " + g.getName() + "  Max Priority: " + g.getMaxPriority() + (g.isDaemon() ? " Daemon" : "") + "\n");
        for (i = 0; i < num_threads; ++i) {
            ThreadLister.print_thread_info(out, threads[i], indent + "    ");
        }
        for (i = 0; i < num_groups; ++i) {
            ThreadLister.list_group(out, groups[i], indent + "    ");
        }
    }

    public static void listAllThreads(PrintWriter out) {
        ThreadGroup current_thread_group;
        ThreadGroup root_thread_group = current_thread_group = Thread.currentThread().getThreadGroup();
        for (ThreadGroup parent = root_thread_group.getParent(); parent != null; parent = parent.getParent()) {
            root_thread_group = parent;
        }
        ThreadLister.list_group(out, root_thread_group, "");
    }
}

