/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.data.Matrix64F;

public class EjmlUnitTests {
    public static void assertCountable(Matrix64F matrix64F) {
        for (int i = 0; i < matrix64F.numRows; ++i) {
            for (int j = 0; j < matrix64F.numCols; ++j) {
                EjmlUnitTests.assertTrue(!Double.isNaN(matrix64F.get(i, j)), "NaN found at " + i + " " + j);
                EjmlUnitTests.assertTrue(!Double.isInfinite(matrix64F.get(i, j)), "Infinite found at " + i + " " + j);
            }
        }
    }

    public static void assertShape(Matrix64F matrix64F, Matrix64F matrix64F2) {
        EjmlUnitTests.assertTrue(matrix64F.numRows == matrix64F2.numRows, "Number of rows do not match");
        EjmlUnitTests.assertTrue(matrix64F.numCols == matrix64F2.numCols, "Number of columns do not match");
    }

    public static void assertShape(Matrix64F matrix64F, int n, int n2) {
        EjmlUnitTests.assertTrue(matrix64F.numRows == n, "Unexpected number of rows.");
        EjmlUnitTests.assertTrue(matrix64F.numCols == n2, "Unexpected number of columns.");
    }

    public static void assertEqualsUncountable(Matrix64F matrix64F, Matrix64F matrix64F2, double d) {
        EjmlUnitTests.assertShape(matrix64F, matrix64F2);
        for (int i = 0; i < matrix64F.numRows; ++i) {
            for (int j = 0; j < matrix64F.numCols; ++j) {
                double d2 = matrix64F.get(i, j);
                double d3 = matrix64F2.get(i, j);
                if (Double.isNaN(d2)) {
                    EjmlUnitTests.assertTrue(Double.isNaN(d3), "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
                    continue;
                }
                if (Double.isInfinite(d2)) {
                    EjmlUnitTests.assertTrue(Double.isInfinite(d3), "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
                    continue;
                }
                double d4 = Math.abs(d2 - d3);
                EjmlUnitTests.assertTrue(d4 <= d, "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
            }
        }
    }

    public static void assertEquals(Matrix64F matrix64F, Matrix64F matrix64F2, double d) {
        EjmlUnitTests.assertShape(matrix64F, matrix64F2);
        for (int i = 0; i < matrix64F.numRows; ++i) {
            for (int j = 0; j < matrix64F.numCols; ++j) {
                double d2 = matrix64F.get(i, j);
                double d3 = matrix64F2.get(i, j);
                EjmlUnitTests.assertTrue(!Double.isNaN(d2) && !Double.isNaN(d3), "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
                EjmlUnitTests.assertTrue(!Double.isInfinite(d2) && !Double.isInfinite(d3), "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
                EjmlUnitTests.assertTrue(Math.abs(d2 - d3) <= d, "At (" + i + "," + j + ") A = " + d2 + " B = " + d3);
            }
        }
    }

    public static void assertEqualsTrans(Matrix64F matrix64F, Matrix64F matrix64F2, double d) {
        EjmlUnitTests.assertShape(matrix64F, matrix64F2.numCols, matrix64F2.numRows);
        for (int i = 0; i < matrix64F.numRows; ++i) {
            for (int j = 0; j < matrix64F.numCols; ++j) {
                double d2 = matrix64F.get(i, j);
                double d3 = matrix64F2.get(j, i);
                EjmlUnitTests.assertTrue(!Double.isNaN(d2) && !Double.isNaN(d3), "A(" + i + "," + j + ") = " + d2 + ") B(" + j + "," + i + ") = " + d3);
                EjmlUnitTests.assertTrue(!Double.isInfinite(d2) && !Double.isInfinite(d3), "A(" + i + "," + j + ") = " + d2 + ") B(" + j + "," + i + ") = " + d3);
                EjmlUnitTests.assertTrue(Math.abs(d2 - d3) <= d, "A(" + i + "," + j + ") = " + d2 + ") B(" + j + "," + i + ") = " + d3);
            }
        }
    }

    private static void assertTrue(boolean bl, String string) {
        assert (bl) : string;
        if (!bl) {
            throw new TestException(string);
        }
    }

    public static class TestException
    extends RuntimeException {
        public TestException(String string) {
            super(string);
        }
    }
}

