/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.tdouble;

import edu.emory.mathcs.jplasma.Barrier;
import edu.emory.mathcs.jplasma.tdouble.Dallocate;
import edu.emory.mathcs.jplasma.tdouble.Dauxiliary;
import edu.emory.mathcs.jplasma.tdouble.DbdlConvert;
import edu.emory.mathcs.jplasma.tdouble.Dcommon;
import edu.emory.mathcs.jplasma.tdouble.Pdpotrf;
import java.util.concurrent.locks.Lock;

class Dpotrf {
    private Dpotrf() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int plasma_DPOTRF(int n, int n2, double[] dArray, int n3, int n4) {
        double[] dArray2;
        if (!Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_DPOTRF", "PLASMA not initialized");
            return -1;
        }
        if (n != 121 && n != 122) {
            Dauxiliary.plasma_error("plasma_DPOTRF", "illegal value of uplo");
            return -4;
        }
        if (n2 < 0) {
            Dauxiliary.plasma_error("plasma_DPOTRF", "illegal value of N");
            return -4;
        }
        if (n4 < Math.max(1, n2)) {
            Dauxiliary.plasma_error("plasma_DPOTRF", "illegal value of LDA");
            return -4;
        }
        if (Math.max(n2, 0) == 0) {
            return 0;
        }
        int n5 = Dauxiliary.plasma_tune(2, n2, n2, 0);
        if (n5 != 0) {
            Dauxiliary.plasma_error("plasma_DPOTRF", "plasma_tune() failed");
            return n5;
        }
        int n6 = Dcommon.plasma_cntrl.NB;
        int n7 = n2 % n6 == 0 ? n2 / n6 : n2 / n6 + 1;
        int n8 = n7 * n7;
        if (Dcommon.plasma_cntrl.progress_size_elems < n8) {
            n5 = Dallocate.plasma_free_aux_progress();
            if (n5 != 0) {
                Dauxiliary.plasma_error("plasma_DPOTRF", "plasma_free_aux_progress() failed");
            }
            if ((n5 = Dallocate.plasma_alloc_aux_progress(n8)) != 0) {
                Dauxiliary.plasma_error("plasma_DPOTRF", "plasma_alloc_aux_progress() failed");
                return n5;
            }
        }
        double[] dArray3 = dArray2 = Dcommon.plasma_aux.bdl_mem;
        int n9 = 0;
        n8 = n7 * n7 * Dcommon.plasma_cntrl.NBNBSIZE;
        if (Dcommon.plasma_cntrl.bdl_size_elems < n8) {
            n5 = Dallocate.plasma_free_aux_bdl();
            if (n5 != 0) {
                Dauxiliary.plasma_error("plasma_DPOTRF", "plasma_free_aux_bdl() failed");
                return n5;
            }
            n5 = Dallocate.plasma_alloc_aux_bdl(n8);
            if (n5 != 0) {
                Dauxiliary.plasma_error("plasma_DPOTRF", "plasma_alloc_aux_bdl() failed");
                return n5;
            }
            dArray3 = dArray2 = Dcommon.plasma_aux.bdl_mem;
            n9 = 0;
        }
        Dcommon.plasma_args.F77 = dArray;
        Dcommon.plasma_args.F77_offset = n3;
        Dcommon.plasma_args.A = dArray3;
        Dcommon.plasma_args.A_offset = n9;
        Dcommon.plasma_args.M = n2;
        Dcommon.plasma_args.N = n2;
        Dcommon.plasma_args.LDA = n4;
        Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
        Dcommon.plasma_args.MT = n7;
        Dcommon.plasma_args.NT = n7;
        Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
        Lock lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 9;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_cntrl.action = 0;
        DbdlConvert.plasma_lapack_to_bdl(Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_args.uplo = n;
        Dcommon.plasma_args.N = n2;
        Dcommon.plasma_args.A = dArray3;
        Dcommon.plasma_args.A_offset = n9;
        Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
        Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
        Dcommon.plasma_args.NT = n7;
        Dauxiliary.plasma_clear_aux_progress(n7 * n7, 0);
        lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 5;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_cntrl.action = 0;
        Pdpotrf.plasma_pDPOTRF(Dcommon.plasma_args.uplo, Dcommon.plasma_args.N, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.NB, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_args.NT, Dcommon.plasma_args.INFO, Dcommon.plasma_cntrl.cores_num, 0);
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        if (Dcommon.plasma_args.INFO.val == 0) {
            Dcommon.plasma_args.A = dArray3;
            Dcommon.plasma_args.A_offset = n9;
            Dcommon.plasma_args.F77 = dArray;
            Dcommon.plasma_args.F77_offset = n3;
            Dcommon.plasma_args.M = n2;
            Dcommon.plasma_args.N = n2;
            Dcommon.plasma_args.LDA = n4;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.MT = n7;
            Dcommon.plasma_args.NT = n7;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 10;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            DbdlConvert.plasma_bdl_to_lapack(Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        }
        return Dcommon.plasma_args.INFO.val;
    }
}

