/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetamorphHandler;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.helpers.DefaultHandler;

public class MetamorphTiffReader
extends BaseTiffReader {
    private static final String DATE_FORMAT = "yyyyMMdd HH:mm:ss";
    private String[] files;
    private int wellCount = 0;
    private int fieldRowCount = 0;
    private int fieldColumnCount = 0;
    private boolean dualCamera = false;

    public MetamorphTiffReader() {
        super("Metamorph TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy", "High-Content Screening (HCS)"};
        this.datasetDescription = "One or more .tif/.tiff files";
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        String comment = tp.getComment();
        if (comment == null) {
            return false;
        }
        return (comment = comment.trim()).startsWith("<MetaData>") && comment.endsWith("</MetaData>");
    }

    @Override
    public String[] getDomains() {
        FormatTools.assertId(this.currentId, true, 1);
        String[] domain = new String[]{this.files.length == 1 ? "Light Microscopy" : "High-Content Screening (HCS)"};
        return domain;
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        return noPixels ? new String[]{} : this.files;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.files = null;
            this.wellCount = 0;
            this.fieldRowCount = 0;
            this.fieldColumnCount = 0;
            this.dualCamera = false;
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        IFD ifd;
        if (this.getSeriesCount() == 1 && this.files.length == 1 && !this.dualCamera) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        int[] lengths = new int[]{this.getSizeZ(), this.getEffectiveSizeC(), this.fieldColumnCount, this.fieldRowCount, this.wellCount, this.getSizeT()};
        int[] zct = this.getZCTCoords(no);
        Well well = this.getWell(this.getSeries());
        int[] position = new int[]{zct[0], zct[1], well.fieldCol, well.fieldRow, well.well, zct[2]};
        if (this.dualCamera) {
            position[1] = 0;
        }
        int fileIndex = FormatTools.positionToRaster(lengths, position);
        RandomAccessInputStream s = null;
        s = fileIndex < this.files.length ? new RandomAccessInputStream(this.files[fileIndex]) : new RandomAccessInputStream(this.files[0]);
        TiffParser parser = new TiffParser(s);
        int ndx = this.getSeries() * this.getSizeZ() * this.getSizeT() + no;
        int[] pos = this.getZCTCoords(no);
        if (this.dualCamera) {
            int channel = pos[1];
            pos[1] = 0;
            ndx = this.getSeries() * this.getSizeZ() * this.getSizeT() + FormatTools.positionToRaster(new int[]{this.getSizeZ(), 1, this.getSizeT()}, pos);
            pos[1] = channel;
        }
        IFD iFD = ifd = this.files.length == 1 ? (IFD)this.ifds.get(ndx) : parser.getFirstIFD();
        int realX = this.dualCamera ? (pos[1] == 0 ? x : x + pos[1] * this.getSizeX()) : x;
        parser.getSamples(ifd, buf, realX, y, w, h);
        s.close();
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int seriesCount;
        super.initFile(id);
        Vector<String> uniqueChannels = new Vector<String>();
        Vector<Double> uniqueZs = new Vector<Double>();
        Vector<Length> stageX = new Vector<Length>();
        Vector<Length> stageY = new Vector<Length>();
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        String filename = id.substring(id.lastIndexOf(File.separator) + 1);
        filename = filename.substring(0, filename.indexOf("."));
        boolean integerFilename = true;
        try {
            Integer.parseInt(filename);
        }
        catch (NumberFormatException e) {
            integerFilename = false;
        }
        if (integerFilename && this.ifds.size() == 1 && ((IFD)this.ifds.get(0)).getIFDIntValue(254) == 2) {
            this.findTIFFs();
            String stageLabel = null;
            for (String tiff : this.files) {
                Vector<Double> zPositions;
                Double pos;
                MetamorphHandler handler = new MetamorphHandler();
                this.parseFile(tiff, handler);
                String label = handler.getStageLabel();
                if (stageLabel == null) {
                    stageLabel = label;
                } else if (!label.equals(stageLabel)) break;
                if (!uniqueChannels.contains(handler.getChannelName())) {
                    uniqueChannels.add(handler.getChannelName());
                }
                if (uniqueZs.contains(pos = Double.valueOf(Math.rint((zPositions = handler.getZPositions()).get(0))))) continue;
                uniqueZs.add(pos);
            }
            MetamorphHandler handler = new MetamorphHandler();
            this.parseFile(this.files[this.files.length - 1], handler);
            String lastStageLabel = handler.getStageLabel();
            int lastField = this.getField(lastStageLabel);
            int lastWellRow = this.getWellRow(lastStageLabel);
            int lastWellColumn = this.getWellColumn(lastStageLabel);
            int field = this.getField(stageLabel);
            int fieldRow = this.getWellRow(stageLabel);
            int fieldColumn = this.getWellColumn(stageLabel);
            this.wellCount = lastField - field + 1;
            this.fieldRowCount = lastWellRow - fieldRow + 1;
            this.fieldColumnCount = lastWellColumn - fieldColumn + 1;
            m.sizeC = uniqueChannels.size();
            m.sizeZ = uniqueZs.size();
        } else {
            this.files = new String[]{id};
            this.wellCount = 1;
            this.fieldRowCount = 1;
            this.fieldColumnCount = 1;
            m.sizeC = 0;
        }
        MetamorphHandler handler = new MetamorphHandler(this.getGlobalMetadata());
        Vector<Length> xPositions = new Vector<Length>();
        Vector<Length> yPositions = new Vector<Length>();
        for (IFD ifd : this.ifds) {
            String xml = XMLTools.sanitizeXML(ifd.getComment());
            XMLTools.parseXML(xml, (DefaultHandler)handler);
            Length x = handler.getStagePositionX();
            Length y = handler.getStagePositionY();
            if (xPositions.size() == 0) {
                xPositions.add(x);
                yPositions.add(y);
                continue;
            }
            Length previousX = (Length)xPositions.get(xPositions.size() - 1);
            Length previousY = (Length)yPositions.get(yPositions.size() - 1);
            double x1 = x.value(UNITS.REFERENCEFRAME).doubleValue();
            double x2 = previousX.value(UNITS.REFERENCEFRAME).doubleValue();
            double y1 = y.value(UNITS.REFERENCEFRAME).doubleValue();
            double y2 = previousY.value(UNITS.REFERENCEFRAME).doubleValue();
            if (!(Math.abs(x1 - x2) > 0.21) && !(Math.abs(y1 - y2) > 0.21)) continue;
            xPositions.add(x);
            yPositions.add(y);
        }
        if (xPositions.size() > 1) {
            this.fieldRowCount = xPositions.size();
        }
        Vector<Integer> wavelengths = handler.getWavelengths();
        Vector<Double> zPositions = handler.getZPositions();
        this.dualCamera = handler.hasDualCamera();
        Vector<Integer> uniqueC = new Vector<Integer>();
        for (Integer c : wavelengths) {
            if (uniqueC.contains(c)) continue;
            uniqueC.add(c);
        }
        int effectiveC = uniqueC.size();
        if (effectiveC == 0) {
            effectiveC = 1;
        }
        if (this.getSizeC() == 0) {
            m.sizeC = 1;
        }
        int samples = ((IFD)this.ifds.get(0)).getSamplesPerPixel();
        m.sizeC *= effectiveC * samples;
        Vector<Double> uniqueZ = new Vector<Double>();
        for (Double z : zPositions) {
            if (uniqueZ.contains(z)) continue;
            uniqueZ.add(z);
        }
        if (this.getSizeZ() == 0) {
            m.sizeZ = 1;
        }
        m.sizeZ *= uniqueZ.size();
        Double zRange = zPositions.get(zPositions.size() - 1) - zPositions.get(0);
        Double physicalSizeZ = Math.abs(zRange);
        if (m.sizeZ > 1) {
            physicalSizeZ = physicalSizeZ / (double)(m.sizeZ - 1);
        }
        int totalPlanes = this.files.length * this.ifds.size();
        effectiveC = this.getSizeC() / samples;
        m.sizeT = totalPlanes / (this.wellCount * this.fieldRowCount * this.fieldColumnCount * this.getSizeZ() * effectiveC);
        if (this.getSizeT() == 0) {
            m.sizeT = 1;
        }
        if ((seriesCount = this.wellCount * this.fieldRowCount * this.fieldColumnCount) > 1 && this.getSizeZ() > totalPlanes / seriesCount || totalPlanes > this.getSizeZ() * this.getSizeT() * effectiveC) {
            m.sizeZ = 1;
            m.sizeT = totalPlanes / (seriesCount * effectiveC);
        }
        m.imageCount = this.getSizeZ() * this.getSizeT() * effectiveC;
        if (this.dualCamera) {
            m.sizeX /= 2;
            m.sizeC *= 2;
            m.imageCount *= 2;
        }
        if (seriesCount > 1) {
            this.core.clear();
            for (int i = 0; i < seriesCount; ++i) {
                this.core.add(m);
            }
        }
        for (int s = 0; s < this.wellCount * this.fieldRowCount * this.fieldColumnCount; ++s) {
            if (this.files.length > 1) {
                int[] lengths = new int[]{this.getSizeZ(), this.getEffectiveSizeC(), this.fieldColumnCount, this.fieldRowCount, this.wellCount, this.getSizeT()};
                Well well = this.getWell(s);
                int[] position = new int[]{0, 0, well.fieldCol, well.fieldRow, well.well, 0};
                int fileIndex = FormatTools.positionToRaster(lengths, position);
                this.parseFile(this.files[fileIndex], handler);
                stageX.add(handler.getStagePositionX());
                stageY.add(handler.getStagePositionY());
                continue;
            }
            stageX.add((Length)xPositions.get(s));
            stageY.add((Length)yPositions.get(s));
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.wellCount > 1) {
            store.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
            store.setPlateRowNamingConvention(NamingConvention.LETTER, 0);
            store.setPlateColumnNamingConvention(NamingConvention.NUMBER, 0);
            for (int well = 0; well < this.wellCount; ++well) {
                store.setWellID(MetadataTools.createLSID("Well", 0, well), 0, well);
                store.setWellRow(new NonNegativeInteger(0), 0, well);
                store.setWellColumn(new NonNegativeInteger(well), 0, well);
                for (int row = 0; row < this.fieldRowCount; ++row) {
                    for (int col = 0; col < this.fieldColumnCount; ++col) {
                        int field = row * this.fieldColumnCount + col;
                        String wellSampleID = MetadataTools.createLSID("WellSample", 0, well, field);
                        store.setWellSampleID(wellSampleID, 0, well, field);
                        int seriesIndex = this.getSeriesIndex(row, col, well);
                        String imageID = MetadataTools.createLSID("Image", seriesIndex);
                        store.setImageID(imageID, seriesIndex);
                        store.setWellSampleImageRef(imageID, 0, well, field);
                        store.setWellSampleIndex(new NonNegativeInteger(seriesIndex), 0, well, field);
                    }
                }
            }
        }
        for (int s = 0; s < seriesCount; ++s) {
            int i;
            this.setSeries(s);
            Well well = this.getWell(s);
            String name = handler.getImageName();
            if (seriesCount > 1) {
                name = "Field " + (char)(well.fieldRow + 65) + (well.fieldCol + 1) + ", Well " + (well.well + 1) + ": " + name;
            }
            store.setImageName(name, s);
            String date = DateTools.formatDate(handler.getDate(), "yyyy-MM-dd'T'HH:mm:ss", ".");
            if (date != null) {
                store.setImageAcquisitionDate(new Timestamp(date), s);
            }
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            Vector<String> timestamps = handler.getTimestamps();
            Vector<Double> exposures = handler.getExposures();
            for (i = 0; i < timestamps.size(); ++i) {
                long timestamp = DateTools.getTime(timestamps.get(i), DATE_FORMAT, ".");
                this.addSeriesMetaList("timestamp", timestamp);
            }
            for (i = 0; i < exposures.size(); ++i) {
                this.addSeriesMetaList("exposure time (ms)", Float.valueOf(exposures.get(i).floatValue() * 1000.0f));
            }
            long startDate = 0L;
            if (timestamps.size() > 0) {
                startDate = DateTools.getTime(timestamps.get(0), DATE_FORMAT, ".");
            }
            store.setImageDescription("", s);
            int image = 0;
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                for (int t = 0; t < this.getSizeT(); ++t) {
                    store.setPlaneTheZ(new NonNegativeInteger(0), s, image);
                    store.setPlaneTheC(new NonNegativeInteger(c), s, image);
                    store.setPlaneTheT(new NonNegativeInteger(t), s, image);
                    if (t < timestamps.size()) {
                        String stamp = timestamps.get(t);
                        long ms = DateTools.getTime(stamp, DATE_FORMAT, ".");
                        store.setPlaneDeltaT(new Time((double)(ms - startDate) / 1000.0, UNITS.S), s, image);
                    }
                    int exposureIndex = image;
                    if (this.dualCamera) {
                        exposureIndex /= this.getEffectiveSizeC();
                    }
                    if (exposureIndex < exposures.size() && exposures.get(exposureIndex) != null) {
                        store.setPlaneExposureTime(new Time(exposures.get(exposureIndex), UNITS.S), s, image);
                    }
                    if (s < stageX.size()) {
                        store.setPlanePositionX((Length)stageX.get(s), s, image);
                    }
                    if (s < stageY.size()) {
                        store.setPlanePositionY((Length)stageY.get(s), s, image);
                    }
                    ++image;
                }
            }
            store.setImagingEnvironmentTemperature(new Temperature(handler.getTemperature(), UNITS.DEGREEC), s);
            Length sizeX = FormatTools.getPhysicalSizeX(handler.getPixelSizeX());
            Length sizeY = FormatTools.getPhysicalSizeY(handler.getPixelSizeY());
            Length sizeZ = FormatTools.getPhysicalSizeZ(physicalSizeZ);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, s);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, s);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, s);
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (uniqueChannels.size() > c) {
                    store.setChannelName((String)uniqueChannels.get(c), s, c);
                    continue;
                }
                store.setChannelName(handler.getChannelName(), s, c);
            }
        }
    }

    private int getSeriesIndex(int fieldRow, int fieldColumn, int well) {
        return FormatTools.positionToRaster(new int[]{this.fieldColumnCount, this.fieldRowCount, this.wellCount}, new int[]{fieldColumn, fieldRow, well});
    }

    private Well getWell(int seriesIndex) {
        int[] coordinates = FormatTools.rasterToPosition(new int[]{this.fieldColumnCount, this.fieldRowCount, this.wellCount}, seriesIndex);
        return new Well(coordinates[1], coordinates[0], coordinates[2]);
    }

    private int getField(String stageLabel) {
        if (stageLabel.indexOf("Scan") < 0) {
            return 0;
        }
        String index = stageLabel.substring(0, stageLabel.indexOf(":")).trim();
        return Integer.parseInt(index) - 1;
    }

    private int getWellRow(String stageLabel) {
        int scanIndex = stageLabel.indexOf("Scan");
        if (scanIndex < 0) {
            return 0;
        }
        scanIndex = stageLabel.indexOf(" ", scanIndex) + 1;
        return stageLabel.charAt(scanIndex) - 65;
    }

    private int getWellColumn(String stageLabel) {
        int scanIndex = stageLabel.indexOf("Scan");
        if (scanIndex < 0) {
            return 0;
        }
        scanIndex = stageLabel.indexOf(" ", scanIndex) + 2;
        return Integer.parseInt(stageLabel.substring(scanIndex)) - 1;
    }

    private void findTIFFs() throws IOException {
        Location baseFile = new Location(this.currentId).getAbsoluteFile();
        Location parent = baseFile.getParentFile();
        FilePattern pattern = new FilePattern(baseFile);
        String[] tiffs = pattern.getFiles();
        NumericComparator comparator = new NumericComparator();
        Arrays.sort(tiffs, comparator);
        Vector<String> validTIFFs = new Vector<String>();
        for (String tiff : tiffs) {
            if (!new Location(tiff).exists()) {
                String base = tiff.substring(tiff.lastIndexOf(File.separator) + 1);
                base = base.substring(0, base.indexOf("."));
                String suffix = tiff.substring(tiff.lastIndexOf("."));
                while (base.length() < 3) {
                    base = "0" + base;
                }
                Location test = new Location(parent, base + suffix);
                if (!test.exists()) continue;
                tiff = test.getAbsolutePath();
            }
            if (File.separator.equals("\\")) {
                tiff = tiff.replaceAll("\\\\\\\\", "\\\\");
            }
            validTIFFs.add(tiff);
        }
        this.files = validTIFFs.toArray(new String[validTIFFs.size()]);
    }

    private void parseFile(String tiff, MetamorphHandler handler) throws IOException {
        RandomAccessInputStream s = new RandomAccessInputStream(tiff);
        TiffParser parser = new TiffParser(s);
        IFD firstIFD = parser.getFirstIFD();
        String xml = XMLTools.sanitizeXML(firstIFD.getComment());
        XMLTools.parseXML(xml, (DefaultHandler)handler);
        s.close();
    }

    class NumericComparator
    implements Comparator<String> {
        NumericComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1.equals(s2)) {
                return 0;
            }
            String base1 = s1.substring(s1.lastIndexOf(File.separator) + 1);
            String base2 = s2.substring(s2.lastIndexOf(File.separator) + 1);
            base1 = base1.substring(0, base1.indexOf("."));
            base2 = base2.substring(0, base2.indexOf("."));
            try {
                int num1 = Integer.parseInt(base1);
                int num2 = Integer.parseInt(base2);
                if (num1 == num2) {
                    return 0;
                }
                return num1 < num2 ? -1 : 1;
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
    }

    class Well {
        public int well;
        public int fieldRow;
        public int fieldCol;

        public Well(int fieldRow, int fieldCol, int well) {
            this.fieldRow = fieldRow;
            this.fieldCol = fieldCol;
            this.well = well;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Well)) {
                return false;
            }
            Well w = (Well)o;
            return w.well == this.well && w.fieldRow == this.fieldRow && w.fieldCol == this.fieldCol;
        }

        public int hashCode() {
            return this.well << 16 | this.fieldRow << 8 | this.fieldCol;
        }
    }
}

