/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv.io;

import icy.gui.frame.progress.AnnounceFrame;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import java.io.File;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.io.MdaFormat;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;

public class ImageToMda
extends EzPlug {
    String defaultPath = "";
    EzVarSequence input = new EzVarSequence("Input");
    EzVarFile text = new EzVarFile("Output", this.defaultPath);

    public void clean() {
    }

    protected void execute() {
        Sequence in = (Sequence)this.input.getValue();
        try {
            if (in == null) {
                throw new IllegalArgumentException("No input specified");
            }
            if (in.getSizeT() != 1) {
                throw new IllegalArgumentException("No 4D data input");
            }
            int[] dims = in.getSizeZ() != 1 ? new int[]{in.getSizeX(), in.getSizeY(), in.getSizeZ()} : new int[]{in.getSizeX(), in.getSizeY()};
            double[] inputData = Array1DUtil.arrayToDoubleArray((Object)in.getDataCopyXYZT(0), (boolean)in.isSignedDataType());
            DoubleArray out = dims.length == 3 ? Double3D.wrap(inputData, dims) : Double2D.wrap(inputData, dims);
            MdaFormat.save((ShapedArray)out, ((File)this.text.getValue()).getAbsolutePath());
        }
        catch (Exception e) {
            new AnnounceFrame("Oops, Error: " + e);
            e.printStackTrace();
        }
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.input);
        this.addEzComponent((EzComponent)this.text);
        this.input.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                if (newValue != null && ImageToMda.this.text.getValue() != null) {
                    ImageToMda.this.text.setValue((Object)new File(String.valueOf(newValue.getFilename()) + ".mda"));
                }
            }
        });
    }
}

