/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.Long3D;
import mitiv.array.Long4D;
import mitiv.array.impl.FlatLong1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedLong4D;
import mitiv.array.impl.StriddenLong3D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.random.LongGenerator;

public class StriddenLong4D
extends Long4D {
    final int order;
    final long[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final int stride3;
    final int stride4;

    public StriddenLong4D(long[] arr, int offset, int[] stride, int[] dims) {
        super(dims);
        if (stride.length != 4) {
            throw new IllegalArgumentException("There must be as many strides as the rank.");
        }
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride[0];
        this.stride2 = stride[1];
        this.stride3 = stride[2];
        this.stride4 = stride[3];
        this.order = Long4D.checkViewStrides(this.data.length, offset, this.stride1, this.stride2, this.stride3, this.stride4, this.dim1, this.dim2, this.dim3, this.dim4);
    }

    public StriddenLong4D(long[] arr, int offset, int stride1, int stride2, int stride3, int stride4, int dim1, int dim2, int dim3, int dim4) {
        super(dim1, dim2, dim3, dim4);
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride1;
        this.stride2 = stride2;
        this.stride3 = stride3;
        this.stride4 = stride4;
        this.order = Long4D.checkViewStrides(this.data.length, offset, stride1, stride2, stride3, stride4, dim1, dim2, dim3, dim4);
    }

    @Override
    public void checkSanity() {
        Long4D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.stride3, this.stride4, this.dim1, this.dim2, this.dim3, this.dim4);
    }

    private boolean isFlat() {
        return this.offset == 0 && this.stride1 == 1 && this.stride2 == this.dim1 && this.stride3 == this.dim2 * this.stride2 && this.stride4 == this.dim3 * this.stride3;
    }

    final int index(int i1, int i2, int i3, int i4) {
        return this.offset + this.stride4 * i4 + this.stride3 * i3 + this.stride2 * i2 + this.stride1 * i1;
    }

    @Override
    public final long get(int i1, int i2, int i3, int i4) {
        return this.data[this.offset + this.stride4 * i4 + this.stride3 * i3 + this.stride2 * i2 + this.stride1 * i1];
    }

    @Override
    public final void set(int i1, int i2, int i3, int i4, long value) {
        this.data[this.offset + this.stride4 * i4 + this.stride3 * i3 + this.stride2 * i2 + this.stride1 * i1] = value;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j3;
                            this.data[j4] = value;
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.stride4 * i4 + this.offset;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.stride3 * i3 + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.stride2 * i2 + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1 = this.stride1 * i1 + j2;
                            this.data[j1] = value;
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void fill(LongGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j3;
                            this.data[j4] = generator.nextLong();
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.stride4 * i4 + this.offset;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.stride3 * i3 + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.stride2 * i2 + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1 = this.stride1 * i1 + j2;
                            this.data[j1] = generator.nextLong();
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void increment(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4;
                            int n = j4 = this.stride4 * i4 + j3;
                            this.data[n] = this.data[n] + value;
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.stride4 * i4 + this.offset;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.stride3 * i3 + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.stride2 * i2 + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1;
                            int n = j1 = this.stride1 * i1 + j2;
                            this.data[n] = this.data[n] + value;
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void decrement(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4;
                            int n = j4 = this.stride4 * i4 + j3;
                            this.data[n] = this.data[n] - value;
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.stride4 * i4 + this.offset;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.stride3 * i3 + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.stride2 * i2 + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1;
                            int n = j1 = this.stride1 * i1 + j2;
                            this.data[n] = this.data[n] - value;
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void scale(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4;
                            int n = j4 = this.stride4 * i4 + j3;
                            this.data[n] = this.data[n] * value;
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.stride4 * i4 + this.offset;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.stride3 * i3 + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.stride2 * i2 + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1;
                            int n = j1 = this.stride1 * i1 + j2;
                            this.data[n] = this.data[n] * value;
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void map(LongFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j3;
                            this.data[j4] = function.apply(this.data[j4]);
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.stride4 * i4 + this.offset;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.stride3 * i3 + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.stride2 * i2 + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1 = this.stride1 * i1 + j2;
                            this.data[j1] = function.apply(this.data[j1]);
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public void scan(LongScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int j1 = this.stride1 * i1 + this.offset;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j1;
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int j3 = this.stride3 * i3 + j2;
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int j4 = this.stride4 * i4 + j3;
                            if (initialized) {
                                scanner.update(this.data[j4]);
                            } else {
                                scanner.initialize(this.data[j4]);
                                initialized = true;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i4 = 0;
            while (i4 < this.dim4) {
                int j4 = this.stride4 * i4 + this.offset;
                int i3 = 0;
                while (i3 < this.dim3) {
                    int j3 = this.stride3 * i3 + j4;
                    int i2 = 0;
                    while (i2 < this.dim2) {
                        int j2 = this.stride2 * i2 + j3;
                        int i1 = 0;
                        while (i1 < this.dim1) {
                            int j1 = this.stride1 * i1 + j2;
                            if (initialized) {
                                scanner.update(this.data[j1]);
                            } else {
                                scanner.initialize(this.data[j1]);
                                initialized = true;
                            }
                            ++i1;
                        }
                        ++i2;
                    }
                    ++i3;
                }
                ++i4;
            }
        }
    }

    @Override
    public long[] flatten(boolean forceCopy) {
        if (!forceCopy && this.isFlat()) {
            return this.data;
        }
        long[] out = new long[this.number];
        int j = -1;
        int i4 = 0;
        while (i4 < this.dim4) {
            int j4 = this.stride4 * i4 + this.offset;
            int i3 = 0;
            while (i3 < this.dim3) {
                int j3 = this.stride3 * i3 + j4;
                int i2 = 0;
                while (i2 < this.dim2) {
                    int j2 = this.stride2 * i2 + j3;
                    int i1 = 0;
                    while (i1 < this.dim1) {
                        int j1 = this.stride1 * i1 + j2;
                        out[++j] = this.data[j1];
                        ++i1;
                    }
                    ++i2;
                }
                ++i3;
            }
            ++i4;
        }
        return out;
    }

    @Override
    public Long3D slice(int idx) {
        return new StriddenLong3D(this.data, this.offset + this.stride4 * idx, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Long3D slice(int idx, int dim) {
        int sliceDim3;
        int sliceDim2;
        int sliceDim1;
        int sliceStride3;
        int sliceStride2;
        int sliceStride1;
        int sliceOffset;
        if (dim < 0) {
            dim += 4;
        }
        if (dim == 0) {
            sliceOffset = this.offset + this.stride1 * idx;
            sliceStride1 = this.stride2;
            sliceStride2 = this.stride3;
            sliceStride3 = this.stride4;
            sliceDim1 = this.dim2;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
        } else if (dim == 1) {
            sliceOffset = this.offset + this.stride2 * idx;
            sliceStride1 = this.stride1;
            sliceStride2 = this.stride3;
            sliceStride3 = this.stride4;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim3;
            sliceDim3 = this.dim4;
        } else if (dim == 2) {
            sliceOffset = this.offset + this.stride3 * idx;
            sliceStride1 = this.stride1;
            sliceStride2 = this.stride2;
            sliceStride3 = this.stride4;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim4;
        } else if (dim == 3) {
            sliceOffset = this.offset + this.stride4 * idx;
            sliceStride1 = this.stride1;
            sliceStride2 = this.stride2;
            sliceStride3 = this.stride3;
            sliceDim1 = this.dim1;
            sliceDim2 = this.dim2;
            sliceDim3 = this.dim3;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds.");
        }
        return new StriddenLong3D(this.data, sliceOffset, sliceStride1, sliceStride2, sliceStride3, sliceDim1, sliceDim2, sliceDim3);
    }

    @Override
    public Long4D view(Range rng1, Range rng2, Range rng3, Range rng4) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, this.offset, this.stride1);
        CompiledRange cr2 = new CompiledRange(rng2, this.dim2, 0, this.stride2);
        CompiledRange cr3 = new CompiledRange(rng3, this.dim3, 0, this.stride3);
        CompiledRange cr4 = new CompiledRange(rng4, this.dim4, 0, this.stride4);
        if (cr1.doesNothing() && cr2.doesNothing() && cr3.doesNothing() && cr4.doesNothing()) {
            return this;
        }
        return new StriddenLong4D(this.data, cr1.getOffset() + cr2.getOffset() + cr3.getOffset() + cr4.getOffset(), cr1.getStride(), cr2.getStride(), cr3.getStride(), cr4.getStride(), cr1.getNumber(), cr2.getNumber(), cr3.getNumber(), cr4.getNumber());
    }

    @Override
    public Long4D view(int[] sel1, int[] sel2, int[] sel3, int[] sel4) {
        int[] idx1 = Helper.select(this.offset, this.stride1, this.dim1, sel1);
        int[] idx2 = Helper.select(0, this.stride2, this.dim2, sel2);
        int[] idx3 = Helper.select(0, this.stride3, this.dim3, sel3);
        int[] idx4 = Helper.select(0, this.stride4, this.dim4, sel4);
        return new SelectedLong4D(this.data, idx1, idx2, idx3, idx4);
    }

    @Override
    public Long1D as1D() {
        return new FlatLong1D(this.flatten(), this.number);
    }
}

