/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Byte1D;
import mitiv.array.Double1D;
import mitiv.array.Float1D;
import mitiv.array.Int1D;
import mitiv.array.Long1D;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.array.ShortScalar;
import mitiv.array.impl.FlatShort1D;
import mitiv.array.impl.StriddenShort1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public abstract class Short1D
extends Array1D
implements ShortArray {
    protected Short1D(int dim1) {
        super(dim1);
    }

    protected Short1D(int[] dims) {
        super(dims);
    }

    protected Short1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 1;
    }

    public abstract short get(int var1);

    public abstract void set(int var1, short var2);

    @Override
    public void fill(short value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, value);
            ++i1;
        }
    }

    @Override
    public void increment(short value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, (short)(this.get(i1) + value));
            ++i1;
        }
    }

    @Override
    public void decrement(short value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, (short)(this.get(i1) - value));
            ++i1;
        }
    }

    @Override
    public void scale(short value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, (short)(this.get(i1) * value));
            ++i1;
        }
    }

    @Override
    public void map(ShortFunction function) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, function.apply(this.get(i1)));
            ++i1;
        }
    }

    @Override
    public void fill(ShortGenerator generator) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, generator.nextShort());
            ++i1;
        }
    }

    @Override
    public void scan(ShortScanner scanner) {
        scanner.initialize(this.get(0));
        int i1 = 1;
        while (i1 < this.dim1) {
            scanner.update(this.get(i1));
            ++i1;
        }
    }

    @Override
    public short[] flatten(boolean forceCopy) {
        short[] out = new short[this.number];
        int i1 = 0;
        while (i1 < this.dim1) {
            out[i1] = this.get(i1);
            ++i1;
        }
        return out;
    }

    @Override
    public short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public short min() {
        short minValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            short value = this.get(i1);
            if (value < minValue) {
                minValue = value;
            }
            ++i1;
        }
        return minValue;
    }

    @Override
    public short max() {
        short maxValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            short value = this.get(i1);
            if (value > maxValue) {
                maxValue = value;
            }
            ++i1;
        }
        return maxValue;
    }

    @Override
    public short[] getMinAndMax() {
        short[] result = new short[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(short[] mm) {
        short minValue;
        short maxValue = minValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            short value = this.get(i1);
            if (value < minValue) {
                minValue = value;
            }
            if (value > maxValue) {
                maxValue = value;
            }
            ++i1;
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = this.get(0);
        int i1 = 1;
        while (i1 < this.dim1) {
            totalValue += this.get(i1);
            ++i1;
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = (byte)this.get(i1);
            ++i1;
        }
        return Byte1D.wrap(out, this.dim1);
    }

    @Override
    public Short1D toShort() {
        return this;
    }

    @Override
    public Int1D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Int1D.wrap(out, this.dim1);
    }

    @Override
    public Long1D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Long1D.wrap(out, this.dim1);
    }

    @Override
    public Float1D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Float1D.wrap(out, this.dim1);
    }

    @Override
    public Double1D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Double1D.wrap(out, this.dim1);
    }

    @Override
    public Short1D copy() {
        return new FlatShort1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Short1D src = arr.getType() == 1 ? (Short1D)arr : (Short1D)arr.toShort();
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, src.get(i1));
            ++i1;
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i1 = 0;
            while (i1 < this.dim1) {
                this.set(i1, (short)src.get(i1));
                ++i1;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i1 = 0;
            while (i1 < this.dim1) {
                this.set(i1, (short)src.get(i1));
                ++i1;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Short1D create() {
        return new FlatShort1D(this.getShape());
    }

    public static Short1D create(int dim1) {
        return new FlatShort1D(dim1);
    }

    public static Short1D create(int[] dims) {
        return new FlatShort1D(dims);
    }

    public static Short1D create(Shape shape) {
        return new FlatShort1D(shape);
    }

    public static Short1D wrap(short[] data, int dim1) {
        return new FlatShort1D(data, dim1);
    }

    public static Short1D wrap(short[] data, int[] dims) {
        return new FlatShort1D(data, dims);
    }

    public static Short1D wrap(short[] data, Shape shape) {
        return new FlatShort1D(data, shape);
    }

    public static Short1D wrap(short[] data, int offset, int stride1, int dim1) {
        return new StriddenShort1D(data, offset, stride1, dim1);
    }

    @Override
    public abstract ShortScalar slice(int var1);

    @Override
    public abstract ShortScalar slice(int var1, int var2);

    @Override
    public abstract Short1D view(Range var1);

    @Override
    public abstract Short1D view(int[] var1);

    @Override
    public abstract Short1D as1D();
}

