/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;

public abstract class VectorSpace {
    protected final int number;

    protected VectorSpace(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("Bad vector space size.");
        }
        this.number = number;
    }

    public final int getNumber() {
        return this.number;
    }

    public abstract Vector create();

    public abstract Vector create(double var1);

    public final double dot(Vector x, Vector y) {
        this.check(x);
        this.check(y);
        return this._dot(x, y);
    }

    public final double dot(Vector w, Vector x, Vector y) {
        this.check(w);
        this.check(x);
        this.check(y);
        return this._dot(w, x, y);
    }

    protected abstract double _dot(Vector var1, Vector var2);

    protected abstract double _dot(Vector var1, Vector var2, Vector var3);

    public final double norm2(Vector x) throws IncorrectSpaceException {
        this.check(x);
        return this._norm2(x);
    }

    protected double _norm2(Vector x) {
        return Math.sqrt(this._dot(x, x));
    }

    public final double norm1(Vector x) throws IncorrectSpaceException {
        this.check(x);
        return this._norm1(x);
    }

    protected abstract double _norm1(Vector var1);

    public final double normInf(Vector x) throws IncorrectSpaceException {
        this.check(x);
        return this._normInf(x);
    }

    protected abstract double _normInf(Vector var1);

    public void scale(Vector v, double alpha) {
        this.check(v);
        this._scale(v, alpha);
    }

    public void scale(Vector dst, double alpha, Vector src) {
        this.check(dst);
        this.check(src);
        this._scale(dst, alpha, src);
    }

    protected abstract void _scale(Vector var1, double var2, Vector var4);

    protected void _scale(Vector v, double alpha) {
        this._scale(v, alpha, v);
    }

    public final void combine(double alpha, Vector x, double beta, Vector y) throws IncorrectSpaceException {
        this.check(x);
        this.check(y);
        this._combine(alpha, x, beta, y);
    }

    protected void _combine(double alpha, Vector x, double beta, Vector y) {
        this._combine(y, alpha, x, beta, y);
    }

    public final void combine(Vector dst, double alpha, Vector x, double beta, Vector y) throws IncorrectSpaceException {
        this.check(x);
        this.check(y);
        this.check(dst);
        this._combine(dst, alpha, x, beta, y);
    }

    protected abstract void _combine(Vector var1, double var2, Vector var4, double var5, Vector var7);

    public final void combine(Vector dst, double alpha, Vector x, double beta, Vector y, double gamma, Vector z) throws IncorrectSpaceException {
        this.check(x);
        this.check(y);
        this.check(z);
        this.check(dst);
        this._combine(dst, alpha, x, beta, y, gamma, z);
    }

    protected abstract void _combine(Vector var1, double var2, Vector var4, double var5, Vector var7, double var8, Vector var10);

    public final void multiply(Vector dst, Vector x, Vector y) throws IncorrectSpaceException {
        this.check(x);
        this.check(y);
        this.check(dst);
        this._multiply(dst, x, y);
    }

    protected abstract void _multiply(Vector var1, Vector var2, Vector var3);

    public final void copy(Vector dst, Vector src) throws IncorrectSpaceException {
        this.check(src);
        if (dst != src) {
            this.check(dst);
            this._copy(dst, src);
        }
    }

    protected void _copy(Vector dst, Vector src) {
        this._combine(1.0, src, 0.0, dst);
    }

    public final void swap(Vector x, Vector y) throws IncorrectSpaceException {
        this.check(x);
        if (y != x) {
            this.check(y);
            this._swap(x, y);
        }
    }

    protected abstract void _swap(Vector var1, Vector var2);

    public Vector clone(Vector vec) throws IncorrectSpaceException {
        this.check(vec);
        return this._clone(vec);
    }

    protected Vector _clone(Vector vec) {
        Vector cpy = this.create();
        this._copy(cpy, vec);
        return cpy;
    }

    public Vector one() {
        return this.create(1.0);
    }

    public Vector zero() {
        return this.create(0.0);
    }

    public final void zero(Vector v) {
        this.check(v);
        this._zero(v);
    }

    protected void _zero(Vector v) {
        this._fill(v, 0.0);
    }

    public final void fill(Vector x, double alpha) {
        this.check(x);
        this._fill(x, alpha);
    }

    protected abstract void _fill(Vector var1, double var2);

    public final boolean owns(Vector v) {
        return v != null && v.belongsTo(this);
    }

    public final void check(Vector v) throws IncorrectSpaceException {
        if (!this.owns(v)) {
            throw new IncorrectSpaceException();
        }
    }
}

