/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;

public class CommandButtonVisualStateTracker {
    protected PropertyChangeListener substancePropertyListener;
    protected StateTransitionTracker actionStateTransitionTracker;
    protected StateTransitionTracker popupStateTransitionTracker;

    public void installListeners(final AbstractCommandButton b) {
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("actionModel".equals(evt.getPropertyName())) {
                    CommandButtonVisualStateTracker.this.actionStateTransitionTracker.setModel((ButtonModel)b.getActionModel());
                }
                if ("popupModel".equals(evt.getPropertyName())) {
                    JCommandButton jcb = (JCommandButton)b;
                    CommandButtonVisualStateTracker.this.popupStateTransitionTracker.setModel((ButtonModel)jcb.getPopupModel());
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
        this.actionStateTransitionTracker = new StateTransitionTracker((JComponent)b, (ButtonModel)b.getActionModel());
        this.actionStateTransitionTracker.registerModelListeners();
        if (b instanceof JCommandButton) {
            JCommandButton jcb = (JCommandButton)b;
            this.popupStateTransitionTracker = new StateTransitionTracker((JComponent)jcb, (ButtonModel)jcb.getPopupModel());
            this.popupStateTransitionTracker.registerModelListeners();
        }
    }

    public void uninstallListeners(AbstractCommandButton b) {
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.actionStateTransitionTracker.unregisterModelListeners();
        this.actionStateTransitionTracker = null;
        if (this.popupStateTransitionTracker != null) {
            this.popupStateTransitionTracker.unregisterModelListeners();
            this.popupStateTransitionTracker = null;
        }
    }

    public StateTransitionTracker getActionStateTransitionTracker() {
        return this.actionStateTransitionTracker;
    }

    public StateTransitionTracker getPopupStateTransitionTracker() {
        return this.popupStateTransitionTracker;
    }
}

