/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.Length;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsLength implements Enumeration
{
    YOTTAM("Ym"),
    ZETTAM("Zm"),
    EXAM("Em"),
    PETAM("Pm"),
    TERAM("Tm"),
    GIGAM("Gm"),
    MEGAM("Mm"),
    KM("km"),
    HM("hm"),
    DAM("dam"),
    M("m"),
    DM("dm"),
    CM("cm"),
    MM("mm"),
    MICROM("\u00b5m"),
    NM("nm"),
    PM("pm"),
    FM("fm"),
    AM("am"),
    ZM("zm"),
    YM("ym"),
    ANGSTROM("\u00c5"),
    THOU("thou"),
    LI("li"),
    IN("in"),
    FT("ft"),
    YD("yd"),
    MI("mi"),
    UA("ua"),
    LY("ly"),
    PC("pc"),
    PT("pt"),
    PIXEL("pixel"),
    REFERENCEFRAME("reference frame");

    private final String value;

    private UnitsLength(String value) {
        this.value = value;
    }

    public static UnitsLength fromString(String value) throws EnumerationException {
        if ("Ym".equals(value)) {
            return YOTTAM;
        }
        if ("Zm".equals(value)) {
            return ZETTAM;
        }
        if ("Em".equals(value)) {
            return EXAM;
        }
        if ("Pm".equals(value)) {
            return PETAM;
        }
        if ("Tm".equals(value)) {
            return TERAM;
        }
        if ("Gm".equals(value)) {
            return GIGAM;
        }
        if ("Mm".equals(value)) {
            return MEGAM;
        }
        if ("km".equals(value)) {
            return KM;
        }
        if ("hm".equals(value)) {
            return HM;
        }
        if ("dam".equals(value)) {
            return DAM;
        }
        if ("m".equals(value)) {
            return M;
        }
        if ("dm".equals(value)) {
            return DM;
        }
        if ("cm".equals(value)) {
            return CM;
        }
        if ("mm".equals(value)) {
            return MM;
        }
        if ("\u00b5m".equals(value)) {
            return MICROM;
        }
        if ("nm".equals(value)) {
            return NM;
        }
        if ("pm".equals(value)) {
            return PM;
        }
        if ("fm".equals(value)) {
            return FM;
        }
        if ("am".equals(value)) {
            return AM;
        }
        if ("zm".equals(value)) {
            return ZM;
        }
        if ("ym".equals(value)) {
            return YM;
        }
        if ("\u00c5".equals(value)) {
            return ANGSTROM;
        }
        if ("thou".equals(value)) {
            return THOU;
        }
        if ("li".equals(value)) {
            return LI;
        }
        if ("in".equals(value)) {
            return IN;
        }
        if ("ft".equals(value)) {
            return FT;
        }
        if ("yd".equals(value)) {
            return YD;
        }
        if ("mi".equals(value)) {
            return MI;
        }
        if ("ua".equals(value)) {
            return UA;
        }
        if ("ly".equals(value)) {
            return LY;
        }
        if ("pc".equals(value)) {
            return PC;
        }
        if ("pt".equals(value)) {
            return PT;
        }
        if ("pixel".equals(value)) {
            return PIXEL;
        }
        if ("reference frame".equals(value)) {
            return REFERENCEFRAME;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, UnitsLength.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PrimitiveNumber> Length create(T newValue, UnitsLength newUnit) {
        Length theQuantity = null;
        try {
            theQuantity = UnitsLengthEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Number> Length create(T newValue, UnitsLength newUnit) {
        Length theQuantity = null;
        try {
            theQuantity = UnitsLengthEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }
}

