/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.IJ;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;

public class EdtByteInv {
    public ImageFloat run(ImageByte imageByte, int n, float f, float f2, int n2) throws Exception {
        int n3;
        int n4;
        int n5;
        FloatProcessor floatProcessor;
        int n6 = imageByte.sizeX;
        int n7 = imageByte.sizeY;
        int n8 = imageByte.sizeZ;
        float f3 = f2 / f;
        byte[][] byArray = imageByte.pixels;
        int n9 = n2;
        ImageStack imageStack = new ImageStack(n6, n7);
        float[][] fArrayArray = new float[n8][];
        for (int i = 0; i < n8; ++i) {
            floatProcessor = new FloatProcessor(n6, n7);
            imageStack.addSlice(null, (ImageProcessor)floatProcessor);
            fArrayArray[i] = (float[])floatProcessor.getPixels();
        }
        floatProcessor = new Step1Thread[n9];
        for (n5 = 0; n5 < n9; ++n5) {
            floatProcessor[n5] = new Step1Thread(n5, n9, n6, n7, n8, n, fArrayArray, byArray);
            floatProcessor[n5].start();
        }
        try {
            for (n5 = 0; n5 < n9; ++n5) {
                floatProcessor[n5].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 1 .");
        }
        Step2Thread[] step2ThreadArray = new Step2Thread[n9];
        for (n4 = 0; n4 < n9; ++n4) {
            step2ThreadArray[n4] = new Step2Thread(n4, n9, n6, n7, n8, fArrayArray);
            step2ThreadArray[n4].start();
        }
        try {
            for (n4 = 0; n4 < n9; ++n4) {
                step2ThreadArray[n4].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 2 .");
        }
        Step3Thread[] step3ThreadArray = new Step3Thread[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            step3ThreadArray[n3] = new Step3Thread(n3, n9, n6, n7, n8, fArrayArray, byArray, n, f3);
            step3ThreadArray[n3].start();
        }
        try {
            for (n3 = 0; n3 < n9; ++n3) {
                step3ThreadArray[n3].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 3 .");
        }
        float f4 = 0.0f;
        int n10 = n6 * n7;
        for (int i = 0; i < n8; ++i) {
            float[] fArray = fArrayArray[i];
            for (int j = 0; j < n10; ++j) {
                float f5;
                if ((byArray[i][j] & 0xFF) > n) {
                    fArray[j] = 0.0f;
                    continue;
                }
                fArray[j] = f5 = (float)Math.sqrt(fArray[j]) * f;
                f4 = f5 > f4 ? f5 : f4;
            }
        }
        ImageFloat imageFloat = (ImageFloat)ImageFloat.wrap(imageStack);
        imageFloat.setScale(imageByte);
        imageFloat.setOffset(imageByte);
        imageFloat.setMinAndMax(0.0f, f4);
        return imageFloat;
    }

    String stripExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    class Step3Thread
    extends Thread {
        int thresh;
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;
        byte[][] data;
        float scaleZ;

        public Step3Thread(int n, int n2, int n3, int n4, int n5, float[][] fArray, byte[][] byArray, int n6, float f) {
            this.thresh = n6;
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.s = fArray;
            this.data = byArray;
            this.scaleZ = f * f;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            float[] fArray = new float[n];
            int[] nArray = new int[n];
            for (int i = this.thread; i < this.h; i += this.nThreads) {
                for (int j = 0; j < this.w; ++j) {
                    int n3;
                    int n4;
                    int n5;
                    boolean bl = false;
                    for (n5 = 0; n5 < this.d; ++n5) {
                        nArray[n5] = (int)this.s[n5][j + this.w * i];
                        if (nArray[n5] <= 0) continue;
                        bl = true;
                    }
                    if (!bl) continue;
                    for (n4 = 0; n4 < this.d - 1 && nArray[n4] == 0; ++n4) {
                    }
                    if (n4 > 0) {
                        --n4;
                    }
                    for (n3 = this.d - 1; n3 > 0 && nArray[n3] == 0; --n3) {
                    }
                    if (n3 < this.d - 1) {
                        ++n3;
                    }
                    for (n5 = 0; n5 < this.d; ++n5) {
                        if ((this.data[n5][j + this.w * i] & 0xFF) > this.thresh) continue;
                        float f = n2;
                        int n6 = n4;
                        int n7 = n3;
                        if (n6 > n5) {
                            n6 = n5;
                        }
                        if (n7 < n5) {
                            n7 = n5;
                        }
                        float f2 = n5 - n6;
                        for (int k = n6; k <= n7; ++k) {
                            float f3 = f2;
                            float f4 = f2;
                            f2 = f4 - 1.0f;
                            float f5 = (float)nArray[k] + f3 * f4 * this.scaleZ;
                            if (!(f5 < f)) continue;
                            f = f5;
                        }
                        fArray[n5] = f;
                    }
                    for (n5 = 0; n5 < this.d; ++n5) {
                        this.s[n5][j + this.w * i] = fArray[n5];
                    }
                }
            }
        }
    }

    class Step2Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;

        public Step2Thread(int n, int n2, int n3, int n4, int n5, float[][] fArray) {
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.s = fArray;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = this.thread; i < this.d; i += this.nThreads) {
                float[] fArray = this.s[i];
                for (int j = 0; j < this.w; ++j) {
                    int n3;
                    boolean bl = false;
                    for (n3 = 0; n3 < this.h; ++n3) {
                        nArray2[n3] = (int)fArray[j + this.w * n3];
                        if (nArray2[n3] <= 0) continue;
                        bl = true;
                    }
                    if (!bl) continue;
                    for (n3 = 0; n3 < this.h; ++n3) {
                        int n4 = n2;
                        int n5 = n3;
                        for (int k = 0; k < this.h; ++k) {
                            int n6;
                            if ((n6 = nArray2[k] + n5 * n5--) >= n4) continue;
                            n4 = n6;
                        }
                        nArray[n3] = n4;
                    }
                    for (n3 = 0; n3 < this.h; ++n3) {
                        fArray[j + this.w * n3] = nArray[n3];
                    }
                }
            }
        }
    }

    class Step1Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        int thresh;
        float[][] s;
        byte[][] data;

        public Step1Thread(int n, int n2, int n3, int n4, int n5, int n6, float[][] fArray, byte[][] byArray) {
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.thresh = n6;
            this.data = byArray;
            this.s = fArray;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            boolean[] blArray = new boolean[n];
            for (int i = this.thread; i < this.d; i += this.nThreads) {
                float[] fArray = this.s[i];
                byte[] byArray = this.data[i];
                for (int j = 0; j < this.h; ++j) {
                    int n3;
                    for (n3 = 0; n3 < this.w; ++n3) {
                        blArray[n3] = (byArray[n3 + this.w * j] & 0xFF) > this.thresh;
                    }
                    for (n3 = 0; n3 < this.w; ++n3) {
                        int n4;
                        int n5;
                        int n6 = n2;
                        for (n5 = n3; n5 < this.w; ++n5) {
                            if (!blArray[n5]) continue;
                            n4 = n3 - n5;
                            n4 *= n4;
                            n6 = n4;
                            break;
                        }
                        for (n5 = n3 - 1; n5 >= 0; --n5) {
                            if (!blArray[n5]) continue;
                            n4 = n3 - n5;
                            if ((n4 *= n4) >= n6) break;
                            n6 = n4;
                            break;
                        }
                        fArray[n3 + this.w * j] = n6;
                    }
                }
            }
        }
    }
}

