package plugins.tprovoost.painting.shapes;

import java.awt.Point;
import java.awt.geom.Line2D;

import plugins.tprovoost.painting.PaintingTools;

public class LineShape extends PaintingShape
{

    private int x1;
    private int y1;
    private int x2;
    private int y2;

    public LineShape(PaintingTools tools, int x1, int y1, int x2, int y2)
    {
        super(tools);

        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        shape = new Line2D.Double(x1, y1, x2, y2);
    }

    @Override
    public void update(Point p)
    {
        this.x2 = p.x;
        this.y2 = p.y;
        ((Line2D) shape).setLine(x1, y1, x2, y2);
    }
}
