/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tobject.IntIntObjectFunction;
import cern.colt.function.tobject.ObjectFunction;
import cern.colt.function.tobject.ObjectObjectFunction;
import cern.colt.function.tobject.ObjectProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix1DProcedure;
import cern.colt.matrix.tobject.algo.ObjectFormatter;
import cern.colt.matrix.tobject.algo.ObjectSorting;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class ObjectMatrix2D
extends AbstractMatrix2D {
    private static final long serialVersionUID = 1L;

    protected ObjectMatrix2D() {
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f) {
        if (this.size() == 0L) {
            return null;
        }
        Object a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix2D.this.getQuick(firstRow, 0));
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < ObjectMatrix2D.this.columns) {
                                a = aggr.apply(a, f.apply(ObjectMatrix2D.this.getQuick(r, c)));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0));
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c)));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, final ObjectProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object elem = ObjectMatrix2D.this.getQuick(firstRow, 0);
                        Object a = 0;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < ObjectMatrix2D.this.columns) {
                                elem = ObjectMatrix2D.this.getQuick(r, c);
                                if (cond.apply(elem)) {
                                    a = aggr.apply(a, f.apply(elem));
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            Object elem = this.getQuick(0, 0);
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    elem = this.getQuick(r, c);
                    if (cond.apply(elem)) {
                        a = aggr.apply(a, f.apply(elem));
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    public Object aggregate(final ObjectObjectFunction aggr, final ObjectFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        Object a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix2D.this.getQuick(rowElements[firstIdx], columnElements[firstIdx]));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            Object elem = ObjectMatrix2D.this.getQuick(rowElements[i], columnElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(rowElements[0], columnElements[0]));
            int i = 1;
            while (i < size) {
                Object elem = this.getQuick(rowElements[i], columnElements[i]);
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    public Object aggregate(final ObjectMatrix2D other, final ObjectObjectFunction aggr, final ObjectObjectFunction f) {
        this.checkShape(other);
        if (this.size() == 0L) {
            return null;
        }
        Object a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        Object a = f.apply(ObjectMatrix2D.this.getQuick(firstRow, 0), other.getQuick(firstRow, 0));
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < ObjectMatrix2D.this.columns) {
                                a = aggr.apply(a, f.apply(ObjectMatrix2D.this.getQuick(r, c), other.getQuick(r, c)));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0), other.getQuick(0, 0));
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    a = aggr.apply(a, f.apply(this.getQuick(r, c), other.getQuick(r, c)));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    public ObjectMatrix2D assign(final Object[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            Object[] currentRow = values[r];
                            if (currentRow.length != ObjectMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + ObjectMatrix2D.this.columns());
                            }
                            int c = 0;
                            while (c < ObjectMatrix2D.this.columns) {
                                ObjectMatrix2D.this.setQuick(r, c, currentRow[c]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                Object[] currentRow = values[r];
                if (currentRow.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                }
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, currentRow[c]);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < ObjectMatrix2D.this.columns) {
                                ObjectMatrix2D.this.setQuick(r, c, function.apply(ObjectMatrix2D.this.getQuick(r, c)));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, function.apply(this.getQuick(r, c)));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure cond, final ObjectFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < ObjectMatrix2D.this.columns) {
                                Object elem = ObjectMatrix2D.this.getQuick(r, c);
                                if (cond.apply(elem)) {
                                    ObjectMatrix2D.this.setQuick(r, c, f.apply(elem));
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    Object elem = this.getQuick(r, c);
                    if (cond.apply(elem)) {
                        this.setQuick(r, c, f.apply(elem));
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectProcedure cond, final Object value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < ObjectMatrix2D.this.columns) {
                                Object elem = ObjectMatrix2D.this.getQuick(r, c);
                                if (cond.apply(elem)) {
                                    ObjectMatrix2D.this.setQuick(r, c, value);
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    Object elem = this.getQuick(r, c);
                    if (cond.apply(elem)) {
                        this.setQuick(r, c, value);
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object[] values) {
        if (values.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstRow * ObjectMatrix2D.this.columns;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < ObjectMatrix2D.this.columns) {
                                ObjectMatrix2D.this.setQuick(r, c, values[idx++]);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, values[idx++]);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(ObjectMatrix2D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final ObjectMatrix2D other_loc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < ObjectMatrix2D.this.columns) {
                                ObjectMatrix2D.this.setQuick(r, c, other_loc.getQuick(r, c));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, other_loc.getQuick(r, c));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectMatrix2D y, final ObjectObjectFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < ObjectMatrix2D.this.columns) {
                                ObjectMatrix2D.this.setQuick(r, c, function.apply(ObjectMatrix2D.this.getQuick(r, c), y.getQuick(r, c)));
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, function.apply(this.getQuick(r, c), y.getQuick(r, c)));
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final ObjectMatrix2D y, final ObjectObjectFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            ObjectMatrix2D.this.setQuick(rowElements[i], columnElements[i], function.apply(ObjectMatrix2D.this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                this.setQuick(rowElements[i], columnElements[i], function.apply(this.getQuick(rowElements[i], columnElements[i]), y.getQuick(rowElements[i], columnElements[i])));
                ++i;
            }
        }
        return this;
    }

    public ObjectMatrix2D assign(final Object value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < ObjectMatrix2D.this.columns) {
                                ObjectMatrix2D.this.setQuick(r, c, value);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    this.setQuick(r, c, value);
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < ObjectMatrix2D.this.columns) {
                                if (ObjectMatrix2D.this.getQuick(r, c) != null) {
                                    ++cardinality;
                                }
                                ++c;
                            }
                            ++r;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    if (this.getQuick(r, c) != null) {
                        ++cardinality;
                    }
                    ++c;
                }
                ++r;
            }
        }
        return cardinality;
    }

    public ObjectMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(Object otherObj) {
        return this.equals(otherObj, true);
    }

    public boolean equals(Object otherObj, boolean testForEquality) {
        if (!(otherObj instanceof ObjectMatrix2D)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        ObjectMatrix2D other = (ObjectMatrix2D)otherObj;
        if (this.rows != other.rows()) {
            return false;
        }
        if (this.columns != other.columns()) {
            return false;
        }
        if (!testForEquality) {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    if (this.getQuick(row, column) == other.getQuick(row, column)) continue;
                    return false;
                }
            }
        } else {
            int row = this.rows;
            while (--row >= 0) {
                int column = this.columns;
                while (--column >= 0) {
                    if (!(this.getQuick(row, column) == null ? other.getQuick(row, column) != null : !this.getQuick(row, column).equals(other.getQuick(row, column)))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public ObjectMatrix2D forEachNonZero(final IntIntObjectFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < ObjectMatrix2D.this.columns) {
                                Object a;
                                Object value = ObjectMatrix2D.this.getQuick(r, c);
                                if (value != null && (a = function.apply(r, c, value)) != value) {
                                    ObjectMatrix2D.this.setQuick(r, c, a);
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    Object a;
                    Object value = this.getQuick(r, c);
                    if (value != null && (a = function.apply(r, c, value)) != value) {
                        this.setQuick(r, c, a);
                    }
                    ++c;
                }
                ++r;
            }
        }
        return this;
    }

    public Object get(int row, int column) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        return this.getQuick(row, column);
    }

    protected ObjectMatrix2D getContent() {
        return this;
    }

    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, ObjectArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int r = this.rows;
        int c = this.columns;
        int row = 0;
        while (row < r) {
            int column = 0;
            while (column < c) {
                Object value = this.getQuick(row, column);
                if (value != null) {
                    rowList.add(row);
                    columnList.add(column);
                    valueList.add(value);
                }
                ++column;
            }
            ++row;
        }
    }

    public abstract Object getQuick(int var1, int var2);

    protected boolean haveSharedCells(ObjectMatrix2D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D other) {
        return false;
    }

    public ObjectMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract ObjectMatrix2D like(int var1, int var2);

    public abstract ObjectMatrix1D like1D(int var1);

    protected abstract ObjectMatrix1D like1D(int var1, int var2, int var3);

    public void set(int row, int column, Object value) {
        if (column < 0 || column >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + row + ", column:" + column);
        }
        this.setQuick(row, column, value);
    }

    public abstract void setQuick(int var1, int var2, Object var3);

    public Object[][] toArray() {
        final Object[][] values = new Object[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            Object[] currentRow = values[r];
                            int c = 0;
                            while (c < ObjectMatrix2D.this.columns) {
                                currentRow[c] = ObjectMatrix2D.this.getQuick(r, c);
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r = 0;
            while (r < this.rows) {
                Object[] currentRow = values[r];
                int c = 0;
                while (c < this.columns) {
                    currentRow[c] = this.getQuick(r, c);
                    ++c;
                }
                ++r;
            }
        }
        return values;
    }

    public String toString() {
        return new ObjectFormatter().toString(this);
    }

    public abstract ObjectMatrix1D vectorize();

    protected ObjectMatrix2D view() {
        return (ObjectMatrix2D)this.clone();
    }

    public ObjectMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = (int)this.index(0, column);
        int viewStride = this.rowStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public ObjectMatrix2D viewColumnFlip() {
        return (ObjectMatrix2D)this.view().vColumnFlip();
    }

    public ObjectMatrix2D viewDice() {
        return (ObjectMatrix2D)this.view().vDice();
    }

    public ObjectMatrix2D viewPart(int row, int column, int height, int width) {
        return (ObjectMatrix2D)this.view().vPart(row, column, height, width);
    }

    public ObjectMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = (int)this.index(row, 0);
        int viewStride = this.columnStride;
        return this.like1D(viewSize, viewZero, viewStride);
    }

    public ObjectMatrix2D viewRowFlip() {
        return (ObjectMatrix2D)this.view().vRowFlip();
    }

    public ObjectMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = rowIndexes.length;
        while (--i2 >= 0) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
        }
        i2 = columnIndexes.length;
        while (--i2 >= 0) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
        }
        return this.viewSelectionLike(rowOffsets, columnOffsets);
    }

    public ObjectMatrix2D viewSelection(ObjectMatrix1DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < this.rows) {
            if (condition.apply(this.viewRow(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null);
    }

    protected abstract ObjectMatrix2D viewSelectionLike(int[] var1, int[] var2);

    public ObjectMatrix2D viewSorted(int column) {
        return ObjectSorting.mergeSort.sort(this, column);
    }

    public ObjectMatrix2D viewStrides(int rowStride, int columnStride) {
        return (ObjectMatrix2D)this.view().vStrides(rowStride, columnStride);
    }
}

