/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.Pressure;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsPressureEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsPressure implements Enumeration
{
    YOTTAPA("YPa"),
    ZETTAPA("ZPa"),
    EXAPA("EPa"),
    PETAPA("PPa"),
    TERAPA("TPa"),
    GIGAPA("GPa"),
    MEGAPA("MPa"),
    KPA("kPa"),
    HPA("hPa"),
    DAPA("daPa"),
    PA("Pa"),
    DPA("dPa"),
    CPA("cPa"),
    MPA("mPa"),
    MICROPA("\u00b5Pa"),
    NPA("nPa"),
    PPA("pPa"),
    FPA("fPa"),
    APA("aPa"),
    ZPA("zPa"),
    YPA("yPa"),
    BAR("bar"),
    MEGABAR("Mbar"),
    KBAR("kbar"),
    DBAR("dbar"),
    CBAR("cbar"),
    MBAR("mbar"),
    ATM("atm"),
    PSI("psi"),
    TORR("Torr"),
    MTORR("mTorr"),
    MMHG("mm Hg");

    private final String value;

    private UnitsPressure(String value) {
        this.value = value;
    }

    public static UnitsPressure fromString(String value) throws EnumerationException {
        if ("YPa".equals(value)) {
            return YOTTAPA;
        }
        if ("ZPa".equals(value)) {
            return ZETTAPA;
        }
        if ("EPa".equals(value)) {
            return EXAPA;
        }
        if ("PPa".equals(value)) {
            return PETAPA;
        }
        if ("TPa".equals(value)) {
            return TERAPA;
        }
        if ("GPa".equals(value)) {
            return GIGAPA;
        }
        if ("MPa".equals(value)) {
            return MEGAPA;
        }
        if ("kPa".equals(value)) {
            return KPA;
        }
        if ("hPa".equals(value)) {
            return HPA;
        }
        if ("daPa".equals(value)) {
            return DAPA;
        }
        if ("Pa".equals(value)) {
            return PA;
        }
        if ("dPa".equals(value)) {
            return DPA;
        }
        if ("cPa".equals(value)) {
            return CPA;
        }
        if ("mPa".equals(value)) {
            return MPA;
        }
        if ("\u00b5Pa".equals(value)) {
            return MICROPA;
        }
        if ("nPa".equals(value)) {
            return NPA;
        }
        if ("pPa".equals(value)) {
            return PPA;
        }
        if ("fPa".equals(value)) {
            return FPA;
        }
        if ("aPa".equals(value)) {
            return APA;
        }
        if ("zPa".equals(value)) {
            return ZPA;
        }
        if ("yPa".equals(value)) {
            return YPA;
        }
        if ("bar".equals(value)) {
            return BAR;
        }
        if ("Mbar".equals(value)) {
            return MEGABAR;
        }
        if ("kbar".equals(value)) {
            return KBAR;
        }
        if ("dbar".equals(value)) {
            return DBAR;
        }
        if ("cbar".equals(value)) {
            return CBAR;
        }
        if ("mbar".equals(value)) {
            return MBAR;
        }
        if ("atm".equals(value)) {
            return ATM;
        }
        if ("psi".equals(value)) {
            return PSI;
        }
        if ("Torr".equals(value)) {
            return TORR;
        }
        if ("mTorr".equals(value)) {
            return MTORR;
        }
        if ("mm Hg".equals(value)) {
            return MMHG;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, UnitsPressure.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PrimitiveNumber> Pressure create(T newValue, UnitsPressure newUnit) {
        Pressure theQuantity = null;
        try {
            theQuantity = UnitsPressureEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Number> Pressure create(T newValue, UnitsPressure newUnit) {
        Pressure theQuantity = null;
        try {
            theQuantity = UnitsPressureEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }
}

