/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunCodec;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class UlawCodec
extends SunCodec {
    static final byte[] ULAW_TABH = new byte[256];
    static final byte[] ULAW_TABL = new byte[256];
    private static final boolean ulawEncodes = true;
    private static final boolean ulawDecodes = true;
    private static final AudioFormat.Encoding[] ulawEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.ULAW, AudioFormat.Encoding.PCM_SIGNED};
    private static final short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    private static final int tempBufferSize = 64;
    private byte[] tempBuffer = null;

    public UlawCodec() {
        super(ulawEncodings, ulawEncodings);
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (sourceFormat.getSampleSizeInBits() == 16) {
                AudioFormat.Encoding[] enc = new AudioFormat.Encoding[]{AudioFormat.Encoding.ULAW};
                return enc;
            }
            return new AudioFormat.Encoding[0];
        }
        if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
            if (sourceFormat.getSampleSizeInBits() == 8) {
                AudioFormat.Encoding[] enc = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
                return enc;
            }
            return new AudioFormat.Encoding[0];
        }
        return new AudioFormat.Encoding[0];
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (targetEncoding.equals(AudioFormat.Encoding.PCM_SIGNED) && sourceFormat.getEncoding().equals(AudioFormat.Encoding.ULAW) || targetEncoding.equals(AudioFormat.Encoding.ULAW) && sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            return this.getOutputFormats(sourceFormat);
        }
        return new AudioFormat[0];
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        AudioFormat.Encoding sourceEncoding = sourceFormat.getEncoding();
        if (sourceEncoding.equals(targetEncoding)) {
            return sourceStream;
        }
        AudioFormat targetFormat = null;
        if (!this.isConversionSupported(targetEncoding, sourceStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + sourceStream.getFormat().toString() + " to " + targetEncoding.toString());
        }
        if (sourceEncoding.equals(AudioFormat.Encoding.ULAW) && targetEncoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            targetFormat = new AudioFormat(targetEncoding, sourceFormat.getSampleRate(), sourceFormat.getSampleSizeInBits() * 2, sourceFormat.getChannels(), sourceFormat.getFrameSize() * 2, sourceFormat.getFrameRate(), sourceFormat.isBigEndian());
        } else if (sourceEncoding.equals(AudioFormat.Encoding.PCM_SIGNED) && targetEncoding.equals(AudioFormat.Encoding.ULAW)) {
            targetFormat = new AudioFormat(targetEncoding, sourceFormat.getSampleRate(), sourceFormat.getSampleSizeInBits() / 2, sourceFormat.getChannels(), sourceFormat.getFrameSize() / 2, sourceFormat.getFrameRate(), sourceFormat.isBigEndian());
        } else {
            throw new IllegalArgumentException("Unsupported conversion: " + sourceStream.getFormat().toString() + " to " + targetEncoding.toString());
        }
        return this.getAudioInputStream(targetFormat, sourceStream);
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        return this.getConvertedStream(targetFormat, sourceStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat outputFormat, AudioInputStream stream) {
        AudioInputStream cs = null;
        AudioFormat inputFormat = stream.getFormat();
        if (inputFormat.matches(outputFormat)) {
            cs = stream;
        } else {
            cs = new UlawCodecStream(stream, outputFormat);
            this.tempBuffer = new byte[64];
        }
        return cs;
    }

    private AudioFormat[] getOutputFormats(AudioFormat inputFormat) {
        AudioFormat format;
        Vector<AudioFormat> formats = new Vector<AudioFormat>();
        if (inputFormat.getSampleSizeInBits() == 16 && inputFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            format = new AudioFormat(AudioFormat.Encoding.ULAW, inputFormat.getSampleRate(), 8, inputFormat.getChannels(), inputFormat.getFrameSize() / 2, inputFormat.getFrameRate(), false);
            formats.addElement(format);
        }
        if (inputFormat.getEncoding() == AudioFormat.Encoding.ULAW) {
            format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), 16, inputFormat.getChannels(), inputFormat.getFrameSize() * 2, inputFormat.getFrameRate(), false);
            formats.addElement(format);
            format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), 16, inputFormat.getChannels(), inputFormat.getFrameSize() * 2, inputFormat.getFrameRate(), true);
            formats.addElement(format);
        }
        AudioFormat[] formatArray = new AudioFormat[formats.size()];
        int i = 0;
        while (i < formatArray.length) {
            formatArray[i] = (AudioFormat)formats.elementAt(i);
            ++i;
        }
        return formatArray;
    }

    static {
        int i = 0;
        while (i < 256) {
            int ulaw = ~i;
            int t = (((ulaw &= 0xFF) & 0xF) << 3) + 132;
            t = (ulaw & 0x80) != 0 ? 132 - t : (t <<= (ulaw & 0x70) >> 4) - 132;
            UlawCodec.ULAW_TABL[i] = (byte)(t & 0xFF);
            UlawCodec.ULAW_TABH[i] = (byte)(t >> 8 & 0xFF);
            ++i;
        }
    }

    class UlawCodecStream
    extends AudioInputStream {
        boolean encode = false;
        AudioFormat encodeFormat;
        AudioFormat decodeFormat;
        byte[] tabByte1 = null;
        byte[] tabByte2 = null;
        int highByte = 0;
        int lowByte = 1;

        UlawCodecStream(AudioInputStream stream, AudioFormat outputFormat) {
            super(stream, outputFormat, -1L);
            AudioFormat inputFormat = stream.getFormat();
            if (!UlawCodec.this.isConversionSupported(outputFormat, inputFormat)) {
                throw new IllegalArgumentException("Unsupported conversion: " + inputFormat.toString() + " to " + outputFormat.toString());
            }
            if (inputFormat.getEncoding() == AudioFormat.Encoding.ULAW) {
                this.encode = false;
                this.encodeFormat = inputFormat;
                this.decodeFormat = outputFormat;
            } else {
                this.encode = true;
                this.encodeFormat = outputFormat;
                this.decodeFormat = inputFormat;
            }
            if (this.decodeFormat.isBigEndian()) {
                this.tabByte1 = ULAW_TABH;
                this.tabByte2 = ULAW_TABL;
            } else {
                this.tabByte1 = ULAW_TABL;
                this.tabByte2 = ULAW_TABH;
            }
            if (this.encodeFormat.isBigEndian()) {
                this.highByte = 0;
                this.lowByte = 1;
            } else {
                this.highByte = 1;
                this.lowByte = 0;
            }
            if (stream instanceof AudioInputStream) {
                long inputLength;
                this.frameLength = inputLength = stream.getFrameLength();
            }
            this.framePos = 0L;
            this.frameSize = inputFormat.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
        }

        private short search(short val, short[] table, short size) {
            short i = 0;
            while (i < size) {
                if (val <= table[i]) {
                    return i;
                }
                i = (short)(i + 1);
            }
            return size;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len % this.frameSize != 0) {
                len -= len % this.frameSize;
            }
            if (this.encode) {
                int BIAS = 132;
                int readCount = 0;
                int currentPos = off;
                int readLeft = len * 2;
                int readLen = readLeft > 64 ? 64 : readLeft;
                while ((readCount = this.stream.read(UlawCodec.this.tempBuffer, 0, readLen)) > 0) {
                    int i = 0;
                    while (i < readCount) {
                        byte enc;
                        int mask;
                        short sample = (short)(UlawCodec.this.tempBuffer[i + this.highByte] << 8 & 0xFF00);
                        if ((sample = (short)(sample | (short)((short)UlawCodec.this.tempBuffer[i + this.lowByte] & 0xFF))) < 0) {
                            sample = (short)(BIAS - sample);
                            mask = 127;
                        } else {
                            sample = (short)(sample + BIAS);
                            mask = 255;
                        }
                        short seg = this.search(sample, seg_end, (short)8);
                        if (seg >= 8) {
                            enc = (byte)(0x7F ^ mask);
                        } else {
                            enc = (byte)(seg << 4 | sample >> seg + 3 & 0xF);
                            enc = (byte)(enc ^ mask);
                        }
                        b[currentPos] = enc;
                        ++currentPos;
                        i += 2;
                    }
                    int n = readLen = (readLeft -= readCount) > 64 ? 64 : readLeft;
                }
                if (currentPos == off && readCount < 0) {
                    return readCount;
                }
                this.framePos += (long)((currentPos - off) / this.frameSize);
                return currentPos - off;
            }
            int readOffset = off + len / 2;
            int readLen = len / 2;
            int readCount = this.stream.read(b, readOffset, readLen);
            if (readCount < 0) {
                return readCount;
            }
            int i = off;
            while (i < off + readCount * 2) {
                b[i] = this.tabByte1[b[readOffset] & 0xFF];
                b[i + 1] = this.tabByte2[b[readOffset] & 0xFF];
                ++readOffset;
                i += 2;
            }
            this.framePos += (long)((i - off) / this.frameSize);
            return i - off;
        }
    }
}

