/*
 * Decompiled with CFR 0.152.
 */
package plugins.lagache.etrack;

import java.util.ArrayList;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.Point3D;

public class Tube {
    public ArrayList<DetectionSpot> DetectionList;
    public int t_init = -1;
    public int t_final = -1;
    public Point3D position;
    public boolean on = true;
    public boolean endo = false;

    public Tube(Point3D position, int t_init, int t_final, ArrayList<DetectionSpot> DetectionList, boolean on, boolean endo) {
        this.DetectionList = DetectionList;
        this.t_init = t_init;
        this.t_final = t_final;
        this.position = position;
        this.on = on;
        this.endo = endo;
    }

    public Tube(Point3D position) {
        this.position = position;
    }

    public Tube(Point3D position, ArrayList<DetectionSpot> DetectionList) {
        this.DetectionList = DetectionList;
        this.position = position;
        DetectionSpot spot0 = DetectionList.get(0);
        int t_min = spot0.getT();
        int t_max = spot0.getT();
        for (DetectionSpot spot : DetectionList) {
            t_min = Math.min(t_min, spot.getT());
            t_max = Math.max(t_max, spot.getT());
        }
        this.t_init = t_min;
        this.t_final = t_max;
    }

    public void setLastDetectionSpot(DetectionSpot spot) {
        if (this.DetectionList != null) {
            this.DetectionList.set(this.DetectionList.size() - 1, spot);
        }
    }

    public void addNewSpotToTube(DetectionSpot spot) {
        if (this.DetectionList == null) {
            this.DetectionList = new ArrayList();
            this.t_init = spot.getT();
        }
        this.DetectionList.add(spot);
        this.t_final = Math.max(this.t_final, spot.getT());
    }

    public DetectionSpot getLastDetectionSpot() {
        if (this.DetectionList != null) {
            return this.DetectionList.get(this.DetectionList.size() - 1);
        }
        return null;
    }
}

