/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import java.io.IOException;
import java.io.Writer;
import java.util.Random;
import javax.vecmath.Point3f;
import mcib3d.geom.Vector3D;

public class Point3D {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;

    public Point3D() {
    }

    public Point3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Point3D(Point3D point3D) {
        this.x = point3D.getX();
        this.y = point3D.getY();
        this.z = point3D.getZ();
    }

    public Point3D(Point3f point3f) {
        this.x = point3f.x;
        this.y = point3f.y;
        this.z = point3f.z;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getX() {
        return this.x;
    }

    public int getRoundX() {
        return (int)Math.round(this.x);
    }

    public int getRoundY() {
        return (int)Math.round(this.y);
    }

    public int getRoundZ() {
        return (int)Math.round(this.z);
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getY() {
        return this.y;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3D getVector3D() {
        return new Vector3D(this.x, this.y, this.z);
    }

    public Point3D getPosition() {
        return new Point3D(this.x, this.y, this.z);
    }

    public Point3f getPoint3f() {
        return new Point3f((float)this.x, (float)this.y, (float)this.z);
    }

    public void translate(Vector3D vector3D) {
        this.x += vector3D.getX();
        this.y += vector3D.getY();
        this.z += vector3D.getZ();
    }

    public void translate(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
    }

    public void scale(double d, double d2, double d3) {
        this.x *= d;
        this.y *= d2;
        this.z *= d3;
    }

    public double distance(Point3D point3D) {
        return Math.sqrt(this.distanceSquare(point3D));
    }

    public double distance(Point3D point3D, double d, double d2) {
        return Math.sqrt(this.distanceSquare(point3D, d, d2));
    }

    public double distanceSquare(Point3D point3D) {
        return (this.x - point3D.getX()) * (this.x - point3D.getX()) + (this.y - point3D.getY()) * (this.y - point3D.getY()) + (this.z - point3D.getZ()) * (this.z - point3D.getZ());
    }

    public double distanceSquare(Point3D point3D, double d, double d2) {
        return (this.x - point3D.getX()) * (this.x - point3D.getX()) * d * d + (this.y - point3D.getY()) * (this.y - point3D.getY()) * d * d + (this.z - point3D.getZ()) * (this.z - point3D.getZ()) * d2 * d2;
    }

    public double distBlock(Point3D point3D) {
        return Math.abs(this.x - point3D.getX()) + Math.abs(this.y - point3D.getY()) + Math.abs(this.z - point3D.getZ());
    }

    public String toString() {
        return "(" + this.x + " " + this.y + " " + this.z + ")";
    }

    public void xmlWrite(Writer writer) {
        try {
            writer.write("<Point3D x=\"" + this.x + "\" y=\"" + this.y + "\" z=\"" + this.z + "\" />\n");
            writer.flush();
        }
        catch (IOException iOException) {
            System.out.println("error in Point3D::XmlWrite " + iOException);
        }
    }

    public void setCoordRandom() {
        Random random = new Random();
        this.setX(random.nextGaussian());
        this.setY(random.nextGaussian());
        this.setZ(random.nextGaussian());
    }

    public boolean equals(Object object) {
        if (object instanceof Point3D) {
            Point3D point3D = (Point3D)object;
            return point3D.x == this.x && point3D.y == this.y && point3D.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        n = 31 * n + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        n = 31 * n + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return n;
    }

    public double[] getArray() {
        double[] dArray = new double[]{this.x, this.y, this.z};
        return dArray;
    }

    public boolean isInsideBoundingBox(int[] nArray) {
        return this.x >= (double)nArray[0] && this.x <= (double)nArray[1] && this.y >= (double)nArray[2] && this.y <= (double)nArray[3] && this.z >= (double)nArray[4] && this.z <= (double)nArray[5];
    }

    public boolean sameVoxel(Point3D point3D) {
        return Math.abs(this.x - point3D.x) < 0.5 && Math.abs(this.y - point3D.y) < 0.5 && Math.abs(this.z - point3D.z) < 0.5;
    }

    public boolean samePosition(Point3D point3D, double d) {
        return point3D.x - this.x < d && this.x - point3D.x < d && point3D.y - this.y < d && this.y - point3D.y < d && point3D.z - this.z < d && this.z - point3D.z < d;
    }

    public boolean samePosition(Point3D point3D) {
        return this.samePosition(point3D, 0.5);
    }

    public Point3D projectionPlane(double d, double d2, double d3, double d4) {
        double d5 = -(d * this.x + d2 * this.y + d3 * this.z + d4) / (d * d + d2 * d2 + d3 * d3);
        return new Point3D(this.x + d5 * d, this.y + d5 * d2, this.z + d5 * d3);
    }
}

