/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.utils.compression.CommandStream;
import com.sun.j3d.utils.compression.CompressedGeometryFile;
import com.sun.j3d.utils.compression.CompressionStream;
import com.sun.j3d.utils.compression.HuffmanTable;
import java.io.IOException;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.CompressedGeometryHeader;
import javax.vecmath.Point3d;

public class GeometryCompressor {
    private static final boolean benchmark = false;
    private static final boolean printStream = false;
    private static final boolean printHuffman = false;
    private HuffmanTable huffmanTable;
    private CommandStream outputBuffer;
    private CompressedGeometryHeader cgHeader = new CompressedGeometryHeader();
    private long startTime;

    public GeometryCompressor() {
        this.cgHeader.majorVersionNumber = 1;
        this.cgHeader.minorVersionNumber = 0;
        this.cgHeader.minorMinorVersionNumber = 2;
    }

    public CompressedGeometry compress(CompressionStream compressionStream) {
        this.compressStream(compressionStream);
        CompressedGeometry compressedGeometry = new CompressedGeometry(this.cgHeader, this.outputBuffer.getBytes());
        this.outputBuffer.clear();
        return compressedGeometry;
    }

    public void compress(CompressionStream compressionStream, CompressedGeometryFile compressedGeometryFile) throws IOException {
        this.compressStream(compressionStream);
        compressedGeometryFile.write(this.cgHeader, this.outputBuffer.getBytes());
        this.outputBuffer.clear();
    }

    private void compressStream(CompressionStream compressionStream) {
        this.huffmanTable = new HuffmanTable();
        compressionStream.quantize(this.huffmanTable);
        this.huffmanTable.computeTags();
        this.outputBuffer = new CommandStream(compressionStream.getByteCount() / 3);
        compressionStream.outputCommands(this.huffmanTable, this.outputBuffer);
        this.cgHeader.bufferType = compressionStream.streamType;
        this.cgHeader.bufferDataPresent = 0;
        this.cgHeader.lowerBound = new Point3d(compressionStream.ncBounds[0]);
        this.cgHeader.upperBound = new Point3d(compressionStream.ncBounds[1]);
        if (compressionStream.vertexNormals) {
            this.cgHeader.bufferDataPresent |= 1;
        }
        if (compressionStream.vertexColor3 || compressionStream.vertexColor4) {
            this.cgHeader.bufferDataPresent |= 2;
        }
        if (compressionStream.vertexColor4) {
            this.cgHeader.bufferDataPresent |= 4;
        }
        this.cgHeader.start = 0;
        this.cgHeader.size = this.outputBuffer.getByteCount();
        this.huffmanTable.clear();
    }

    private void printBench(CompressionStream compressionStream) {
        long l = System.currentTimeMillis() - this.startTime;
        int n = compressionStream.getVertexCount();
        int n2 = compressionStream.getMeshReferenceCount();
        int n3 = n2 + n;
        float f = 100.0f * (float)n2 / (float)n3;
        float f2 = (float)compressionStream.getByteCount() / (float)this.outputBuffer.getByteCount();
        int n4 = 12 + (compressionStream.vertexColor3 ? 12 : 0) + (compressionStream.vertexColor4 ? 16 : 0) + (compressionStream.vertexNormals ? 12 : 0);
        float f3 = (float)this.outputBuffer.getByteCount() / (float)n3;
        System.out.println("\nGeometryCompressor:\n" + n3 + " total vertices\n" + n + " streamed vertices\n" + n2 + " mesh buffer references (" + f + "%)\n" + compressionStream.getByteCount() + " bytes streamed geometry compressed to " + this.outputBuffer.getByteCount() + " in " + (float)l / 1000.0f + " sec\n" + (float)compressionStream.getByteCount() / (float)l + " kbytes/sec, " + "stream compression ratio " + f2 + "\n\n" + n4 + " original bytes per vertex, " + f3 + " compressed bytes per vertex\n" + "total vertex compression ratio " + (float)n4 / f3 + "\n\n" + "lower bound " + compressionStream.ncBounds[0].toString() + "\n" + "upper bound " + compressionStream.ncBounds[1].toString());
    }
}

