/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import java.io.FileNotFoundException;
import java.io.PrintStream;

public class GenerateDeterminantFromMinor {
    PrintStream stream;
    int N;

    public GenerateDeterminantFromMinor(String string) throws FileNotFoundException {
        this.stream = new PrintStream(string);
    }

    public void createClass(int n) {
        this.printTop(n);
        this.printCalls(n);
        this.print2();
        this.print3();
        for (int i = 4; i <= n; ++i) {
            this.printFunction(i);
        }
        this.stream.print("}\n");
    }

    private void printTop(int n) {
        String string = "/*\n * Copyright (c) 2009-2010, Peter Abeles. All Rights Reserved.\n *\n * This file is part of Efficient Java Matrix Library (EJML).\n *\n * EJML is free software: you can redistribute it and/or modify\n * it under the terms of the GNU Lesser General Public License as\n * published by the Free Software Foundation, either version 3\n * of the License, or (at your option) any later version.\n *\n * EJML is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n * GNU Lesser General Public License for more details.\n *\n * You should have received a copy of the GNU Lesser General Public\n * License along with EJML.  If not, see <http://www.gnu.org/licenses/>.\n */\n\npackage org.ejml.alg.dense.misc;\n\nimport org.ejml.data.RowD1Matrix64F;\n\n\n/**\n * This code was auto generated by  {@link GenerateDeterminantFromMinor} and should not be modified\n * directly.  \n * \n * @author Peter Abeles\n */\npublic class UnrolledDeterminantFromMinor {\n    \n    public static final int MAX = " + n + ";\n";
        this.stream.print(string);
    }

    private void print2() {
        this.stream.print("    public static double det2( RowD1Matrix64F mat )\n    {\n        return mat.get(0)*mat.get(3) - mat.get(1)*mat.get(2);\n    }\n\n");
    }

    private void print3() {
        this.stream.print("    public static double det3( RowD1Matrix64F mat )\n    {\n        double a11 = mat.get( 0 );\n        double a12 = mat.get( 1 );\n        double a13 = mat.get( 2 );\n        double a21 = mat.get( 3 );\n        double a22 = mat.get( 4 );\n        double a23 = mat.get( 5 );\n        double a31 = mat.get( 6 );\n        double a32 = mat.get( 7 );\n        double a33 = mat.get( 8 );\n\n        double a = a11*(a22*a33 - a23*a32);\n        double b = a12*(a21*a33 - a23*a31);\n        double c = a13*(a21*a32 - a31*a22);\n\n        return a-b+c;\n    }\n\n");
    }

    private void printCalls(int n) {
        this.stream.print("    \n    public static double det( RowD1Matrix64F mat ) {\n");
        this.stream.print("        if( mat.numRows == 2 ) {\n            return det2(mat);\n");
        for (int i = 3; i <= n; ++i) {
            this.stream.print("        } else if( mat.numRows == " + i + " ) {\n" + "            return det" + i + "(mat);            \n");
        }
        this.stream.print("        }\n        \n        throw new IllegalArgumentException(\"Not supported\");\n    }\n\n");
    }

    private void printFunction(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.stream.print("    public static double det" + n + "( RowD1Matrix64F mat )\n" + "    {\n");
        this.N = n5 = n - 1;
        int[] nArray = new int[n5 * n5];
        int n6 = 0;
        for (n4 = 1; n4 <= n5; ++n4) {
            n3 = n4 * n + 1;
            n2 = 1;
            while (n2 <= n5) {
                nArray[n6] = n6;
                this.stream.print("        double  " + this.a(n6) + " = mat.get( " + n3 + " );\n");
                ++n2;
                ++n3;
                ++n6;
            }
        }
        this.stream.print("\n");
        this.stream.print("        double ret = 0;\n");
        this.stream.print("        ret += mat.get( 0 ) * (");
        this.minor(nArray, 0, n5);
        this.stream.print(");\n");
        for (n4 = 2; n4 <= n; ++n4) {
            for (n3 = 1; n3 <= n5; ++n3) {
                n6 = n4 - 2 + (n3 - 1) * n5;
                n2 = n4 - 2 + n3 * n;
                this.stream.print("        " + this.a(n6) + " = mat.get( " + n2 + " );\n");
            }
            if (n4 % 2 == 0) {
                this.stream.print("        ret -= ");
            } else {
                this.stream.print("        ret += ");
            }
            this.stream.print("mat.get( " + (n4 - 1) + " ) * (");
            this.minor(nArray, 0, n5);
            this.stream.print(");\n");
        }
        this.stream.print("        return ret;\n");
        this.stream.print("    }\n");
        this.stream.print("\n");
    }

    private void minor(int[] nArray, int n, int n2) {
        if (n2 == 2) {
            this.stream.print(this.a(nArray[0]) + "*" + this.a(nArray[3]) + " - " + this.a(nArray[1]) + "*" + this.a(nArray[2]));
        } else {
            int n3 = n2 - 1;
            int[] nArray2 = new int[n3 * n3];
            for (int i = 0; i < n2; ++i) {
                int n4;
                int n5 = 0;
                for (n4 = 1; n4 < n2; ++n4) {
                    for (int j = 0; j < n2; ++j) {
                        if (j == i) continue;
                        nArray2[n5++] = nArray[n4 * n2 + j];
                    }
                }
                n4 = i;
                if (n4 % 2 == 0) {
                    this.stream.print(" + " + this.a(nArray[i]) + "*(");
                } else {
                    this.stream.print(" - " + this.a(nArray[i]) + "*(");
                }
                this.minor(nArray2, n + 1, n3);
                this.stream.print(")");
            }
        }
    }

    private String a(int n) {
        int n2 = n / this.N + 1;
        int n3 = n % this.N + 1;
        return "a" + n2 + "" + n3;
    }

    public static void main(String[] stringArray) throws FileNotFoundException {
        GenerateDeterminantFromMinor generateDeterminantFromMinor = new GenerateDeterminantFromMinor("UnrolledDeterminantFromMinor.java");
        generateDeterminantFromMinor.createClass(6);
    }
}

