/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.IJ;
import java.util.HashSet;
import java.util.Iterator;

public final class LibraryChecker {
    public static final String IMAGEJ_VERSION = "1.43";
    public static final String IMAGEJ_MSG = "Sorry, the Bio-Formats plugins require ImageJ v1.43 or later.";
    public static final String URL_BF_SOFTWARE = "http://www.openmicroscopy.org/site/products/bio-formats";

    private LibraryChecker() {
    }

    public static boolean checkClass(String className) {
        try {
            Class.forName(className);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void checkLibrary(Library library, HashSet<String> missing) {
        switch (library) {
            case BIO_FORMATS: {
                LibraryChecker.checkLibrary("org.slf4j.Logger", "slf4j-api-1.7.2.jar", missing);
                LibraryChecker.checkLibrary("loci.common.RandomAccessInputStream", "common.jar", missing);
                LibraryChecker.checkLibrary("loci.formats.FormatHandler", "bio-formats.jar", missing);
                LibraryChecker.checkLibrary("loci.poi.poifs.filesystem.POIFSDocument", "ome-poi.jar", missing);
                LibraryChecker.checkLibrary("mdbtools.libmdb.MdbFile", "mdbtools-java.jar", missing);
                break;
            }
            case OME_JAVA_XML: {
                LibraryChecker.checkLibrary("ome.xml.model.OMEModelObject", "ome-xml.jar", missing);
                break;
            }
            case FORMS: {
                LibraryChecker.checkLibrary("com.jgoodies.forms.layout.FormLayout", "jgoodies-forms-1.7.2.jar", missing);
            }
        }
    }

    public static void checkLibrary(String className, String jarFile, HashSet<String> missing) {
        if (!LibraryChecker.checkClass(className)) {
            missing.add(jarFile);
        }
    }

    public static boolean checkJava() {
        String version = System.getProperty("java.version");
        double ver = Double.parseDouble(version.substring(0, 3));
        if (ver < 1.6) {
            IJ.error((String)"Bio-Formats Plugins", (String)"Sorry, the Bio-Formats plugins require Java 1.6 or later.\nYou can download ImageJ with JRE 1.6 from the ImageJ web site.");
            return false;
        }
        return true;
    }

    public static boolean checkImageJ() {
        return LibraryChecker.checkImageJ(IMAGEJ_VERSION, IMAGEJ_MSG);
    }

    public static boolean checkImageJ(String target, String msg) {
        return LibraryChecker.checkImageJ(target, msg, "Bio-Formats Plugins");
    }

    public static boolean checkImageJ(String target, String msg, String title) {
        boolean success;
        try {
            String current = IJ.getVersion();
            success = current != null && current.compareTo(target) >= 0;
        }
        catch (NoSuchMethodError err) {
            success = false;
        }
        if (!success) {
            IJ.error((String)title, (String)msg);
        }
        return success;
    }

    public static boolean checkMissing(HashSet<String> missing) {
        int num = missing.size();
        if (num == 0) {
            return true;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("The following librar");
        sb.append(num == 1 ? "y was" : "ies were");
        sb.append(" not found:");
        Iterator<String> iter = missing.iterator();
        for (int i = 0; i < num; ++i) {
            sb.append("\n    " + iter.next());
        }
        String them = num == 1 ? "it" : "them";
        sb.append("\nPlease download ");
        sb.append(them);
        sb.append(" from the Bio-Formats website at");
        sb.append("\n    http://www.openmicroscopy.org/site/products/bio-formats");
        sb.append("\nand place ");
        sb.append(them);
        sb.append(" in the ImageJ plugins folder.");
        IJ.error((String)"Bio-Formats Plugins", (String)sb.toString());
        return false;
    }

    public static enum Library {
        BIO_FORMATS,
        OME_JAVA_XML,
        FORMS;

    }
}

