/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseCCFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfcomplex.FComplexMult;
import cern.jet.math.tfcomplex.FComplexPlusMultFirst;
import cern.jet.math.tfcomplex.FComplexPlusMultSecond;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseRCFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected float[] values;

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }

    public SparseRCFComplexMatrix2D(float[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseRCFComplexMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseRCFComplexMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.columnIndexes = new int[nzmax];
        this.values = new float[2 * nzmax];
        this.rowPointers = new int[rows + 1];
    }

    public SparseRCFComplexMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, float re, float im, boolean removeDuplicates) {
        block7: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block7;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (re == 0.0f && im == 0.0f) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new float[2 * nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        int k = 0;
        while (k < nz) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            ++k;
        }
        this.cumsum(this.rowPointers, w, rows);
        k = 0;
        while (k < nz) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[2 * r] = re;
            this.values[2 * r + 1] = im;
            ++k;
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
    }

    public SparseRCFComplexMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, float[] values, boolean removeDuplicates, boolean removeZeroes) {
        block8: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block8;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (2 * rowIndexes.length != values.length) {
            throw new IllegalArgumentException("2 * rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new float[2 * nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        int k = 0;
        while (k < nz) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            ++k;
        }
        this.cumsum(this.rowPointers, w, rows);
        k = 0;
        while (k < nz) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[2 * r] = values[2 * k];
            this.values[2 * r + 1] = values[2 * k + 1];
            ++k;
        }
        if (removeZeroes) {
            this.removeZeroes();
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
    }

    public SparseRCFComplexMatrix2D(int rows, int columns, int[] rowPointers, int[] columnIndexes, float[] values) {
        block4: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block4;
                throw exc;
            }
        }
        if (rowPointers.length != rows + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        if (2 * columnIndexes.length != values.length) {
            throw new IllegalArgumentException("2 * columnIndexes.length != values.length");
        }
        this.rowPointers = rowPointers;
        this.columnIndexes = columnIndexes;
        this.values = values;
    }

    @Override
    public FComplexMatrix2D assign(final FComplexFComplexFunction function) {
        if (function instanceof FComplexMult) {
            float[] alpha = ((FComplexMult)function).multiplicator;
            if (alpha[0] == 1.0f && alpha[1] == 0.0f) {
                return this;
            }
            if (alpha[0] == 0.0f && alpha[1] == 0.0f) {
                return this.assign(alpha);
            }
            if (alpha[0] != alpha[0] || alpha[1] != alpha[1]) {
                return this.assign(alpha);
            }
            int nz = this.cardinality();
            float[] elem = new float[2];
            int j = 0;
            while (j < nz) {
                elem[0] = this.values[2 * j];
                elem[1] = this.values[2 * j + 1];
                elem = FComplex.mult(elem, alpha);
                this.values[2 * j] = elem[0];
                this.values[2 * j + 1] = elem[1];
                ++j;
            }
        } else {
            this.forEachNonZero(new IntIntFComplexFunction(){

                @Override
                public float[] apply(int i, int j, float[] value) {
                    return function.apply(value);
                }
            });
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(float re, float im) {
        if (re == 0.0f && im == 0.0f) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, 0.0f);
        } else {
            int nnz = this.cardinality();
            int i = 0;
            while (i < nnz) {
                this.values[2 * i] = re;
                this.values[2 * i + 1] = im;
                ++i;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseRCFComplexMatrix2D) {
            SparseRCFComplexMatrix2D other = (SparseRCFComplexMatrix2D)source;
            System.arraycopy(other.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int nzmax = other.columnIndexes.length;
            if (this.columnIndexes.length < nzmax) {
                this.columnIndexes = new int[nzmax];
                this.values = new float[2 * nzmax];
            }
            System.arraycopy(other.columnIndexes, 0, this.columnIndexes, 0, nzmax);
            System.arraycopy(other.values, 0, this.values, 0, other.values.length);
        } else if (source instanceof SparseCCFComplexMatrix2D) {
            SparseCCFComplexMatrix2D other = ((SparseCCFComplexMatrix2D)source).getConjugateTranspose();
            this.rowPointers = other.getColumnPointers();
            this.columnIndexes = other.getRowIndexes();
            this.values = other.getValues();
        } else {
            this.assign(0.0f, 0.0f);
            source.forEachNonZero(new IntIntFComplexFunction(){

                @Override
                public float[] apply(int i, int j, float[] value) {
                    SparseRCFComplexMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D y, FComplexFComplexFComplexFunction function) {
        float[] elem;
        float[] alpha;
        this.checkShape(y);
        if (y instanceof SparseRCFComplexMatrix2D && function == FComplexFunctions.plus) {
            SparseRCFComplexMatrix2D yy = (SparseRCFComplexMatrix2D)y;
            int[] rowPointersY = yy.rowPointers;
            int[] columnIndexesY = yy.columnIndexes;
            float[] valuesY = yy.values;
            int[] rowPointersC = new int[this.rows + 1];
            int cnz = Math.max(this.columnIndexes.length, (int)Math.min(Integer.MAX_VALUE, (long)this.rowPointers[this.rows] + (long)rowPointersY[this.rows]));
            int[] columnIndexesC = new int[cnz];
            float[] valuesC = new float[2 * cnz];
            int nrow = this.rows;
            int ncol = this.columns;
            int nzmax = cnz;
            if (function == FComplexFunctions.plus) {
                int kc;
                rowPointersC[0] = kc = 0;
                int i = 0;
                while (i < nrow) {
                    int ka = this.rowPointers[i];
                    int kb = rowPointersY[i];
                    int kamax = this.rowPointers[i + 1] - 1;
                    int kbmax = rowPointersY[i + 1] - 1;
                    while (ka <= kamax || kb <= kbmax) {
                        int j2;
                        int j1 = ka <= kamax ? this.columnIndexes[ka] : ncol + 1;
                        if (j1 == (j2 = kb <= kbmax ? columnIndexesY[kb] : ncol + 1)) {
                            valuesC[2 * kc] = this.values[2 * ka] + valuesY[2 * kb];
                            valuesC[2 * kc + 1] = this.values[2 * ka + 1] + valuesY[2 * kb + 1];
                            columnIndexesC[kc] = j1;
                            ++ka;
                            ++kb;
                            ++kc;
                        } else if (j1 < j2) {
                            columnIndexesC[kc] = j1;
                            valuesC[2 * kc] = this.values[2 * ka];
                            valuesC[2 * kc + 1] = this.values[2 * ka + 1];
                            ++ka;
                            ++kc;
                        } else if (j1 > j2) {
                            columnIndexesC[kc] = j2;
                            valuesC[2 * kc] = valuesY[2 * kb];
                            valuesC[2 * kc + 1] = valuesY[2 * kb + 1];
                            ++kb;
                            ++kc;
                        }
                        if (kc < nzmax) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    rowPointersC[i + 1] = kc;
                    ++i;
                }
                this.rowPointers = rowPointersC;
                this.columnIndexes = columnIndexesC;
                this.values = valuesC;
                return this;
            }
        }
        if (function instanceof FComplexPlusMultSecond) {
            alpha = ((FComplexPlusMultSecond)function).multiplicator;
            if (alpha[0] == 0.0f && alpha[1] == 0.0f) {
                return this;
            }
            y.forEachNonZero(new IntIntFComplexFunction(){

                @Override
                public float[] apply(int i, int j, float[] value) {
                    SparseRCFComplexMatrix2D.this.setQuick(i, j, FComplex.plus(SparseRCFComplexMatrix2D.this.getQuick(i, j), FComplex.mult(alpha, value)));
                    return value;
                }
            });
            return this;
        }
        if (function instanceof FComplexPlusMultFirst) {
            alpha = ((FComplexPlusMultFirst)function).multiplicator;
            if (alpha[0] == 0.0f && alpha[1] == 0.0f) {
                return this.assign(y);
            }
            y.forEachNonZero(new IntIntFComplexFunction(){

                @Override
                public float[] apply(int i, int j, float[] value) {
                    SparseRCFComplexMatrix2D.this.setQuick(i, j, FComplex.plus(FComplex.mult(alpha, SparseRCFComplexMatrix2D.this.getQuick(i, j)), value));
                    return value;
                }
            });
            return this;
        }
        if (function == FComplexFunctions.mult) {
            elem = new float[2];
            int i = 0;
            while (i < this.rows) {
                int high = this.rowPointers[i + 1];
                int k = this.rowPointers[i];
                while (k < high) {
                    int j = this.columnIndexes[k];
                    elem[0] = this.values[2 * k];
                    elem[1] = this.values[2 * k + 1];
                    elem = FComplex.mult(elem, y.getQuick(i, j));
                    this.values[2 * k] = elem[0];
                    this.values[2 * k + 1] = elem[1];
                    if (this.values[2 * k] == 0.0f && this.values[2 * k + 1] == 0.0f) {
                        this.remove(i, j);
                    }
                    ++k;
                }
                ++i;
            }
            return this;
        }
        if (function == FComplexFunctions.div) {
            elem = new float[2];
            int i = 0;
            while (i < this.rows) {
                int high = this.rowPointers[i + 1];
                int k = this.rowPointers[i];
                while (k < high) {
                    int j = this.columnIndexes[k];
                    elem[0] = this.values[2 * k];
                    elem[1] = this.values[2 * k + 1];
                    elem = FComplex.div(elem, y.getQuick(i, j));
                    this.values[2 * k] = elem[0];
                    this.values[2 * k + 1] = elem[1];
                    if (this.values[2 * k] == 0.0f && this.values[2 * k + 1] == 0.0f) {
                        this.remove(i, j);
                    }
                    ++k;
                }
                ++i;
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    @Override
    public FComplexMatrix2D forEachNonZero(IntIntFComplexFunction function) {
        float[] value = new float[2];
        int i = 0;
        while (i < this.rows) {
            int high = this.rowPointers[i + 1];
            int k = this.rowPointers[i];
            while (k < high) {
                int j = this.columnIndexes[k];
                value[0] = this.values[2 * k];
                value[1] = this.values[2 * k + 1];
                float[] r = function.apply(i, j, value);
                if (r[0] != value[0] || r[1] != value[1]) {
                    this.values[2 * k] = r[0];
                    this.values[2 * k + 1] = r[1];
                }
                ++k;
            }
            ++i;
        }
        return this;
    }

    public SparseCCFComplexMatrix2D getColumnCompressed() {
        SparseRCFComplexMatrix2D tr = this.getConjugateTranspose();
        SparseCCFComplexMatrix2D cc = new SparseCCFComplexMatrix2D(this.rows, this.columns);
        cc.rowIndexes = tr.columnIndexes;
        cc.columnPointers = tr.rowPointers;
        cc.values = tr.values;
        return cc;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseFComplexMatrix2D getDense() {
        final DenseFComplexMatrix2D dense = new DenseFComplexMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntFComplexFunction(){

            @Override
            public float[] apply(int i, int j, float[] value) {
                dense.setQuick(i, j, SparseRCFComplexMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    @Override
    public synchronized float[] getQuick(int row, int column) {
        int k = SparseRCFComplexMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        float[] v = new float[2];
        if (k >= 0) {
            v[0] = this.values[2 * k];
            v[1] = this.values[2 * k + 1];
        }
        return v;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    @Override
    public SparseRCFComplexMatrix2D getConjugateTranspose() {
        int nnz = this.rowPointers[this.rows];
        int[] w = new int[this.columns];
        int[] rowPointersT = new int[this.columns + 1];
        int[] columnIndexesT = new int[nnz];
        float[] valuesT = new float[2 * nnz];
        int p = 0;
        while (p < nnz) {
            int n = this.columnIndexes[p];
            w[n] = w[n] + 1;
            ++p;
        }
        this.cumsum(rowPointersT, w, this.columns);
        int j = 0;
        while (j < this.rows) {
            int high = this.rowPointers[j + 1];
            int p2 = this.rowPointers[j];
            while (p2 < high) {
                int n = this.columnIndexes[p2];
                w[n] = w[n] + 1;
                columnIndexesT[q] = j;
                valuesT[2 * q] = this.values[2 * p2];
                valuesT[2 * q + 1] = -this.values[2 * p2 + 1];
                ++p2;
            }
            ++j;
        }
        SparseRCFComplexMatrix2D T = new SparseRCFComplexMatrix2D(this.columns, this.rows);
        T.rowPointers = rowPointersT;
        T.columnIndexes = columnIndexesT;
        T.values = valuesT;
        return T;
    }

    public float[] getValues() {
        return this.values;
    }

    @Override
    public FComplexMatrix2D like(int rows, int columns) {
        return new SparseRCFComplexMatrix2D(rows, columns);
    }

    @Override
    public FComplexMatrix1D like1D(int size) {
        return new SparseFComplexMatrix1D(size);
    }

    public void removeDuplicates() {
        int nz = 0;
        int[] w = new int[this.columns];
        int i = 0;
        while (i < this.columns) {
            w[i] = -1;
            ++i;
        }
        int j = 0;
        while (j < this.rows) {
            int q = nz;
            int p = this.rowPointers[j];
            while (p < this.rowPointers[j + 1]) {
                i = this.columnIndexes[p];
                if (w[i] >= q) {
                    int n = 2 * w[i];
                    this.values[n] = this.values[n] + this.values[2 * p];
                    int n2 = 2 * w[i] + 1;
                    this.values[n2] = this.values[n2] + this.values[2 * p + 1];
                } else {
                    w[i] = nz;
                    this.columnIndexes[nz] = i;
                    this.values[2 * nz] = this.values[2 * p];
                    this.values[2 * nz + 1] = this.values[2 * p + 1];
                    ++nz;
                }
                ++p;
            }
            this.rowPointers[j] = q;
            ++j;
        }
        this.rowPointers[this.rows] = nz;
    }

    public void removeZeroes() {
        int nz = 0;
        float eps = (float)Math.pow(2.0, -23.0);
        float[] elem = new float[2];
        int j = 0;
        while (j < this.rows) {
            int p = this.rowPointers[j];
            this.rowPointers[j] = nz;
            while (p < this.rowPointers[j + 1]) {
                elem[0] = this.values[2 * p];
                elem[1] = this.values[2 * p + 1];
                if (FComplex.abs(elem) > eps) {
                    this.values[2 * nz] = this.values[2 * p];
                    this.values[2 * nz + 1] = this.values[2 * p + 1];
                    this.columnIndexes[nz++] = this.columnIndexes[p];
                }
                ++p;
            }
            ++j;
        }
        this.rowPointers[this.rows] = nz;
    }

    @Override
    public synchronized void setQuick(int row, int column, float[] value) {
        int k = SparseRCFComplexMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        if (k >= 0) {
            if (value[0] == 0.0f && value[1] == 0.0f) {
                this.remove(row, k);
            } else {
                this.values[2 * k] = value[0];
                this.values[2 * k + 1] = value[1];
            }
            return;
        }
        if (value[0] != 0.0f || value[1] != 0.0f) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    @Override
    public synchronized void setQuick(int row, int column, float re, float im) {
        int k = SparseRCFComplexMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        if (k >= 0) {
            if (re == 0.0f && im == 0.0f) {
                this.remove(row, k);
            } else {
                this.values[2 * k] = re;
                this.values[2 * k + 1] = im;
            }
            return;
        }
        if (re != 0.0f || im != 0.0f) {
            k = -k - 1;
            this.insert(row, column, k, re, im);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        int i = 0;
        while (i < this.rows) {
            int high = this.rowPointers[i + 1];
            int j = this.rowPointers[i];
            while (j < high) {
                if (this.values[2 * j + 1] > 0.0f) {
                    builder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('+').append(this.values[2 * j + 1]).append('i').append('\n');
                } else if (this.values[2 * j + 1] == 0.0f) {
                    builder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('\n');
                } else {
                    builder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[2 * j]).append('-').append(this.values[2 * j + 1]).append('i').append('\n');
                }
                ++j;
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.realloc(0);
    }

    @Override
    public FComplexMatrix1D zMult(FComplexMatrix1D y, FComplexMatrix1D z, final float[] alpha, final float[] beta, boolean transposeA) {
        boolean ignore;
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        boolean bl = ignore = z == null || !transposeA;
        if (z == null) {
            z = new DenseFComplexMatrix1D(rowsA);
        }
        if (!(y instanceof DenseFComplexMatrix1D) || !(z instanceof DenseFComplexMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        DenseFComplexMatrix1D zz = (DenseFComplexMatrix1D)z;
        final float[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)z.index(0);
        DenseFComplexMatrix1D yy = (DenseFComplexMatrix1D)y;
        final float[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)y.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (transposeA) {
            if (!(ignore || beta[0] == 1.0f && beta[1] == 0.0f)) {
                z.assign(FComplexFunctions.mult(beta));
            }
            if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = 2;
                Future[] futures = new Future[nthreads];
                final float[] result = new float[2 * rowsA];
                int k = this.rows / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    final int threadID = j;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] yElem = new float[2];
                            float[] val = new float[2];
                            if (threadID == 0) {
                                int i = firstRow;
                                while (i < lastRow) {
                                    int high = SparseRCFComplexMatrix2D.this.rowPointers[i + 1];
                                    yElem[0] = elementsY[zeroY + strideY * i];
                                    yElem[1] = elementsY[zeroY + strideY * i + 1];
                                    yElem = FComplex.mult(alpha, yElem);
                                    int k = SparseRCFComplexMatrix2D.this.rowPointers[i];
                                    while (k < high) {
                                        int j = SparseRCFComplexMatrix2D.this.columnIndexes[k];
                                        val[0] = SparseRCFComplexMatrix2D.this.values[2 * k];
                                        val[1] = -SparseRCFComplexMatrix2D.this.values[2 * k + 1];
                                        val = FComplex.mult(val, yElem);
                                        int n = zeroZ + strideZ * j;
                                        elementsZ[n] = elementsZ[n] + val[0];
                                        int n2 = zeroZ + strideZ * j + 1;
                                        elementsZ[n2] = elementsZ[n2] + val[1];
                                        ++k;
                                    }
                                    ++i;
                                }
                            } else {
                                int i = firstRow;
                                while (i < lastRow) {
                                    int high = SparseRCFComplexMatrix2D.this.rowPointers[i + 1];
                                    yElem[0] = elementsY[zeroY + strideY * i];
                                    yElem[1] = elementsY[zeroY + strideY * i + 1];
                                    yElem = FComplex.mult(alpha, yElem);
                                    int k = SparseRCFComplexMatrix2D.this.rowPointers[i];
                                    while (k < high) {
                                        int j = SparseRCFComplexMatrix2D.this.columnIndexes[k];
                                        val[0] = SparseRCFComplexMatrix2D.this.values[2 * k];
                                        val[1] = -SparseRCFComplexMatrix2D.this.values[2 * k + 1];
                                        val = FComplex.mult(val, yElem);
                                        int n = 2 * j;
                                        result[n] = result[n] + val[0];
                                        int n3 = 2 * j + 1;
                                        result[n3] = result[n3] + val[1];
                                        ++k;
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                j = 0;
                while (j < rowsA) {
                    int n = zeroZ + j * strideZ;
                    elementsZ[n] = elementsZ[n] + result[2 * j];
                    int n2 = zeroZ + j * strideZ + 1;
                    elementsZ[n2] = elementsZ[n2] + result[2 * j + 1];
                    ++j;
                }
            } else {
                float[] yElem = new float[2];
                float[] val = new float[2];
                int i = 0;
                while (i < this.rows) {
                    int high = this.rowPointers[i + 1];
                    yElem[0] = elementsY[zeroY + strideY * i];
                    yElem[1] = elementsY[zeroY + strideY * i + 1];
                    yElem = FComplex.mult(alpha, yElem);
                    int k = this.rowPointers[i];
                    while (k < high) {
                        int j = this.columnIndexes[k];
                        val[0] = this.values[2 * k];
                        val[1] = -this.values[2 * k + 1];
                        val = FComplex.mult(val, yElem);
                        int n = zeroZ + strideZ * j;
                        elementsZ[n] = elementsZ[n] + val[0];
                        int n3 = zeroZ + strideZ * j + 1;
                        elementsZ[n3] = elementsZ[n3] + val[1];
                        ++k;
                    }
                    ++i;
                }
            }
            return z;
        }
        if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int zidx = zeroZ + firstRow * strideZ;
                        float[] yElem = new float[2];
                        float[] val = new float[2];
                        if ((double)beta[0] == 0.0 && beta[1] == 0.0f) {
                            int i = firstRow;
                            while (i < lastRow) {
                                float[] sum = new float[2];
                                int high = SparseRCFComplexMatrix2D.this.rowPointers[i + 1];
                                int k = SparseRCFComplexMatrix2D.this.rowPointers[i];
                                while (k < high) {
                                    yElem[0] = elementsY[zeroY + strideY * SparseRCFComplexMatrix2D.this.columnIndexes[k]];
                                    yElem[1] = elementsY[zeroY + strideY * SparseRCFComplexMatrix2D.this.columnIndexes[k] + 1];
                                    val[0] = SparseRCFComplexMatrix2D.this.values[2 * k];
                                    val[1] = SparseRCFComplexMatrix2D.this.values[2 * k + 1];
                                    sum = FComplex.plus(sum, FComplex.mult(val, yElem));
                                    ++k;
                                }
                                sum = FComplex.mult(alpha, sum);
                                elementsZ[zidx] = sum[0];
                                elementsZ[zidx + 1] = sum[1];
                                zidx += strideZ;
                                ++i;
                            }
                        } else {
                            float[] zElem = new float[2];
                            int i = firstRow;
                            while (i < lastRow) {
                                float[] sum = new float[2];
                                int high = SparseRCFComplexMatrix2D.this.rowPointers[i + 1];
                                int k = SparseRCFComplexMatrix2D.this.rowPointers[i];
                                while (k < high) {
                                    yElem[0] = elementsY[zeroY + strideY * SparseRCFComplexMatrix2D.this.columnIndexes[k]];
                                    yElem[1] = elementsY[zeroY + strideY * SparseRCFComplexMatrix2D.this.columnIndexes[k] + 1];
                                    val[0] = SparseRCFComplexMatrix2D.this.values[2 * k];
                                    val[1] = SparseRCFComplexMatrix2D.this.values[2 * k + 1];
                                    sum = FComplex.plus(sum, FComplex.mult(val, yElem));
                                    ++k;
                                }
                                sum = FComplex.mult(alpha, sum);
                                zElem[0] = elementsZ[zidx];
                                zElem[1] = elementsZ[zidx + 1];
                                zElem = FComplex.mult(beta, zElem);
                                elementsZ[zidx] = sum[0] + zElem[0];
                                elementsZ[zidx + 1] = sum[1] + zElem[1];
                                zidx += strideZ;
                                ++i;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int zidx = zeroZ;
            float[] yElem = new float[2];
            float[] val = new float[2];
            if ((double)beta[0] == 0.0 && beta[1] == 0.0f) {
                int i = 0;
                while (i < this.rows) {
                    float[] sum = new float[2];
                    int high = this.rowPointers[i + 1];
                    int k = this.rowPointers[i];
                    while (k < high) {
                        yElem[0] = elementsY[zeroY + strideY * this.columnIndexes[k]];
                        yElem[1] = elementsY[zeroY + strideY * this.columnIndexes[k] + 1];
                        val[0] = this.values[2 * k];
                        val[1] = this.values[2 * k + 1];
                        sum = FComplex.plus(sum, FComplex.mult(val, yElem));
                        ++k;
                    }
                    sum = FComplex.mult(alpha, sum);
                    elementsZ[zidx] = sum[0];
                    elementsZ[zidx + 1] = sum[1];
                    zidx += strideZ;
                    ++i;
                }
            } else {
                float[] zElem = new float[2];
                int i = 0;
                while (i < this.rows) {
                    float[] sum = new float[2];
                    int high = this.rowPointers[i + 1];
                    int k = this.rowPointers[i];
                    while (k < high) {
                        yElem[0] = elementsY[zeroY + strideY * this.columnIndexes[k]];
                        yElem[1] = elementsY[zeroY + strideY * this.columnIndexes[k] + 1];
                        val[0] = this.values[2 * k];
                        val[1] = this.values[2 * k + 1];
                        sum = FComplex.plus(sum, FComplex.mult(val, yElem));
                        ++k;
                    }
                    sum = FComplex.mult(alpha, sum);
                    zElem[0] = elementsZ[zidx];
                    zElem[1] = elementsZ[zidx + 1];
                    zElem = FComplex.mult(beta, zElem);
                    elementsZ[zidx] = sum[0] + zElem[0];
                    elementsZ[zidx + 1] = sum[1] + zElem[1];
                    zidx += strideZ;
                    ++i;
                }
            }
        }
        return z;
    }

    @Override
    public FComplexMatrix2D zMult(FComplexMatrix2D B, FComplexMatrix2D C, float[] alpha, float[] beta, boolean transposeA, boolean transposeB) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int rowsB = B.rows();
        int columnsB = B.columns();
        if (transposeB) {
            rowsB = B.columns();
            columnsB = B.rows();
        }
        int p = columnsB;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = B instanceof SparseRCFComplexMatrix2D ? new SparseRCFComplexMatrix2D(rowsA, p, rowsA * p) : new DenseFComplexMatrix2D(rowsA, p);
        }
        if (rowsB != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!(ignore || (double)beta[0] == 1.0 && beta[1] == 0.0f)) {
            C.assign(FComplexFunctions.mult(beta));
        }
        if (B instanceof DenseFComplexMatrix2D && C instanceof DenseFComplexMatrix2D) {
            SparseRCFComplexMatrix2D AA = transposeA ? this.getConjugateTranspose() : this;
            DenseFComplexMatrix2D BB = transposeB ? (DenseFComplexMatrix2D)B.getConjugateTranspose() : (DenseFComplexMatrix2D)B;
            DenseFComplexMatrix2D CC = (DenseFComplexMatrix2D)C;
            int[] rowPointersA = AA.rowPointers;
            int[] columnIndexesA = AA.columnIndexes;
            float[] valuesA = AA.values;
            float[] valA = new float[2];
            int ii = 0;
            while (ii < rowsA) {
                int highA = rowPointersA[ii + 1];
                int ka = rowPointersA[ii];
                while (ka < highA) {
                    valA[0] = valuesA[2 * ka];
                    valA[1] = valuesA[2 * ka + 1];
                    float[] scal = FComplex.mult(alpha, valA);
                    int jj = columnIndexesA[ka];
                    CC.viewRow(ii).assign(BB.viewRow(jj), FComplexFunctions.plusMultSecond(scal));
                    ++ka;
                }
                ++ii;
            }
        } else if (B instanceof SparseRCFComplexMatrix2D && C instanceof SparseRCFComplexMatrix2D) {
            SparseRCFComplexMatrix2D CC = (SparseRCFComplexMatrix2D)C;
            SparseRCFComplexMatrix2D AA = transposeA ? this.getConjugateTranspose() : this;
            SparseRCFComplexMatrix2D BB = transposeB ? ((SparseRCFComplexMatrix2D)B).getConjugateTranspose() : (SparseRCFComplexMatrix2D)B;
            int[] rowPointersA = AA.rowPointers;
            int[] columnIndexesA = AA.columnIndexes;
            float[] valuesA = AA.values;
            int[] rowPointersB = BB.rowPointers;
            int[] columnIndexesB = BB.columnIndexes;
            float[] valuesB = BB.values;
            int[] rowPointersC = CC.rowPointers;
            int[] columnIndexesC = CC.columnIndexes;
            float[] valuesC = CC.values;
            int nzmax = columnIndexesC.length;
            int[] iw = new int[columnsB + 1];
            int i = 0;
            while (i < iw.length) {
                iw[i] = -1;
                ++i;
            }
            int len = -1;
            float[] valA = new float[2];
            float[] valB = new float[2];
            float[] valC = new float[2];
            int ii = 0;
            while (ii < rowsA) {
                int highA = rowPointersA[ii + 1];
                int ka = rowPointersA[ii];
                while (ka < highA) {
                    valA[0] = valuesA[2 * ka];
                    valA[1] = valuesA[2 * ka + 1];
                    float[] scal = FComplex.mult(alpha, valA);
                    int jj = columnIndexesA[ka];
                    int highB = rowPointersB[jj + 1];
                    int kb = rowPointersB[jj];
                    while (kb < highB) {
                        int jcol = columnIndexesB[kb];
                        int jpos = iw[jcol];
                        if (jpos == -1) {
                            if (++len >= nzmax) {
                                throw new IllegalArgumentException("The max number of nonzero elements in C is too small.");
                            }
                            columnIndexesC[len] = jcol;
                            iw[jcol] = len;
                            valB[0] = valuesB[2 * kb];
                            valB[1] = valuesB[2 * kb + 1];
                            valB = FComplex.mult(scal, valB);
                            valuesC[2 * len] = valB[0];
                            valuesC[2 * len + 1] = valB[1];
                        } else {
                            valB[0] = valuesB[2 * kb];
                            valB[1] = valuesB[2 * kb + 1];
                            valB = FComplex.mult(scal, valB);
                            int n = 2 * jpos;
                            valuesC[n] = valuesC[n] + valB[0];
                            int n2 = 2 * jpos + 1;
                            valuesC[n2] = valuesC[n2] + valB[1];
                        }
                        ++kb;
                    }
                    ++ka;
                }
                int k = rowPointersC[ii];
                while (k < len + 1) {
                    iw[columnIndexesC[k]] = -1;
                    ++k;
                }
                rowPointersC[ii + 1] = len + 1;
                ++ii;
            }
        } else {
            if (transposeB) {
                B = B.getConjugateTranspose();
            }
            FComplexMatrix1D[] Brows = new FComplexMatrix1D[columnsA];
            int i = columnsA;
            while (--i >= 0) {
                Brows[i] = B.viewRow(i);
            }
            FComplexMatrix1D[] Crows = new FComplexMatrix1D[rowsA];
            int i2 = rowsA;
            while (--i2 >= 0) {
                Crows[i2] = C.viewRow(i2);
            }
            FComplexPlusMultSecond fun = FComplexPlusMultSecond.plusMult(new float[2]);
            int[] columnIndexesA = this.columnIndexes;
            float[] valuesA = this.values;
            float[] valA = new float[2];
            int i3 = this.rows;
            while (--i3 >= 0) {
                int low = this.rowPointers[i3];
                int k = this.rowPointers[i3 + 1];
                while (--k >= low) {
                    int j = columnIndexesA[k];
                    valA[0] = valuesA[2 * k];
                    valA[1] = valuesA[2 * k + 1];
                    fun.multiplicator = FComplex.mult(valA, alpha);
                    if (!transposeA) {
                        Crows[i3].assign(Brows[j], fun);
                        continue;
                    }
                    Crows[j].assign(Brows[i3], fun);
                }
            }
        }
        return C;
    }

    private float cumsum(int[] p, int[] c, int n) {
        int nz = 0;
        float nz2 = 0.0f;
        int k = 0;
        while (k < n) {
            p[k] = nz;
            nz += c[k];
            nz2 += (float)c[k];
            c[k] = p[k];
            ++k;
        }
        p[n] = nz;
        return nz2;
    }

    private void realloc(int nzmax) {
        if (nzmax <= 0) {
            nzmax = this.rowPointers[this.rows];
        }
        int[] columnIndexesNew = new int[nzmax];
        int length = Math.min(nzmax, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, columnIndexesNew, 0, length);
        this.columnIndexes = columnIndexesNew;
        float[] valuesNew = new float[2 * nzmax];
        length = Math.min(nzmax, this.values.length);
        System.arraycopy(this.values, 0, valuesNew, 0, length);
        this.values = valuesNew;
    }

    @Override
    protected FComplexMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, float[] value) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        FloatArrayList valuesList = new FloatArrayList(this.values);
        valuesList.setSizeRaw(2 * this.rowPointers[this.rows]);
        columnIndexesList.beforeInsert(index, column);
        valuesList.beforeInsert(2 * index, value[0]);
        valuesList.beforeInsert(2 * index + 1, value[1]);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] + 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void insert(int row, int column, int index, float re, float im) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        FloatArrayList valuesList = new FloatArrayList(this.values);
        valuesList.setSizeRaw(2 * this.rowPointers[this.rows]);
        columnIndexesList.beforeInsert(index, column);
        valuesList.beforeInsert(2 * index, re);
        valuesList.beforeInsert(2 * index + 1, im);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] + 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void remove(int row, int index) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        FloatArrayList valuesList = new FloatArrayList(this.values);
        valuesList.setSizeRaw(this.rowPointers[this.rows]);
        columnIndexesList.remove(index);
        valuesList.remove(2 * index);
        valuesList.remove(2 * index + 1);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] - 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }
}

