/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv.deconv;

import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mitiv.array.ShapedArray;
import mitiv.deconv.Deconvolution;
import mitiv.utils.CommonUtils;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.mitiv.deconv.ThreadCG;
import plugins.mitiv.io.IcyBufferedImageUtils;

public class MitivWiener
extends EzPlug
implements EzStoppable,
SequenceListener,
Block,
EzVarListener<String> {
    JSlider slider;
    String wiener = "Wiener";
    String quad = "Quadratic";
    String cg = "CG";
    EzVarText options = new EzVarText("Regularization", new String[]{this.wiener, this.quad, this.cg}, 0, Boolean.valueOf(false));
    EzVarBoolean varBoolean = new EzVarBoolean("Is PSF splitted ?", false);
    EzVarSequence sequencePSF = new EzVarSequence("PSF");
    EzVarSequence sequenceImage = new EzVarSequence("Image");
    EzVarDouble eZcoef = new EzVarDouble("Padding multiplication", 1.0, 10.0, 0.1);
    Sequence myseq;
    JLabel label;
    int job;
    int correct;
    Deconvolution deconvolution;
    ThreadCG thread;
    private EzVarSequence output = new EzVarSequence("Output");
    private EzVarInteger valueBlock = new EzVarInteger("Value");
    private static final double muMin = 1.0E-12;
    private static final double muMax = 10.0;
    private static final double muAlpha = Math.log(1.0E-12);
    private static final double muBeta = Math.log(1.0E13) / 100.0;

    private void updateLabel(double val) {
        DecimalFormat df = new DecimalFormat("#.####");
        this.label.setText("Actual Value : " + df.format(val));
    }

    public void updateProgressBarMessage(String msg) {
        if (!this.isHeadLess()) {
            this.getUI().setProgressBarMessage(msg);
        }
    }

    public static double sliderToRegularizationWeight(int slidervalue) {
        return Math.exp(muAlpha + muBeta * (double)slidervalue);
    }

    private int chooseJob() {
        if (((String)this.options.getValue()).equals(this.wiener)) {
            return 0;
        }
        if (((String)this.options.getValue()).equals(this.quad)) {
            return 1;
        }
        if (((String)this.options.getValue()).equals(this.cg)) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid Job");
    }

    private IcyBufferedImage firstJob(int job) {
        ShapedArray tmp;
        this.thread = new ThreadCG(this);
        this.thread.start();
        boolean isSplitted = (Boolean)this.varBoolean.getValue();
        switch (job) {
            case 0: {
                tmp = this.deconvolution.firstDeconvolution(1.0E-12, isSplitted);
                break;
            }
            case 1: {
                tmp = this.deconvolution.firstDeconvolutionQuad(1.0E-12, isSplitted);
                break;
            }
            case 2: {
                tmp = this.deconvolution.firstDeconvolutionCG(1.0E-12, isSplitted);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Job");
            }
        }
        return IcyBufferedImageUtils.arrayToImage(tmp).get(0);
    }

    public IcyBufferedImage nextJob(int slidervalue, int job) {
        ShapedArray tmp;
        double mu = MitivWiener.sliderToRegularizationWeight(slidervalue);
        if (!this.isHeadLess()) {
            this.updateLabel(mu);
        }
        double mult = 1.0E9;
        switch (job) {
            case 0: {
                tmp = this.deconvolution.nextDeconvolution(mu);
                break;
            }
            case 1: {
                tmp = this.deconvolution.nextDeconvolutionQuad(mu * mult);
                break;
            }
            case 2: {
                tmp = this.deconvolution.nextDeconvolutionCG(mu * mult);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Job");
            }
        }
        return IcyBufferedImageUtils.arrayToImage(tmp).get(0);
    }

    private void firstJob3D(int job) {
        ShapedArray tmp;
        this.thread = new ThreadCG(this);
        this.thread.compute3D();
        this.thread.start();
        boolean isSplitted = false;
        switch (job) {
            case 0: {
                tmp = this.deconvolution.firstDeconvolution(1.0E-12, 3, isSplitted);
                break;
            }
            case 1: {
                tmp = this.deconvolution.firstDeconvolutionQuad(1.0E-12, 3, isSplitted);
                break;
            }
            case 2: {
                tmp = this.deconvolution.firstDeconvolutionCG(1.0E-12, 3, isSplitted);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Job");
            }
        }
        ArrayList<IcyBufferedImage> list = IcyBufferedImageUtils.arrayToImage(tmp);
        int i = 0;
        while (i < list.size()) {
            this.myseq.setImage(0, i, (BufferedImage)list.get(i));
            ++i;
        }
    }

    public void nextJob3D(int slidervalue, int job) {
        ShapedArray tmp;
        double mu = MitivWiener.sliderToRegularizationWeight(slidervalue);
        if (!this.isHeadLess()) {
            this.updateLabel(mu);
        }
        double mult = 1.0E10;
        switch (job) {
            case 0: {
                tmp = this.deconvolution.nextDeconvolution(mu, 3);
                break;
            }
            case 1: {
                tmp = this.deconvolution.nextDeconvolutionQuad(mu * mult, 3);
                break;
            }
            case 2: {
                tmp = this.deconvolution.nextDeconvolutionCG(mu * mult, 3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Job");
            }
        }
        ArrayList<IcyBufferedImage> list = IcyBufferedImageUtils.arrayToImage(tmp);
        int i = 0;
        while (i < list.size()) {
            this.myseq.setImage(0, i, (BufferedImage)list.get(i));
            ++i;
        }
    }

    protected void initialize() {
        this.slider = new JSlider(0, 100, 0);
        this.slider.setEnabled(false);
        this.label = new JLabel("                     ");
        this.sequencePSF.setToolTipText("The PSF associated to the image given");
        this.sequenceImage.setToolTipText("The image on which we will work");
        this.options.setToolTipText("Choose the algorithm used to deconvoluate the image");
        this.eZcoef.setToolTipText("Add X zero lines around the image");
        this.slider.setToolTipText("Update Mu value");
        this.varBoolean.setToolTipText("<html><pre>Is the PSF:<br/> ---------      ---------     <br/> |       |      |*     *|     <br/> |   *   |  OR  |       |     <br/> |       |      |*     *|     <br/> ---------      ---------     <br/></pre></html>");
        this.addEzComponent((EzComponent)this.sequenceImage);
        this.addEzComponent((EzComponent)this.sequencePSF);
        this.addEzComponent((EzComponent)this.varBoolean);
        this.addEzComponent((EzComponent)this.options);
        this.options.addVarChangeListener((EzVarListener)this);
        this.addEzComponent((EzComponent)this.eZcoef);
        this.addComponent(this.slider);
        this.addComponent(this.label);
    }

    public void updateImage(BufferedImage buffered, int value) {
        if (this.isHeadLess()) {
            this.myseq.setImage(0, 0, buffered);
            this.output.setValue(this.myseq);
        } else {
            this.myseq.setName(String.valueOf((String)this.options.getValue()) + " " + value);
            this.myseq.setImage(0, 0, buffered);
        }
    }

    protected void execute() {
        this.correct = CommonUtils.SCALE;
        this.job = this.chooseJob();
        if (this.myseq != null) {
            this.myseq.close();
        }
        if (this.sequenceImage.getValue() == null || this.sequencePSF.getValue() == null) {
            String message = "You have forgotten to give ";
            String messageEnd = "";
            if (this.sequenceImage.getValue() == null) {
                messageEnd = messageEnd.concat("the image ");
            }
            if (this.sequencePSF.getValue() == null) {
                if (this.sequenceImage.getValue() == null) {
                    messageEnd = messageEnd.concat("and ");
                }
                messageEnd = messageEnd.concat("a PSF");
            }
            new AnnounceFrame(String.valueOf(message) + messageEnd);
        } else {
            try {
                Sequence seqIm = (Sequence)this.sequenceImage.getValue();
                Sequence seqPsf = (Sequence)this.sequencePSF.getValue();
                this.myseq = new Sequence();
                this.myseq.addListener((SequenceListener)this);
                this.myseq.setName("");
                if (seqIm.getSizeZ() == 1 && seqPsf.getSizeZ() == 1) {
                    this.deconvolution = new Deconvolution(seqIm.getFirstNonNullImage(), seqPsf.getFirstNonNullImage(), this.correct);
                    this.deconvolution.setPaddingCoefficient((Double)this.eZcoef.getValue());
                    this.myseq.addImage(0, (BufferedImage)this.firstJob(this.job));
                } else if (seqIm.getSizeZ() == seqPsf.getSizeZ()) {
                    ShapedArray imgShapped = IcyBufferedImageUtils.imageToArray(seqIm.getAllImage());
                    ShapedArray psfShapped = IcyBufferedImageUtils.imageToArray(seqPsf.getAllImage());
                    this.deconvolution = new Deconvolution(imgShapped, psfShapped, this.correct);
                    this.deconvolution.setPaddingCoefficient((Double)this.eZcoef.getValue());
                    this.firstJob3D(this.job);
                } else {
                    new AnnounceFrame("The PSF and the image should be of same dimensions");
                    return;
                }
                if (this.isHeadLess()) {
                    double value = ((Integer)this.valueBlock.getValue()).intValue();
                    this.updateImage((BufferedImage)this.nextJob((int)value, this.job), (int)value);
                } else {
                    this.addSequence(this.myseq);
                    this.slider.setEnabled(true);
                    this.slider.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent event) {
                            int sliderValue = ((JSlider)event.getSource()).getValue();
                            MitivWiener.this.updateProgressBarMessage("Computing");
                            MitivWiener.this.thread.prepareNextJob(sliderValue, MitivWiener.this.job);
                        }
                    });
                    this.slider.setValue(0);
                }
            }
            catch (Exception e) {
                new AnnounceFrame("Oops, Error: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void clean() {
        if (this.myseq != null) {
            this.myseq.close();
        }
        if (this.thread != null) {
            this.thread.cancel();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                System.err.println("Erreur fin Thread " + e);
            }
        }
    }

    public void stopExecution() {
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
    }

    public void sequenceClosed(Sequence sequence) {
        if (!this.isHeadLess()) {
            this.slider.setEnabled(false);
        }
    }

    public int getOutputValue() {
        return this.deconvolution.getOuputValue();
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("psf", (Var)this.sequencePSF.getVariable());
        inputMap.add("image", (Var)this.sequenceImage.getVariable());
        inputMap.add("options", this.options.getVariable());
        inputMap.add("value", this.valueBlock.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("output", (Var)this.output.getVariable());
    }

    public void variableChanged(EzVar<String> source, String newValue) {
        if (newValue == this.cg) {
            this.eZcoef.setVisible(true);
        } else {
            this.eZcoef.setValue((Object)1.0);
            this.eZcoef.setVisible(false);
        }
    }
}

