/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.SingularOperatorException;
import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class ScaleOperator
extends LinearEndomorphism {
    protected double scale = 1.0;

    public ScaleOperator(VectorSpace vsp) {
        super(vsp);
    }

    public ScaleOperator(VectorSpace vsp, double alpha) {
        super(vsp);
        this.scale = alpha;
    }

    @Override
    protected void _apply(Vector vec, int job) {
        if (job == DIRECT || job == ADJOINT) {
            this.space._scale(vec, this.scale);
        } else if (this.scale != 0.0) {
            this.space._scale(vec, 1.0 / this.scale);
        } else {
            throw new SingularOperatorException();
        }
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) {
        if (job == DIRECT || job == ADJOINT) {
            this.space._scale(dst, this.scale, src);
        } else if (this.scale != 0.0) {
            this.space._scale(dst, 1.0 / this.scale, src);
        } else {
            throw new SingularOperatorException();
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double alpha) {
        this.scale = alpha;
    }
}

