package plugins.tprovoost.sequenceblocks.infos;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.sequence.MetaDataUtil;
import loci.formats.ome.OMEXMLMetadataImpl;
import plugins.adufour.blocks.tools.sequence.SequenceBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

/**
 * @deprecated Use {@link GetMetaData} block instead.
 */
@Deprecated
public class ReadMetadata extends Plugin implements SequenceBlock, PluginLibrary, PluginBundled
{
    Var<OMEXMLMetadataImpl> metadata = new Var<OMEXMLMetadataImpl>("Metadata", OMEXMLMetadataImpl.class);
    VarInteger serie = new VarInteger("Serie", 0);

    VarString name = new VarString("Name", "");
    VarInteger sizeX = new VarInteger("Size X", 1);
    VarInteger sizeY = new VarInteger("Size Y", 1);
    VarInteger sizeC = new VarInteger("Size C", 1);
    VarInteger sizeZ = new VarInteger("Size Z", 1);
    VarInteger sizeT = new VarInteger("Size T", 1);
    VarDouble pxSizeX = new VarDouble("Pixel Size X (m)", 1d);
    VarDouble pxSizeY = new VarDouble("Pixel Size Y (m)", 1d);
    VarDouble pxSizeZ = new VarDouble("Pixel Size Z (m)", 1d);
    VarDouble timeIntT = new VarDouble("Time interval T (s)", 100d);

    @Override
    public void run()
    {
        final OMEXMLMetadataImpl meta = metadata.getValue();
        if (meta == null)
            throw new VarException(metadata, "Metadata is null !");

        final int s = serie.getValue().intValue();
        if (s >= MetaDataUtil.getNumSerie(meta))
            throw new VarException(serie, "Serie index must be between 0 and " + (MetaDataUtil.getNumSerie(meta) - 1));

        name.setValue(MetaDataUtil.getName(meta, s));
        sizeX.setValue(Integer.valueOf(MetaDataUtil.getSizeX(meta, s)));
        sizeY.setValue(Integer.valueOf(MetaDataUtil.getSizeY(meta, s)));
        sizeZ.setValue(Integer.valueOf(MetaDataUtil.getSizeZ(meta, s)));
        sizeT.setValue(Integer.valueOf(MetaDataUtil.getSizeT(meta, s)));
        sizeC.setValue(Integer.valueOf(MetaDataUtil.getSizeC(meta, s)));
        pxSizeX.setValue(Double.valueOf(MetaDataUtil.getPixelSizeX(meta, s, pxSizeX.getDefaultValue().doubleValue())));
        pxSizeY.setValue(Double.valueOf(MetaDataUtil.getPixelSizeY(meta, s, pxSizeY.getDefaultValue().doubleValue())));
        pxSizeZ.setValue(Double.valueOf(MetaDataUtil.getPixelSizeZ(meta, s, pxSizeZ.getDefaultValue().doubleValue())));
        timeIntT.setValue(Double.valueOf(MetaDataUtil.getTimeInterval(meta, s, timeIntT.getDefaultValue().doubleValue())));
    }

    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("Metadata", metadata);
        inputMap.add("Serie", serie);
    }

    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("Name", name);
        outputMap.add("Size X", sizeX);
        outputMap.add("Size Y", sizeY);
        outputMap.add("Size C", sizeC);
        outputMap.add("Size Z", sizeZ);
        outputMap.add("Size T", sizeT);
        outputMap.add("Pixel Size X (mm)", pxSizeX);
        outputMap.add("Pixel Size Y (mm)", pxSizeY);
        outputMap.add("Pixel Size Z (mm)", pxSizeZ);
        outputMap.add("Time interval T (ms)", timeIntT);
    }

    @Override
    public String getMainPluginClassName()
    {
        return SequenceBlocks.class.getName();
    }
}