/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.IJ;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mcib3d.image3d.ImageFloat;

public class EdtFloat {
    public ImageFloat run(ImageFloat imageFloat, float f, float f2, float f3, int n) throws Exception {
        int n2;
        int n3;
        int n4;
        FloatProcessor floatProcessor;
        int n5 = imageFloat.sizeX;
        int n6 = imageFloat.sizeY;
        int n7 = imageFloat.sizeZ;
        float f4 = f3 / f2;
        float[][] fArray = imageFloat.pixels;
        int n8 = n;
        ImageStack imageStack = new ImageStack(n5, n6);
        float[][] fArrayArray = new float[n7][];
        for (int i = 0; i < n7; ++i) {
            floatProcessor = new FloatProcessor(n5, n6);
            imageStack.addSlice(null, (ImageProcessor)floatProcessor);
            fArrayArray[i] = (float[])floatProcessor.getPixels();
        }
        floatProcessor = new Step1Thread[n8];
        for (n4 = 0; n4 < n8; ++n4) {
            floatProcessor[n4] = new Step1Thread(n4, n8, n5, n6, n7, f, fArrayArray, fArray, f4);
            floatProcessor[n4].start();
        }
        try {
            for (n4 = 0; n4 < n8; ++n4) {
                floatProcessor[n4].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 1 .");
        }
        Step2Thread[] step2ThreadArray = new Step2Thread[n8];
        for (n3 = 0; n3 < n8; ++n3) {
            step2ThreadArray[n3] = new Step2Thread(n3, n8, n5, n6, n7, fArrayArray);
            step2ThreadArray[n3].start();
        }
        try {
            for (n3 = 0; n3 < n8; ++n3) {
                step2ThreadArray[n3].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 2 .");
        }
        Step3Thread[] step3ThreadArray = new Step3Thread[n8];
        for (n2 = 0; n2 < n8; ++n2) {
            step3ThreadArray[n2] = new Step3Thread(n2, n8, n5, n6, n7, fArrayArray, fArray, f, f4);
            step3ThreadArray[n2].start();
        }
        try {
            for (n2 = 0; n2 < n8; ++n2) {
                step3ThreadArray[n2].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 3 .");
        }
        float f5 = 0.0f;
        int n9 = n5 * n6;
        for (int i = 0; i < n7; ++i) {
            float[] fArray2 = fArrayArray[i];
            for (int j = 0; j < n9; ++j) {
                float f6;
                if (fArray[i][j] <= f) {
                    fArray2[j] = 0.0f;
                    continue;
                }
                fArray2[j] = f6 = (float)Math.sqrt(fArray2[j]) * f2;
                f5 = f6 > f5 ? f6 : f5;
            }
        }
        ImageFloat imageFloat2 = (ImageFloat)ImageFloat.wrap(imageStack);
        imageFloat2.setScale(imageFloat);
        imageFloat2.setOffset(imageFloat);
        imageFloat2.setMinAndMax(0.0f, f5);
        return imageFloat2;
    }

    String stripExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    class Step3Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float thresh;
        float[][] s;
        float[][] data;
        float scaleZ;

        public Step3Thread(int n, int n2, int n3, int n4, int n5, float[][] fArray, float[][] fArray2, float f, float f2) {
            this.thresh = f;
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.s = fArray;
            this.data = fArray2;
            this.scaleZ = f2 * f2;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            for (int i = this.thread; i < this.h; i += this.nThreads) {
                for (int j = 0; j < this.w; ++j) {
                    int n3;
                    int n4;
                    int n5;
                    boolean bl = false;
                    for (n5 = 0; n5 < this.d; ++n5) {
                        fArray2[n5] = this.s[n5][j + this.w * i];
                        if (!(fArray2[n5] > 0.0f)) continue;
                        bl = true;
                    }
                    if (!bl) continue;
                    for (n4 = 0; n4 < this.d - 1 && fArray2[n4] == 0.0f; ++n4) {
                    }
                    if (n4 > 0) {
                        --n4;
                    }
                    for (n3 = this.d - 1; n3 > 0 && fArray2[n3] == 0.0f; --n3) {
                    }
                    if (n3 < this.d - 1) {
                        ++n3;
                    }
                    for (n5 = 0; n5 < this.d; ++n5) {
                        if (!(this.data[n5][j + this.w * i] > this.thresh)) continue;
                        float f = n2;
                        int n6 = n4;
                        int n7 = n3;
                        if (n6 > n5) {
                            n6 = n5;
                        }
                        if (n7 < n5) {
                            n7 = n5;
                        }
                        int n8 = n5 - n6;
                        for (int k = n6; k <= n7; ++k) {
                            int n9 = n8;
                            int n10 = n8--;
                            float f2 = fArray2[k] + (float)(n9 * n10) * this.scaleZ;
                            if (!(f2 < f)) continue;
                            f = f2;
                        }
                        fArray[n5] = f;
                    }
                    for (n5 = 0; n5 < this.d; ++n5) {
                        this.s[n5][j + this.w * i] = fArray[n5];
                    }
                }
            }
        }
    }

    class Step2Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;

        public Step2Thread(int n, int n2, int n3, int n4, int n5, float[][] fArray) {
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.s = fArray;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            for (int i = this.thread; i < this.d; i += this.nThreads) {
                float[] fArray3 = this.s[i];
                for (int j = 0; j < this.w; ++j) {
                    int n3;
                    boolean bl = false;
                    for (n3 = 0; n3 < this.h; ++n3) {
                        fArray2[n3] = fArray3[j + this.w * n3];
                        if (!(fArray2[n3] > 0.0f)) continue;
                        bl = true;
                    }
                    if (!bl) continue;
                    for (n3 = 0; n3 < this.h; ++n3) {
                        float f = n2;
                        int n4 = n3;
                        for (int k = 0; k < this.h; ++k) {
                            int n5 = n4;
                            int n6 = n4--;
                            float f2 = fArray2[k] + (float)(n5 * n6);
                            if (!(f2 < f)) continue;
                            f = f2;
                        }
                        fArray[n3] = f;
                    }
                    for (n3 = 0; n3 < this.h; ++n3) {
                        fArray3[j + this.w * n3] = fArray[n3];
                    }
                }
            }
        }
    }

    class Step1Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float thresh;
        float[][] s;
        float[][] data;
        float scaleZ;

        public Step1Thread(int n, int n2, int n3, int n4, int n5, float f, float[][] fArray, float[][] fArray2, float f2) {
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.thresh = f;
            this.data = fArray2;
            this.s = fArray;
            this.scaleZ = f2 * f2;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            boolean[] blArray = new boolean[n];
            for (int i = this.thread; i < this.d; i += this.nThreads) {
                float[] fArray = this.s[i];
                float[] fArray2 = this.data[i];
                boolean bl = i == 0 || i == this.d - 1;
                for (int j = 0; j < this.h; ++j) {
                    int n3;
                    for (n3 = 0; n3 < this.w; ++n3) {
                        blArray[n3] = fArray2[n3 + this.w * j] <= this.thresh;
                    }
                    n3 = j == 0 || j == this.h - 1 ? 1 : 0;
                    for (int k = 0; k < this.w; ++k) {
                        float f = n2;
                        if (n3 != 0 || k == 0 || k == this.w - 1) {
                            f = 1.0f;
                        } else {
                            float f2;
                            int n4;
                            if (bl) {
                                f = this.scaleZ;
                            }
                            for (n4 = k; n4 < this.w; ++n4) {
                                if (!blArray[n4]) continue;
                                f2 = k - n4;
                                if (!((f2 *= f2) < f)) break;
                                f = f2;
                                break;
                            }
                            for (n4 = k - 1; n4 >= 0; --n4) {
                                if (!blArray[n4]) continue;
                                f2 = k - n4;
                                if (!((f2 *= f2) < f)) break;
                                f = f2;
                                break;
                            }
                        }
                        fArray[k + this.w * j] = f;
                    }
                }
            }
        }
    }
}

