/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.IJ;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageShort;

public class EdtShortLabel {
    public ImageFloat run(ImageShort imageShort, float f, float f2, int n) throws Exception {
        int n2;
        int n3;
        int n4;
        int n5 = imageShort.sizeX;
        int n6 = imageShort.sizeY;
        int n7 = imageShort.sizeZ;
        float f3 = f2 / f;
        short[][] sArray = imageShort.pixels;
        int n8 = Math.max(n, 1);
        ImageFloat imageFloat = new ImageFloat("EDT Label", n5, n6, n7);
        imageFloat.setScale(imageShort);
        float[][] fArray = imageFloat.pixels;
        Step1Thread[] step1ThreadArray = new Step1Thread[n8];
        for (n4 = 0; n4 < n8; ++n4) {
            step1ThreadArray[n4] = new Step1Thread(n4, n8, n5, n6, n7, fArray, sArray, f3);
            step1ThreadArray[n4].start();
        }
        try {
            for (n4 = 0; n4 < n8; ++n4) {
                step1ThreadArray[n4].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 1 .");
        }
        Step2Thread[] step2ThreadArray = new Step2Thread[n8];
        for (n3 = 0; n3 < n8; ++n3) {
            step2ThreadArray[n3] = new Step2Thread(n3, n8, n5, n6, n7, fArray, sArray);
            step2ThreadArray[n3].start();
        }
        try {
            for (n3 = 0; n3 < n8; ++n3) {
                step2ThreadArray[n3].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 2 .");
        }
        Step3Thread[] step3ThreadArray = new Step3Thread[n8];
        for (n2 = 0; n2 < n8; ++n2) {
            step3ThreadArray[n2] = new Step3Thread(n2, n8, n5, n6, n7, fArray, sArray, f3);
            step3ThreadArray[n2].start();
        }
        try {
            for (n2 = 0; n2 < n8; ++n2) {
                step3ThreadArray[n2].join();
            }
        }
        catch (InterruptedException interruptedException) {
            IJ.error((String)"A thread was interrupted in step 3 .");
        }
        float f4 = 0.0f;
        int n9 = n5 * n6;
        for (int i = 0; i < n7; ++i) {
            float[] fArray2 = fArray[i];
            for (int j = 0; j < n9; ++j) {
                float f5;
                if (sArray[i][j] == 0) {
                    fArray2[j] = 0.0f;
                    continue;
                }
                fArray2[j] = f5 = (float)Math.sqrt(fArray2[j]) * f;
                f4 = f5 > f4 ? f5 : f4;
            }
        }
        return imageFloat;
    }

    String stripExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    class Step3Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;
        short[][] data;
        float scaleZ;

        public Step3Thread(int n, int n2, int n3, int n4, int n5, float[][] fArray, short[][] sArray, float f) {
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.s = fArray;
            this.data = sArray;
            this.scaleZ = f * f;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            for (int i = this.thread; i < this.h; i += this.nThreads) {
                for (int j = 0; j < this.w; ++j) {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    boolean bl = false;
                    for (n6 = 0; n6 < this.d; ++n6) {
                        fArray2[n6] = this.s[n6][j + this.w * i];
                        if (!(fArray2[n6] > 0.0f)) continue;
                        bl = true;
                    }
                    if (!bl) continue;
                    for (n5 = 0; n5 < this.d - 1 && fArray2[n5] == 0.0f; ++n5) {
                    }
                    if (n5 > 0) {
                        --n5;
                    }
                    for (n4 = this.d - 1; n4 > 0 && fArray2[n4] == 0.0f; --n4) {
                    }
                    if (n4 < this.d - 1) {
                        ++n4;
                    }
                    n6 = i * this.w + j;
                    for (n3 = 0; n3 < this.d; ++n3) {
                        if (this.data[n3][j + this.w * i] == 0) continue;
                        float f = n2;
                        int n7 = n5;
                        int n8 = n4;
                        if (n7 > n3) {
                            n7 = n3;
                        }
                        if (n8 < n3) {
                            n8 = n3;
                        }
                        int n9 = n3 - n7;
                        for (int k = n7; k <= n8; ++k) {
                            float f2;
                            if (this.data[n3][n6] == this.data[k][n6]) {
                                int n10 = n9;
                                int n11 = n9--;
                                f2 = fArray2[k] + (float)(n10 * n11) * this.scaleZ;
                                if (!(f2 < f)) continue;
                                f = f2;
                                continue;
                            }
                            int n12 = n9;
                            int n13 = n9--;
                            f2 = (float)(n12 * n13) * this.scaleZ;
                            if (!(f2 < f)) continue;
                            f = f2;
                        }
                        fArray[n3] = f;
                    }
                    for (n3 = 0; n3 < this.d; ++n3) {
                        this.s[n3][j + this.w * i] = fArray[n3];
                    }
                }
            }
        }
    }

    class Step2Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;
        short[][] data;

        public Step2Thread(int n, int n2, int n3, int n4, int n5, float[][] fArray, short[][] sArray) {
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.s = fArray;
            this.data = sArray;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            float[] fArray = new float[n];
            float[] fArray2 = new float[n];
            for (int i = this.thread; i < this.d; i += this.nThreads) {
                float[] fArray3 = this.s[i];
                short[] sArray = this.data[i];
                for (int j = 0; j < this.w; ++j) {
                    int n3;
                    boolean bl = false;
                    for (n3 = 0; n3 < this.h; ++n3) {
                        fArray2[n3] = fArray3[j + this.w * n3];
                        if (!(fArray2[n3] > 0.0f)) continue;
                        bl = true;
                    }
                    if (!bl) continue;
                    for (n3 = 0; n3 < this.h; ++n3) {
                        float f = n2;
                        float f2 = n3;
                        for (int k = 0; k < this.h; ++k) {
                            float f3;
                            if (sArray[j + this.w * n3] == sArray[j + this.w * k]) {
                                float f4 = f2;
                                float f5 = f2;
                                f2 = f5 - 1.0f;
                                f3 = fArray2[k] + f4 * f5;
                                if (!(f3 < f)) continue;
                                f = f3;
                                continue;
                            }
                            float f6 = f2;
                            float f7 = f2;
                            f2 = f7 - 1.0f;
                            f3 = f6 * f7;
                            if (!(f3 < f)) continue;
                            f = f3;
                        }
                        fArray[n3] = f;
                    }
                    for (n3 = 0; n3 < this.h; ++n3) {
                        fArray3[j + this.w * n3] = fArray[n3];
                    }
                }
            }
        }
    }

    class Step1Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;
        short[][] data;
        float scaleZ;

        public Step1Thread(int n, int n2, int n3, int n4, int n5, float[][] fArray, short[][] sArray, float f) {
            this.thread = n;
            this.nThreads = n2;
            this.w = n3;
            this.h = n4;
            this.d = n5;
            this.data = sArray;
            this.s = fArray;
            this.scaleZ = f * f;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int n2 = 3 * (n + 1) * (n + 1);
            for (int i = this.thread; i < this.d; i += this.nThreads) {
                float[] fArray = this.s[i];
                short[] sArray = this.data[i];
                boolean bl = i == 0 || i == this.d - 1;
                for (int j = 0; j < this.h; ++j) {
                    int n3 = j * this.w;
                    boolean bl2 = j == 0 || j == this.h - 1;
                    for (int k = 0; k < this.w; ++k) {
                        float f = n2;
                        if (bl2 || k == 0 || k == this.w - 1) {
                            f = 1.0f;
                        } else {
                            float f2;
                            int n4;
                            if (bl) {
                                f = this.scaleZ;
                            }
                            for (n4 = k; n4 < this.w; ++n4) {
                                if (sArray[n4 + n3] == sArray[k + n3]) continue;
                                f2 = k - n4;
                                if (!((f2 *= f2) < f)) break;
                                f = f2;
                                break;
                            }
                            for (n4 = k - 1; n4 >= 0; --n4) {
                                if (sArray[n4 + n3] == sArray[k + n3]) continue;
                                f2 = k - n4;
                                if (!((f2 *= f2) < f)) break;
                                f = f2;
                                break;
                            }
                        }
                        fArray[k + this.w * j] = f;
                    }
                }
            }
        }
    }
}

