/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.exception.IllegalLinearOperationException;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.InverseHessianApproximation;

public class LBFGSOperator
extends LinearOperator {
    protected Vector[] s;
    protected Vector[] y;
    protected final int m;
    protected int mp;
    protected int mark;
    protected double[] rho;
    protected double gamma;
    protected double[] beta;
    protected LinearOperator H0;
    protected InverseHessianApproximation rule;
    private Vector tmp;

    public LBFGSOperator(VectorSpace space, int m) {
        super(space);
        this.m = m;
        this.H0 = null;
        this.rule = InverseHessianApproximation.BY_STY_OVER_YTY;
        this.allocateWorkspace();
    }

    public LBFGSOperator(LinearOperator H0, int m) {
        super(H0.getInputSpace());
        if (!H0.isEndomorphism()) {
            throw new IncorrectSpaceException("Preconditioner must be an endomorphism");
        }
        this.m = m;
        this.H0 = H0;
        this.rule = InverseHessianApproximation.NONE;
        this.allocateWorkspace();
    }

    private void allocateWorkspace() {
        this.tmp = this.H0 == null ? null : this.inputSpace.create();
        this.s = new Vector[this.m];
        this.y = new Vector[this.m];
        int i = 0;
        while (i < this.m) {
            this.s[i] = this.outputSpace.create();
            this.y[i] = this.inputSpace.create();
            ++i;
        }
        this.beta = new double[this.m];
        this.rho = new double[this.m];
        this.mp = 0;
        this.mark = 0;
        this.gamma = 1.0;
    }

    public void reset() {
        this.mp = 0;
    }

    public void setScaling(InverseHessianApproximation value) {
        this.rule = value;
    }

    public InverseHessianApproximation getScaling() {
        return this.rule;
    }

    public void setScale(double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("scale factor must be strictly positive");
        }
        this.gamma = value;
        this.rule = InverseHessianApproximation.BY_USER;
    }

    public double getScale() {
        return this.gamma;
    }

    protected int slot(int k) {
        if (k < 0 || k > this.mp) {
            throw new IndexOutOfBoundsException("BFGS slot index is out of bounds");
        }
        return (this.mark - k) % this.m;
    }

    protected Vector s(int k) {
        return this.s[this.slot(k)];
    }

    protected Vector y(int k) {
        return this.y[this.slot(k)];
    }

    @Override
    protected void privApply(Vector src, Vector dst, int job) {
        int j;
        if (job != DIRECT && job != ADJOINT) {
            throw new IllegalLinearOperationException();
        }
        Vector tmp = null;
        if (this.H0 == null) {
            tmp = dst;
        } else {
            if (this.tmp == null) {
                this.tmp = this.inputSpace.create();
            }
            tmp = this.tmp;
        }
        tmp.copyFrom(src);
        int k = 1;
        while (k <= this.mp) {
            j = this.slot(k);
            if (this.rho[j] > 0.0) {
                this.beta[j] = this.rho[j] * tmp.dot(this.s[j]);
                tmp.axpby(1.0, tmp, -this.beta[j], this.y[j]);
            } else {
                this.beta[j] = 0.0;
            }
            ++k;
        }
        if (this.H0 != null) {
            this.H0.apply(tmp, dst);
        }
        if (this.gamma != 1.0) {
            dst.scale(this.gamma);
        }
        k = this.mp;
        while (k >= 1) {
            j = this.slot(k);
            if (this.rho[j] > 0.0) {
                double phi = this.rho[j] * dst.dot(this.y[j]);
                dst.axpby(1.0, dst, this.beta[j] - phi, this.s[j]);
            }
            --k;
        }
    }

    public void update(Vector x1, Vector x0, Vector g1, Vector g0) throws IncorrectSpaceException {
        int j = this.slot(0);
        this.s[j].axpby(1.0, x1, -1.0, x0);
        this.y[j].axpby(1.0, g1, -1.0, g0);
        double sty = this.s[j].dot(this.y[j]);
        if (sty <= 0.0) {
            this.rho[j] = 0.0;
        } else {
            this.rho[j] = 1.0 / sty;
            if (this.rule == InverseHessianApproximation.BY_STY_OVER_YTY || this.rule == InverseHessianApproximation.BY_INITIAL_STY_OVER_YTY && this.mark == 0) {
                double ynorm = this.y[j].norm2();
                this.gamma = sty / ynorm / ynorm;
            } else if (this.rule == InverseHessianApproximation.BY_STS_OVER_STY || this.rule == InverseHessianApproximation.BY_INITIAL_STS_OVER_STY && this.mark == 0) {
                double snorm = this.s[j].norm2();
                this.gamma = snorm / sty * snorm;
            }
            ++this.mark;
            if (this.mp < this.m) {
                ++this.mp;
            }
        }
    }
}

