/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.EllipseRoi;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import ij.plugin.frame.RoiManager;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.Ellipse;
import ome.xml.model.Label;
import ome.xml.model.Line;
import ome.xml.model.OME;
import ome.xml.model.Point;
import ome.xml.model.Polygon;
import ome.xml.model.Polyline;
import ome.xml.model.Shape;
import ome.xml.model.Union;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;

public class ROIHandler {
    public static void openROIs(IMetadata retrieve, ImagePlus[] images) {
        ROIHandler.openROIs(retrieve, images, false);
    }

    public static void openROIs(IMetadata retrieve, ImagePlus[] images, boolean isOMERO) {
        if (!(retrieve instanceof OMEXMLMetadata)) {
            return;
        }
        int nextRoi = 0;
        RoiManager manager = RoiManager.getInstance();
        OME root = (OME)((Object)retrieve.getRoot());
        int imageCount = images.length;
        for (int imageNum = 0; imageNum < imageCount; ++imageNum) {
            int roiCount = root.sizeOfROIList();
            if (roiCount > 0 && manager == null) {
                manager = new RoiManager();
            }
            for (int roiNum = 0; roiNum < roiCount; ++roiNum) {
                Union shapeSet = root.getROI(roiNum).getUnion();
                int shapeCount = shapeSet.sizeOfShapeList();
                for (int shape = 0; shape < shapeCount; ++shape) {
                    Color FillColor;
                    Color StrokeColor;
                    Shape shapeObject = shapeSet.getShape(shape);
                    PointRoi roi = null;
                    Float sw = null;
                    java.awt.Color sc = null;
                    java.awt.Color fc = null;
                    int c = 0;
                    int z = 0;
                    int t = 0;
                    if (shapeObject instanceof Ellipse) {
                        Ellipse ellipse = (Ellipse)shapeObject;
                        int cx = ellipse.getX().intValue();
                        int cy = ellipse.getY().intValue();
                        int rx = ellipse.getRadiusX().intValue();
                        int ry = ellipse.getRadiusY().intValue();
                        roi = new OvalRoi(cx - rx, cy - ry, rx * 2, ry * 2);
                        if (ellipse.getStrokeColor() != null) {
                            StrokeColor = ellipse.getStrokeColor();
                            sc = new java.awt.Color(StrokeColor.getRed(), StrokeColor.getGreen(), StrokeColor.getBlue(), StrokeColor.getAlpha());
                            if (isOMERO) {
                                sc = new java.awt.Color(StrokeColor.getGreen(), StrokeColor.getBlue(), StrokeColor.getAlpha(), StrokeColor.getRed());
                            }
                        }
                        if (ellipse.getFillColor() != null) {
                            FillColor = ellipse.getFillColor();
                            fc = new java.awt.Color(FillColor.getRed(), FillColor.getGreen(), FillColor.getBlue(), FillColor.getAlpha());
                            if (isOMERO) {
                                fc = new java.awt.Color(FillColor.getGreen(), FillColor.getBlue(), FillColor.getAlpha(), FillColor.getRed());
                            }
                        }
                        if (ellipse.getStrokeWidth() != null) {
                            sw = Float.valueOf(ellipse.getStrokeWidth().value().floatValue());
                        }
                    } else if (shapeObject instanceof Line) {
                        Line line = (Line)shapeObject;
                        int x1 = line.getX1().intValue();
                        int x2 = line.getX2().intValue();
                        int y1 = line.getY1().intValue();
                        int y2 = line.getY2().intValue();
                        roi = new ij.gui.Line(x1, y1, x2, y2);
                        if (line.getStrokeColor() != null) {
                            StrokeColor = line.getStrokeColor();
                            sc = new java.awt.Color(StrokeColor.getRed(), StrokeColor.getGreen(), StrokeColor.getBlue(), StrokeColor.getAlpha());
                            if (isOMERO) {
                                sc = new java.awt.Color(StrokeColor.getGreen(), StrokeColor.getBlue(), StrokeColor.getAlpha(), StrokeColor.getRed());
                            }
                        }
                        if (line.getFillColor() != null) {
                            FillColor = line.getFillColor();
                            fc = new java.awt.Color(FillColor.getRed(), FillColor.getGreen(), FillColor.getBlue(), FillColor.getAlpha());
                            if (isOMERO) {
                                fc = new java.awt.Color(FillColor.getGreen(), FillColor.getBlue(), FillColor.getAlpha(), FillColor.getRed());
                            }
                        }
                        if (line.getStrokeWidth() != null) {
                            sw = Float.valueOf(line.getStrokeWidth().value().floatValue());
                        }
                    } else if (shapeObject instanceof Point) {
                        Point point = (Point)shapeObject;
                        int x = point.getX().intValue();
                        int y = point.getY().intValue();
                        roi = new PointRoi(x, y);
                        if (point.getStrokeColor() != null) {
                            Color StrokeColor2 = point.getStrokeColor();
                            sc = new java.awt.Color(StrokeColor2.getRed(), StrokeColor2.getGreen(), StrokeColor2.getBlue(), StrokeColor2.getAlpha());
                            if (isOMERO) {
                                sc = new java.awt.Color(StrokeColor2.getGreen(), StrokeColor2.getBlue(), StrokeColor2.getAlpha(), StrokeColor2.getRed());
                            }
                        }
                        if (point.getFillColor() != null) {
                            Color FillColor2 = point.getFillColor();
                            fc = new java.awt.Color(FillColor2.getRed(), FillColor2.getGreen(), FillColor2.getBlue(), FillColor2.getAlpha());
                            if (isOMERO) {
                                fc = new java.awt.Color(FillColor2.getGreen(), FillColor2.getBlue(), FillColor2.getAlpha(), FillColor2.getRed());
                            }
                        }
                        if (point.getStrokeWidth() != null) {
                            sw = Float.valueOf(point.getStrokeWidth().value().floatValue());
                        }
                    } else if (shapeObject instanceof Polyline) {
                        Polyline polyline = (Polyline)shapeObject;
                        String points = polyline.getPoints();
                        int[][] coordinates = ROIHandler.parsePoints(points);
                        roi = new PolygonRoi(coordinates[0], coordinates[1], coordinates[0].length, 6);
                        if (polyline.getStrokeColor() != null) {
                            Color StrokeColor3 = polyline.getStrokeColor();
                            sc = new java.awt.Color(StrokeColor3.getRed(), StrokeColor3.getGreen(), StrokeColor3.getBlue(), StrokeColor3.getAlpha());
                            if (isOMERO) {
                                sc = new java.awt.Color(StrokeColor3.getGreen(), StrokeColor3.getBlue(), StrokeColor3.getAlpha(), StrokeColor3.getRed());
                            }
                        }
                        if (polyline.getFillColor() != null) {
                            Color FillColor3 = polyline.getFillColor();
                            fc = new java.awt.Color(FillColor3.getRed(), FillColor3.getGreen(), FillColor3.getBlue(), FillColor3.getAlpha());
                            if (isOMERO) {
                                fc = new java.awt.Color(FillColor3.getGreen(), FillColor3.getBlue(), FillColor3.getAlpha(), FillColor3.getRed());
                            }
                        }
                        if (polyline.getStrokeWidth() != null) {
                            sw = Float.valueOf(polyline.getStrokeWidth().value().floatValue());
                        }
                    } else if (shapeObject instanceof Polygon) {
                        Polygon polygon = (Polygon)shapeObject;
                        String points = polygon.getPoints();
                        int[][] coordinates = ROIHandler.parsePoints(points);
                        roi = new PolygonRoi(coordinates[0], coordinates[1], coordinates[0].length, 2);
                        if (polygon.getStrokeColor() != null) {
                            Color StrokeColor4 = polygon.getStrokeColor();
                            sc = new java.awt.Color(StrokeColor4.getRed(), StrokeColor4.getGreen(), StrokeColor4.getBlue(), StrokeColor4.getAlpha());
                            if (isOMERO) {
                                sc = new java.awt.Color(StrokeColor4.getGreen(), StrokeColor4.getBlue(), StrokeColor4.getAlpha(), StrokeColor4.getRed());
                            }
                        }
                        if (polygon.getFillColor() != null) {
                            Color FillColor4 = polygon.getFillColor();
                            fc = new java.awt.Color(FillColor4.getRed(), FillColor4.getGreen(), FillColor4.getBlue(), FillColor4.getAlpha());
                            if (isOMERO) {
                                fc = new java.awt.Color(FillColor4.getGreen(), FillColor4.getBlue(), FillColor4.getAlpha(), FillColor4.getRed());
                            }
                        }
                        if (polygon.getStrokeWidth() != null) {
                            sw = Float.valueOf(polygon.getStrokeWidth().value().floatValue());
                        }
                    } else if (shapeObject instanceof Label) {
                        Label label = (Label)shapeObject;
                        double x = label.getX();
                        double y = label.getY();
                        String labelText = label.getText();
                        int size = label.getFontSize().value().intValue();
                        Font font = new Font(labelText, 0, size);
                        roi = new TextRoi((int)x, (int)y, labelText, font);
                        if (label.getStrokeColor() != null) {
                            Color StrokeColor5 = label.getStrokeColor();
                            sc = new java.awt.Color(StrokeColor5.getRed(), StrokeColor5.getGreen(), StrokeColor5.getBlue(), StrokeColor5.getAlpha());
                            if (isOMERO) {
                                sc = new java.awt.Color(StrokeColor5.getGreen(), StrokeColor5.getBlue(), StrokeColor5.getAlpha(), StrokeColor5.getRed());
                            }
                        }
                        if (label.getFillColor() != null) {
                            Color FillColor5 = label.getFillColor();
                            fc = new java.awt.Color(FillColor5.getRed(), FillColor5.getGreen(), FillColor5.getBlue(), FillColor5.getAlpha());
                            if (isOMERO) {
                                fc = new java.awt.Color(FillColor5.getGreen(), FillColor5.getBlue(), FillColor5.getAlpha(), FillColor5.getRed());
                            }
                        }
                        if (label.getStrokeWidth() != null) {
                            sw = Float.valueOf(label.getStrokeWidth().value().floatValue());
                        }
                    } else if (shapeObject instanceof ome.xml.model.Rectangle) {
                        ome.xml.model.Rectangle rectangle = (ome.xml.model.Rectangle)shapeObject;
                        int x = rectangle.getX().intValue();
                        int y = rectangle.getY().intValue();
                        int w = rectangle.getWidth().intValue();
                        int h = rectangle.getHeight().intValue();
                        roi = new Roi(x, y, w, h);
                        if (rectangle.getStrokeColor() != null) {
                            StrokeColor = rectangle.getStrokeColor();
                            sc = new java.awt.Color(StrokeColor.getRed(), StrokeColor.getGreen(), StrokeColor.getBlue(), StrokeColor.getAlpha());
                            if (isOMERO) {
                                sc = new java.awt.Color(StrokeColor.getGreen(), StrokeColor.getBlue(), StrokeColor.getAlpha(), StrokeColor.getRed());
                            }
                        }
                        if (rectangle.getFillColor() != null) {
                            FillColor = rectangle.getFillColor();
                            fc = new java.awt.Color(FillColor.getRed(), FillColor.getGreen(), FillColor.getBlue(), FillColor.getAlpha());
                            if (isOMERO) {
                                fc = new java.awt.Color(FillColor.getGreen(), FillColor.getBlue(), FillColor.getAlpha(), FillColor.getRed());
                            }
                        }
                        if (rectangle.getStrokeWidth() != null) {
                            sw = Float.valueOf(rectangle.getStrokeWidth().value().floatValue());
                        }
                    }
                    if (roi == null) continue;
                    String roiLabel = shapeObject.getText();
                    if (roiLabel == null) {
                        roiLabel = shapeObject.getID();
                    }
                    roi.setName(roiLabel);
                    if (Prefs.showAllSliceOnly) {
                        ImagePlus imp;
                        if (shapeObject.getTheC() != null) {
                            c = (Integer)shapeObject.getTheC().getValue();
                        }
                        if (shapeObject.getTheZ() != null) {
                            z = (Integer)shapeObject.getTheZ().getValue();
                        }
                        if (shapeObject.getTheT() != null) {
                            t = (Integer)shapeObject.getTheT().getValue();
                        }
                        if ((imp = images[imageNum]).getNChannels() > 1) {
                            ++c;
                        }
                        if (imp.getNSlices() > 1) {
                            ++z;
                        }
                        if (imp.getNFrames() > 1) {
                            ++t;
                        }
                        if (c == 0) {
                            c = 1;
                        }
                        if (t == 0) {
                            t = 1;
                        }
                        if (z == 0) {
                            z = 1;
                        }
                        if (imp.getNChannels() == 1 && imp.getNSlices() == 1) {
                            roi.setPosition(t);
                        } else if (imp.getNChannels() == 1 && imp.getNFrames() == 1) {
                            roi.setPosition(z);
                        } else if (imp.getNSlices() == 1 && imp.getNFrames() == 1) {
                            roi.setPosition(c);
                        } else if (imp.isHyperStack()) {
                            roi.setPosition(c, z, t);
                        }
                    }
                    if (sw == null) {
                        roi.setStrokeWidth(1.0f);
                    }
                    if (sw != null) {
                        if (sw.floatValue() == 0.0f) {
                            sw = Float.valueOf(1.0f);
                        }
                        roi.setStrokeWidth(sw.floatValue());
                    }
                    if (sc != null) {
                        roi.setStrokeColor(sc);
                    }
                    manager.add(images[imageNum], (Roi)roi, nextRoi++);
                }
            }
            if (roiCount <= 0 || manager == null) continue;
            manager.setAlwaysOnTop(true);
            manager.runCommand("show all with labels");
        }
    }

    public static Roi[] readFromRoiManager() {
        RoiManager manager = RoiManager.getInstance();
        if (manager == null) {
            return null;
        }
        return manager.getRoisAsArray();
    }

    public static Roi[] readFromOverlays() {
        ImagePlus image = IJ.getImage();
        Overlay overlay = image.getOverlay();
        if (overlay == null) {
            return null;
        }
        return overlay.toArray();
    }

    public static void saveROIs(MetadataStore store) {
        int roicount;
        Roi[] rois = ROIHandler.readFromOverlays();
        if (rois == null || rois.length == 0) {
            rois = ROIHandler.readFromRoiManager();
        }
        if (rois == null || rois.length == 0) {
            return;
        }
        ArrayList<String> discardList = new ArrayList<String>();
        String roiID = null;
        OME root = (OME)((Object)store.getRoot());
        int cntr = roicount = root.sizeOfROIList();
        ImagePlus imp = WindowManager.getCurrentImage();
        for (int i = 0; i < rois.length; ++i) {
            String type;
            String polylineID = MetadataTools.createLSID("Shape", cntr, 0);
            roiID = MetadataTools.createLSID("ROI", cntr, 0);
            Roi ijRoi = rois[i];
            int c = ijRoi.getCPosition() - 1;
            int z = ijRoi.getZPosition() - 1;
            int t = ijRoi.getTPosition() - 1;
            ImagePlus image = WindowManager.getImage((int)ijRoi.getImageID());
            if (image == null) {
                image = imp;
            }
            int pos = ijRoi.getPosition();
            if (imp != null) {
                if (imp.getNChannels() == 1 && imp.getNSlices() == 1) {
                    t = pos - 1;
                } else if (imp.getNChannels() == 1 && imp.getNFrames() == 1) {
                    z = pos - 1;
                } else if (imp.getNSlices() == 1 && imp.getNFrames() == 1) {
                    c = pos - 1;
                }
                if (t > imp.getNFrames() - 1 || c > imp.getNChannels() - 1 || z > imp.getNSlices() - 1) continue;
            }
            if (ijRoi.isDrawingTool()) {
                if (ijRoi.getTypeAsString().matches("Text")) {
                    if (ijRoi instanceof TextRoi) {
                        store.setLabelID(polylineID, cntr, 0);
                        ROIHandler.storeText((TextRoi)ijRoi, store, cntr, 0, c, z, t);
                    }
                } else if (ijRoi.getTypeAsString().matches("Rectangle")) {
                    if (ijRoi instanceof Roi) {
                        store.setRectangleID(polylineID, cntr, 0);
                        ROIHandler.storeRectangle(ijRoi, store, cntr, 0, c, z, t);
                    }
                } else {
                    roiID = null;
                    type = ijRoi.getName();
                    IJ.log((String)("ROI ID : " + type + " ROI type : " + "Arrow (Drawing Tool) is not supported"));
                }
            } else if (ijRoi instanceof OvalRoi) {
                store.setEllipseID(polylineID, cntr, 0);
                ROIHandler.storeOval((OvalRoi)ijRoi, store, cntr, 0, c, z, t);
            } else if (ijRoi instanceof ij.gui.Line) {
                boolean checkpoint = ijRoi.isDrawingTool();
                if (!checkpoint) {
                    store.setLineID(polylineID, cntr, 0);
                    ROIHandler.storeLine((ij.gui.Line)ijRoi, store, cntr, 0, c, z, t);
                } else {
                    roiID = null;
                    String type2 = ijRoi.getName();
                    IJ.log((String)("ROI ID : " + type2 + " ROI type : " + "Arrow (Drawing Tool) is not supported"));
                }
            } else if (ijRoi instanceof PolygonRoi || ijRoi instanceof EllipseRoi) {
                if (ijRoi.getTypeAsString().matches("Polyline") || ijRoi.getTypeAsString().matches("Freeline") || ijRoi.getTypeAsString().matches("Angle")) {
                    store.setPolylineID(polylineID, cntr, 0);
                    ROIHandler.storePolygon((PolygonRoi)ijRoi, store, cntr, 0, c, z, t);
                } else if (ijRoi.getTypeAsString().matches("Point")) {
                    store.setPointID(polylineID, cntr, 0);
                    ROIHandler.storePoint((PointRoi)ijRoi, store, cntr, 0, c, z, t);
                } else if (ijRoi.getTypeAsString().matches("Polygon") || ijRoi.getTypeAsString().matches("Freehand") || ijRoi.getTypeAsString().matches("Traced") || ijRoi.getTypeAsString().matches("Oval")) {
                    store.setPolygonID(polylineID, cntr, 0);
                    ROIHandler.storePolygon((PolygonRoi)ijRoi, store, cntr, 0, c, z, t);
                }
            } else if (ijRoi instanceof ShapeRoi) {
                Roi[] subRois = ((ShapeRoi)ijRoi).getRois();
                for (int q = 0; q < subRois.length; ++q) {
                    String type3;
                    polylineID = MetadataTools.createLSID("Shape", cntr, q);
                    roiID = MetadataTools.createLSID("ROI", cntr, q);
                    Roi ijShape = subRois[q];
                    if (ijShape.isDrawingTool()) {
                        if (ijShape.getTypeAsString().matches("Text")) {
                            if (!(ijShape instanceof TextRoi)) continue;
                            store.setLabelID(polylineID, cntr, q);
                            ROIHandler.storeText((TextRoi)ijShape, store, cntr, q, c, z, t);
                            continue;
                        }
                        if (ijShape.getTypeAsString().matches("Rectangle")) {
                            if (!(ijShape instanceof Roi)) continue;
                            store.setRectangleID(polylineID, cntr, q);
                            ROIHandler.storeRectangle(ijShape, store, cntr, q, c, z, t);
                            continue;
                        }
                        roiID = null;
                        type3 = ijShape.getName();
                        IJ.log((String)("ROI ID : " + type3 + " ROI type : " + "Arrow (Drawing Tool) is not supported"));
                        continue;
                    }
                    if (ijShape instanceof ij.gui.Line) {
                        boolean checkpoint = ijShape.isDrawingTool();
                        if (!checkpoint) {
                            store.setLineID(polylineID, cntr, 0);
                            ROIHandler.storeLine((ij.gui.Line)ijShape, store, cntr, 0, c, z, t);
                            continue;
                        }
                        roiID = null;
                        String type1 = ijShape.getName();
                        discardList.add(type1);
                        IJ.log((String)("ROI ID : " + type1 + " ROI type : " + "Arrow (DrawingTool) is not supported"));
                        continue;
                    }
                    if (ijShape instanceof OvalRoi) {
                        store.setEllipseID(polylineID, cntr, q);
                        ROIHandler.storeOval((OvalRoi)ijShape, store, cntr, q, c, z, t);
                        continue;
                    }
                    if (ijShape instanceof PolygonRoi || ijShape instanceof EllipseRoi) {
                        if (ijShape.getTypeAsString().matches("Polyline") || ijShape.getTypeAsString().matches("Freeline") || ijShape.getTypeAsString().matches("Angle")) {
                            store.setPolylineID(polylineID, cntr, q);
                            ROIHandler.storePolygon((PolygonRoi)ijShape, store, cntr, q, c, z, t);
                            continue;
                        }
                        if (ijShape.getTypeAsString().matches("Point")) {
                            store.setPointID(polylineID, cntr, q);
                            ROIHandler.storePoint((PointRoi)ijShape, store, cntr, q, c, z, t);
                            continue;
                        }
                        if (!ijShape.getTypeAsString().matches("Polygon") && !ijShape.getTypeAsString().matches("Freehand") && !ijShape.getTypeAsString().matches("Traced") && !ijShape.getTypeAsString().matches("Oval")) continue;
                        store.setPolygonID(polylineID, cntr, q);
                        ROIHandler.storePolygon((PolygonRoi)ijShape, store, cntr, q, c, z, t);
                        continue;
                    }
                    if (ijShape.getTypeAsString().matches("Rectangle")) {
                        store.setRectangleID(polylineID, cntr, q);
                        ROIHandler.storeRectangle(ijShape, store, cntr, q, c, z, t);
                        continue;
                    }
                    roiID = null;
                    type3 = ijShape.getName();
                    IJ.log((String)("ROI ID : " + type3 + " ROI type : " + ijShape.getTypeAsString() + "is not supported"));
                }
            } else if (ijRoi.getTypeAsString().matches("Rectangle")) {
                store.setRectangleID(polylineID, cntr, 0);
                ROIHandler.storeRectangle(ijRoi, store, cntr, 0, c, z, t);
            } else {
                roiID = null;
                type = ijRoi.getName();
                IJ.log((String)("ROI ID : " + type + " ROI type : " + rois[cntr].getTypeAsString() + "is not supported"));
            }
            if (roiID == null) continue;
            store.setROIID(roiID, cntr);
            store.setImageROIRef(roiID, 0, cntr);
            ++cntr;
        }
    }

    private static NonNegativeInteger unwrap(int r) {
        return new NonNegativeInteger(r);
    }

    private static void storeText(TextRoi roi, MetadataStore store, int roiNum, int shape, int c, int z, int t) {
        store.setLabelX(roi.getPolygon().getBounds().getX(), roiNum, shape);
        store.setLabelY(roi.getPolygon().getBounds().getY(), roiNum, shape);
        store.setLabelText(roi.getText().trim(), roiNum, shape);
        store.setLabelFontSize(new Length(roi.getCurrentFont().getSize(), UNITS.PIXEL), roiNum, shape);
        if (c >= 0) {
            store.setLabelTheC(ROIHandler.unwrap(c), roiNum, shape);
        }
        if (z >= 0) {
            store.setLabelTheZ(ROIHandler.unwrap(z), roiNum, shape);
        }
        if (t >= 0) {
            store.setLabelTheT(ROIHandler.unwrap(t), roiNum, shape);
        }
        if (roi.getStrokeWidth() > 0.0f) {
            store.setLabelStrokeWidth(new Length(Float.valueOf(roi.getStrokeWidth()), UNITS.PIXEL), roiNum, shape);
        }
        if (roi.getStrokeColor() != null) {
            store.setLabelStrokeColor(ROIHandler.toOMExmlColor(roi.getStrokeColor()), roiNum, shape);
        }
        if (roi.getFillColor() != null) {
            store.setLabelFillColor(ROIHandler.toOMExmlColor(roi.getFillColor()), roiNum, shape);
        }
    }

    private static void storePoint(PointRoi roi, MetadataStore store, int roiNum, int shape, int c, int z, int t) {
        int[] xCoordinates = roi.getPolygon().xpoints;
        int[] yCoordinates = roi.getPolygon().ypoints;
        for (int cntr = 0; cntr < xCoordinates.length; ++cntr) {
            String polylineID = MetadataTools.createLSID("Shape", roiNum, shape + cntr);
            store.setPointID(polylineID, roiNum, shape + cntr);
            store.setPointX(Double.valueOf(xCoordinates[cntr]), roiNum, shape + cntr);
            store.setPointY(Double.valueOf(yCoordinates[cntr]), roiNum, shape + cntr);
            store.setPointText(roi.getName(), roiNum, shape + cntr);
            if (c >= 0) {
                store.setPointTheC(ROIHandler.unwrap(c), roiNum, shape);
            }
            if (z >= 0) {
                store.setPointTheZ(ROIHandler.unwrap(z), roiNum, shape);
            }
            if (t >= 0) {
                store.setPointTheT(ROIHandler.unwrap(t), roiNum, shape);
            }
            if (roi.getStrokeWidth() > 0.0f) {
                store.setPointStrokeWidth(new Length(Float.valueOf(roi.getStrokeWidth()), UNITS.PIXEL), roiNum, shape + cntr);
            }
            if (roi.getStrokeColor() != null) {
                store.setPointStrokeColor(ROIHandler.toOMExmlColor(roi.getStrokeColor()), roiNum, shape + cntr);
            }
            if (roi.getFillColor() == null) continue;
            store.setPointFillColor(ROIHandler.toOMExmlColor(roi.getFillColor()), roiNum, shape + cntr);
        }
    }

    private static void storeLine(ij.gui.Line roi, MetadataStore store, int roiNum, int shape, int c, int z, int t) {
        store.setLineX1(new Double(roi.x1), roiNum, shape);
        store.setLineX2(new Double(roi.x2), roiNum, shape);
        store.setLineY1(new Double(roi.y1), roiNum, shape);
        store.setLineY2(new Double(roi.y2), roiNum, shape);
        if (c >= 0) {
            store.setLineTheC(ROIHandler.unwrap(c), roiNum, shape);
        }
        if (z >= 0) {
            store.setLineTheZ(ROIHandler.unwrap(z), roiNum, shape);
        }
        if (t >= 0) {
            store.setLineTheT(ROIHandler.unwrap(t), roiNum, shape);
        }
        store.setLineText(roi.getName(), roiNum, shape);
        if (roi.getStrokeWidth() > 0.0f) {
            store.setLineStrokeWidth(new Length(Float.valueOf(roi.getStrokeWidth()), UNITS.PIXEL), roiNum, shape);
        }
        if (roi.getStrokeColor() != null) {
            store.setLineStrokeColor(ROIHandler.toOMExmlColor(roi.getStrokeColor()), roiNum, shape);
        }
        if (roi.getFillColor() != null) {
            store.setLineFillColor(ROIHandler.toOMExmlColor(roi.getFillColor()), roiNum, shape);
        }
    }

    private static void storeRectangle(Roi roi, MetadataStore store, int roiNum, int shape, int c, int z, int t) {
        Rectangle bounds = roi.getBounds();
        store.setRectangleX(new Double(bounds.x), roiNum, shape);
        store.setRectangleY(new Double(bounds.y), roiNum, shape);
        store.setRectangleWidth(new Double(bounds.width), roiNum, shape);
        store.setRectangleHeight(new Double(bounds.height), roiNum, shape);
        if (c >= 0) {
            store.setRectangleTheC(ROIHandler.unwrap(c), roiNum, shape);
        }
        if (z >= 0) {
            store.setRectangleTheZ(ROIHandler.unwrap(z), roiNum, shape);
        }
        if (t >= 0) {
            store.setRectangleTheT(ROIHandler.unwrap(t), roiNum, shape);
        }
        store.setRectangleText(roi.getName(), roiNum, shape);
        if (roi.getStrokeWidth() > 0.0f) {
            store.setRectangleStrokeWidth(new Length(Float.valueOf(roi.getStrokeWidth()), UNITS.PIXEL), roiNum, shape);
        }
        if (roi.getStrokeColor() != null) {
            store.setRectangleStrokeColor(ROIHandler.toOMExmlColor(roi.getStrokeColor()), roiNum, shape);
        }
        if (roi.getFillColor() != null) {
            store.setRectangleFillColor(ROIHandler.toOMExmlColor(roi.getFillColor()), roiNum, shape);
        }
    }

    private static void storePolygon(PolygonRoi roi, MetadataStore store, int roiNum, int shape, int c, int z, int t) {
        int[] xCoordinates = roi.getPolygon().xpoints;
        int[] yCoordinates = roi.getPolygon().ypoints;
        String st1 = roi.getTypeAsString();
        String points = "1";
        for (int i = 0; i < xCoordinates.length; ++i) {
            points = i == 0 ? xCoordinates[i] + "," + yCoordinates[i] : points + " " + xCoordinates[i] + "," + yCoordinates[i];
        }
        if (st1.matches("Polyline") || st1.matches("Freeline") || st1.matches("Angle")) {
            store.setPolylinePoints(points.toString(), roiNum, shape);
            store.setPolylineText(roi.getName(), roiNum, shape);
            if (c >= 0) {
                store.setPolylineTheC(ROIHandler.unwrap(c), roiNum, shape);
            }
            if (z >= 0) {
                store.setPolylineTheZ(ROIHandler.unwrap(z), roiNum, shape);
            }
            if (t >= 0) {
                store.setPolylineTheT(ROIHandler.unwrap(t), roiNum, shape);
            }
            if (roi.getStrokeWidth() > 0.0f) {
                store.setPolylineStrokeWidth(new Length(Float.valueOf(roi.getStrokeWidth()), UNITS.PIXEL), roiNum, shape);
            }
            if (roi.getStrokeColor() != null) {
                store.setPolylineStrokeColor(ROIHandler.toOMExmlColor(roi.getStrokeColor()), roiNum, shape);
            }
            if (roi.getFillColor() != null) {
                store.setPolylineFillColor(ROIHandler.toOMExmlColor(roi.getFillColor()), roiNum, shape);
            }
        } else if (st1.matches("Polygon") || st1.matches("Freehand") || st1.matches("Traced")) {
            store.setPolygonPoints(points.toString(), roiNum, shape);
            store.setPolygonText(roi.getName(), roiNum, shape);
            if (c >= 0) {
                store.setPolygonTheC(ROIHandler.unwrap(c), roiNum, shape);
            }
            if (z >= 0) {
                store.setPolygonTheZ(ROIHandler.unwrap(z), roiNum, shape);
            }
            if (t >= 0) {
                store.setPolygonTheT(ROIHandler.unwrap(t), roiNum, shape);
            }
            if (roi.getStrokeWidth() > 0.0f) {
                store.setPolygonStrokeWidth(new Length(Float.valueOf(roi.getStrokeWidth()), UNITS.PIXEL), roiNum, shape);
            }
            if (roi.getStrokeColor() != null) {
                store.setPolygonStrokeColor(ROIHandler.toOMExmlColor(roi.getStrokeColor()), roiNum, shape);
            }
            if (roi.getFillColor() != null) {
                store.setPolygonFillColor(ROIHandler.toOMExmlColor(roi.getFillColor()), roiNum, shape);
            }
        }
    }

    private static void storeOval(OvalRoi roi, MetadataStore store, int roiNum, int shape, int c, int z, int t) {
        Rectangle vnRectBounds = roi.getPolygon().getBounds();
        int x = vnRectBounds.x;
        int y = vnRectBounds.y;
        double rx = vnRectBounds.getWidth();
        double ry = vnRectBounds.getHeight();
        store.setEllipseX((double)x + rx / 2.0, roiNum, shape);
        store.setEllipseY((double)y + ry / 2.0, roiNum, shape);
        store.setEllipseRadiusX(rx / 2.0, roiNum, shape);
        store.setEllipseRadiusY(ry / 2.0, roiNum, shape);
        store.setEllipseText(roi.getName(), roiNum, shape);
        if (c >= 0) {
            store.setEllipseTheC(ROIHandler.unwrap(c), roiNum, shape);
        }
        if (z >= 0) {
            store.setEllipseTheZ(ROIHandler.unwrap(z), roiNum, shape);
        }
        if (t >= 0) {
            store.setEllipseTheT(ROIHandler.unwrap(t), roiNum, shape);
        }
        if (roi.getStrokeWidth() > 0.0f) {
            store.setEllipseStrokeWidth(new Length(Float.valueOf(roi.getStrokeWidth()), UNITS.PIXEL), roiNum, shape);
        }
        if (roi.getStrokeColor() != null) {
            store.setEllipseStrokeColor(ROIHandler.toOMExmlColor(roi.getStrokeColor()), roiNum, shape);
        }
        if (roi.getFillColor() != null) {
            store.setEllipseFillColor(ROIHandler.toOMExmlColor(roi.getFillColor()), roiNum, shape);
        }
    }

    private static int[][] parsePoints(String points) {
        String[] pointList = points.split(" ");
        int[][] coordinates = new int[2][pointList.length];
        for (int q = 0; q < pointList.length; ++q) {
            pointList[q] = pointList[q].trim();
            int delim = pointList[q].indexOf(",");
            coordinates[0][q] = (int)Double.parseDouble(pointList[q].substring(0, delim));
            coordinates[1][q] = (int)Double.parseDouble(pointList[q].substring(delim + 1));
        }
        return coordinates;
    }

    private static Color toOMExmlColor(java.awt.Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }
}

