/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv.impl;

import mitiv.deconv.impl.ConvolutionFloat;
import mitiv.linalg.shaped.ShapedVectorSpace;
import org.jtransforms.fft.FloatFFT_2D;

public class ConvolutionFloat2D
extends ConvolutionFloat {
    private FloatFFT_2D fft = null;
    private final float scale;
    private final int number;
    private final int dim1;
    private final int dim2;
    private final int off1;
    private final int off2;
    private final int end1;
    private final int end2;
    private final boolean fastPull;

    public ConvolutionFloat2D(ShapedVectorSpace space) {
        super(space);
        if (space.getRank() != 2) {
            throw new IllegalArgumentException("Vector space must be have 2 dimension(s)");
        }
        this.number = space.getNumber();
        this.scale = 1.0f / (float)this.number;
        this.dim1 = space.getDimension(1);
        this.off1 = 0;
        this.end1 = this.dim1;
        this.dim2 = space.getDimension(0);
        this.off2 = 0;
        this.end2 = this.dim2;
        this.fastPull = true;
    }

    public ConvolutionFloat2D(ShapedVectorSpace inp, ShapedVectorSpace out, int[] off) {
        super(inp, out);
        if (inp.getRank() != 2) {
            throw new IllegalArgumentException("Input space is not 2D");
        }
        if (out.getRank() != 2) {
            throw new IllegalArgumentException("Output space is not 2D");
        }
        this.number = inp.getNumber();
        this.scale = 1.0f / (float)this.number;
        this.dim1 = inp.getDimension(0);
        this.off1 = off[0];
        this.end1 = this.off1 + out.getDimension(0);
        if (this.off1 < 0 || this.off1 >= this.dim1) {
            throw new IllegalArgumentException("Out of range offset along 1st dimension.");
        }
        if (this.end1 > this.dim1) {
            throw new IllegalArgumentException("Data (+ offset) beyond 1st dimension.");
        }
        this.dim2 = inp.getDimension(1);
        this.off2 = off[1];
        this.end2 = this.off2 + out.getDimension(1);
        if (this.off2 < 0 || this.off2 >= this.dim2) {
            throw new IllegalArgumentException("Out of range offset along 2nd dimension.");
        }
        if (this.end2 > this.dim2) {
            throw new IllegalArgumentException("Data (+ offset) beyond 2nd dimension.");
        }
        this.fastPull = out.getShape().equals(inp.getShape());
    }

    private final void createFFT() {
        if (this.fft == null) {
            this.fft = new FloatFFT_2D((long)this.dim1, (long)this.dim2);
        }
    }

    @Override
    public final void forwardFFT(float[] z) {
        if (z.length != 2 * this.number) {
            throw new IllegalArgumentException("Bad workspace size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexForward(z);
        this.timerForFFT.stop();
    }

    @Override
    public final void backwardFFT(float[] z) {
        if (z.length != 2 * this.number) {
            throw new IllegalArgumentException("Bad argument size");
        }
        this.timerForFFT.resume();
        if (this.fft == null) {
            this.createFFT();
        }
        this.fft.complexInverse(z, false);
        this.timerForFFT.stop();
    }

    @Override
    public void pull(float[] x) {
        if (x == null || x.length != this.number) {
            throw new IllegalArgumentException("Bad output size");
        }
        float[] z = this.getWorkspace();
        int real = 0;
        if (this.fastPull) {
            int k = 0;
            while (k < this.number) {
                x[k] = this.scale * z[real];
                real += 2;
                ++k;
            }
        } else {
            int k = 0;
            int i2 = 0;
            while (i2 < this.dim2) {
                boolean test = this.off2 <= i2 && i2 < this.end2;
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (test && this.off1 <= i1 && i1 < this.end1) {
                        x[k] = this.scale * z[real];
                        ++k;
                    }
                    real += 2;
                    ++i1;
                }
                ++i2;
            }
        }
    }
}

