/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class DistanceRidge {
    public float[][] data;
    public int w;
    public int h;
    public int d;
    public float scale;
    public float scaleInv;
    public float scaleSq;
    public float scaleInvSq;

    public ImagePlus run(ImagePlus imagePlus, float f, float f2, int n) {
        int n2;
        int n3;
        int n4;
        float[] fArray;
        int n5;
        int n6;
        ImageStack imageStack = imagePlus.getStack();
        this.w = imageStack.getWidth();
        this.h = imageStack.getHeight();
        this.d = imagePlus.getStackSize();
        this.scale = f / f2;
        this.scaleInv = f2 / f;
        this.scaleSq = this.scale * this.scale;
        this.scaleInvSq = this.scaleInv * this.scaleInv;
        ImageStack imageStack2 = new ImageStack(this.w, this.h);
        float[][] fArrayArray = new float[this.d][];
        for (int i = 0; i < this.d; ++i) {
            FloatProcessor floatProcessor = new FloatProcessor(this.w, this.h);
            imageStack2.addSlice(null, (ImageProcessor)floatProcessor);
            fArrayArray[i] = (float[])floatProcessor.getPixels();
        }
        float[][] fArrayArray2 = new float[this.d][];
        for (n6 = 0; n6 < this.d; ++n6) {
            fArrayArray2[n6] = (float[])imageStack.getPixels(n6 + 1);
        }
        IJ.showStatus((String)"Distance Ridge: scanning the data");
        float f3 = 0.0f;
        for (n5 = 0; n5 < this.d; ++n5) {
            fArray = fArrayArray2[n5];
            for (int i = 0; i < this.h; ++i) {
                for (n4 = 0; n4 < this.w; ++n4) {
                    n3 = n4 + this.w * i;
                    if (!(fArray[n3] > f3)) continue;
                    f3 = fArray[n3];
                }
            }
        }
        n5 = (int)(f3 * f3 + 0.5f) + 1;
        boolean[] blArray = new boolean[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            blArray[n4] = false;
        }
        for (n4 = 0; n4 < this.d; ++n4) {
            fArray = fArrayArray2[n4];
            for (n3 = 0; n3 < this.h; ++n3) {
                for (int i = 0; i < this.w; ++i) {
                    n2 = i + this.w * n3;
                    blArray[(int)(fArray[n2] * fArray[n2] + 0.5f)] = true;
                }
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (!blArray[n3]) continue;
            ++n4;
        }
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n4];
        n2 = 0;
        for (int i = 0; i < n5; ++i) {
            if (!blArray[i]) continue;
            nArray[i] = n2;
            nArray2[n2++] = i;
        }
        float[][] fArray2 = this.createTemplate(nArray2);
        for (int i = 0; i < this.d; ++i) {
            fArray = fArrayArray2[i];
            float[] fArray3 = fArrayArray[i];
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.w; ++k) {
                    int n7 = k + this.w * j;
                    if (!(fArray[n7] > 0.0f)) continue;
                    boolean bl = false;
                    int n8 = (int)(fArray[n7] * fArray[n7] + 0.5f);
                    int n9 = nArray[n8];
                    for (int i2 = -1; i2 <= 1; ++i2) {
                        n6 = i + i2;
                        if (n6 >= 0 && n6 < this.d) {
                            float[] fArray4 = fArrayArray2[n6];
                            int n10 = i2 == 0 ? 0 : 1;
                            for (int i3 = -1; i3 <= 1; ++i3) {
                                int n11 = j + i3;
                                if (n11 >= 0 && n11 < this.h) {
                                    int n12 = i3 == 0 ? 0 : 1;
                                    for (int i4 = -1; i4 <= 1; ++i4) {
                                        float f4;
                                        int n13;
                                        int n14;
                                        int n15 = k + i4;
                                        if (n15 >= 0 && n15 < this.w && (n14 = (n13 = i4 == 0 ? 0 : 1) + n12 + n10) > 0 && (f4 = fArray4[n15 + this.w * n11] * fArray4[n15 + this.w * n11]) >= fArray2[n14 - 1][n9]) {
                                            bl = true;
                                        }
                                        if (bl) break;
                                    }
                                }
                                if (bl) break;
                            }
                        }
                        if (bl) break;
                    }
                    if (bl) continue;
                    fArray3[n7] = fArray[n7];
                }
            }
        }
        String string = this.stripExtension(imagePlus.getTitle());
        ImagePlus imagePlus2 = new ImagePlus(string + "_DR", imageStack2);
        return imagePlus2;
    }

    float[][] createTemplate(int[] nArray) {
        float[][] fArrayArray = new float[][]{this.scanCube(1, 0, 0, nArray), this.scanCube(1, 1, 0, nArray), this.scanCube(1, 1, 1, nArray)};
        return fArrayArray;
    }

    float[] scanCube(int n, int n2, int n3, int[] nArray) {
        int n4 = nArray.length;
        float[] fArray = new float[n4];
        if (n == 0 && n2 == 0 && n3 == 0) {
            for (int i = 0; i < n4; ++i) {
                fArray[i] = 2.1474836E9f;
            }
        } else {
            float f = -((float)Math.abs(n));
            float f2 = -((float)Math.abs(n2));
            float f3 = -((float)Math.abs(n3));
            for (int i = 0; i < n4; ++i) {
                int n5 = nArray[i];
                float f4 = 0.0f;
                int n6 = 1 + (int)Math.sqrt(n5);
                int n7 = (int)((double)((float)(n6 - 1) * this.scale) + 0.5) + 1;
                for (int j = 0; j <= n7; ++j) {
                    float f5 = (float)(j * j) * this.scaleInvSq;
                    float f6 = ((float)j - f3) * ((float)j - f3) * this.scaleInvSq;
                    for (int k = 0; k <= n6; ++k) {
                        float f7;
                        float f8;
                        float f9 = f5 * (float)k * (float)k;
                        if (!(f9 <= (float)n5) || !((f8 = f6 + ((float)k - f2) * ((float)k - f2) + (f7 = (float)((int)Math.sqrt((float)n5 - f9)) - f) * f7) > f4)) continue;
                        f4 = f8;
                    }
                }
                fArray[i] = f4;
            }
        }
        return fArray;
    }

    String stripExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }
}

