/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tdouble.quantile;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.random.tdouble.sampling.WeightedDoubleRandomSampler;
import cern.jet.stat.Utils;
import cern.jet.stat.tdouble.quantile.DoubleBuffer;
import cern.jet.stat.tdouble.quantile.DoubleQuantileEstimator;
import java.util.Comparator;

class UnknownDoubleQuantileEstimator
extends DoubleQuantileEstimator {
    private static final long serialVersionUID = 1L;
    protected int currentTreeHeight;
    protected final int treeHeightStartingSampling;
    protected WeightedDoubleRandomSampler sampler;
    protected double precomputeEpsilon;

    public UnknownDoubleQuantileEstimator(int b, int k, int h, double precomputeEpsilon, DoubleRandomEngine generator) {
        this.sampler = new WeightedDoubleRandomSampler(1, generator);
        this.setUp(b, k);
        this.treeHeightStartingSampling = h;
        this.precomputeEpsilon = precomputeEpsilon;
        this.clear();
    }

    @Override
    protected DoubleBuffer[] buffersToCollapse() {
        DoubleBuffer[] fullBuffers = this.bufferSet._getFullOrPartialBuffers();
        UnknownDoubleQuantileEstimator.sortAscendingByLevel(fullBuffers);
        int minLevel = fullBuffers[1].level();
        if (fullBuffers[0].level() < minLevel) {
            fullBuffers[0].level(minLevel);
        }
        return this.bufferSet._getFullOrPartialBuffersWithLevel(minLevel);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.currentTreeHeight = 1;
        this.sampler.setWeight(1);
    }

    @Override
    public Object clone() {
        UnknownDoubleQuantileEstimator copy = (UnknownDoubleQuantileEstimator)super.clone();
        if (this.sampler != null) {
            copy.sampler = (WeightedDoubleRandomSampler)copy.sampler.clone();
        }
        return copy;
    }

    @Override
    protected void newBuffer() {
        this.currentBufferToFill = this.bufferSet._getFirstEmptyBuffer();
        if (this.currentBufferToFill == null) {
            throw new RuntimeException("Oops, no empty buffer.");
        }
        this.currentBufferToFill.level(this.currentTreeHeight - 1);
        this.currentBufferToFill.weight(this.sampler.getWeight());
    }

    @Override
    protected void postCollapse(DoubleBuffer[] toCollapse) {
        if (toCollapse.length == this.bufferSet.b()) {
            ++this.currentTreeHeight;
            if (this.currentTreeHeight >= this.treeHeightStartingSampling) {
                this.sampler.setWeight(this.sampler.getWeight() * 2);
            }
        }
    }

    @Override
    public DoubleArrayList quantileElements(DoubleArrayList phis) {
        if (this.precomputeEpsilon <= 0.0) {
            return super.quantileElements(phis);
        }
        int quantilesToPrecompute = (int)Utils.epsilonCeiling(1.0 / this.precomputeEpsilon);
        phis = phis.copy();
        double e = this.precomputeEpsilon;
        int index = phis.size();
        while (--index >= 0) {
            double phi = phis.get(index);
            int i = (int)Math.round((2.0 * phi / e - 1.0) / 2.0);
            i = Math.min(quantilesToPrecompute - 1, Math.max(0, i));
            double augmentedPhi = e / 2.0 * (double)(1 + 2 * i);
            phis.set(index, augmentedPhi);
        }
        return super.quantileElements(phis);
    }

    @Override
    protected boolean sampleNextElement() {
        return this.sampler.sampleNextElement();
    }

    protected static void sortAscendingByLevel(DoubleBuffer[] fullBuffers) {
        new ObjectArrayList(fullBuffers).quickSortFromTo(0, fullBuffers.length - 1, new Comparator(){

            public int compare(Object o1, Object o2) {
                int l2;
                int l1 = ((DoubleBuffer)o1).level();
                return l1 < (l2 = ((DoubleBuffer)o2).level()) ? -1 : (l1 == l2 ? 0 : 1);
            }
        });
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.setLength(buf.length() - 1);
        return buf + ", h=" + this.currentTreeHeight + ", hStartSampling=" + this.treeHeightStartingSampling + ", precomputeEpsilon=" + this.precomputeEpsilon + ")";
    }
}

