/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.adobe;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.adobe.AdobeJpegDirectory;

public class AdobeJpegReader
implements MetadataReader {
    public void extract(@NotNull BufferReader reader, @NotNull Metadata metadata) {
        AdobeJpegDirectory directory = metadata.getOrCreateDirectory(AdobeJpegDirectory.class);
        if (reader.getLength() != 12L) {
            directory.addError(String.format("Adobe JPEG data is expected to be 12 bytes long, not %d.", reader.getLength()));
            return;
        }
        try {
            reader.setMotorolaByteOrder(false);
            if (!reader.getString(0, 5).equals("Adobe")) {
                directory.addError("Invalid Adobe JPEG data header.");
                return;
            }
            directory.setInt(0, reader.getUInt16(5));
            directory.setInt(1, reader.getUInt16(7));
            directory.setInt(2, reader.getUInt16(9));
            directory.setInt(3, reader.getInt8(11));
        }
        catch (BufferBoundsException ex) {
            directory.addError("Exif data segment ended prematurely");
        }
    }
}

