package vtk;

import java.util.Properties;
import java.util.StringTokenizer;

public class vtkSettings
{
  private static String GetVTKBuildLibDir() { return "D:/Stephane/Documents/dev/VTK/6.3.0/build/bin"; }
  private static String GetVTKInstallLibDir() { return "C:/Program Files/VTK/"; }

  private static String[] Split(String str, String sep)
    {
    StringTokenizer st = new StringTokenizer(str, sep);
    int size = st.countTokens();
    String[] res = new String[size];
    int cnt = 0;
    while (st.hasMoreTokens())
      {
      res[cnt] = st.nextToken();
      cnt ++;
      }
    return res;
    }

  public static String GetVTKLibraryDir()
    {
    String lpath = null;
    Properties p = System.getProperties();
    String path_separator = p.getProperty("path.separator");
    String s = p.getProperty("java.class.path");
    String[] paths = vtkSettings.Split(s, path_separator);
    int cc;
    for ( cc = 0; cc < paths.length; cc ++ )
      {
      if ( paths[cc].endsWith("vtk.jar") )
        {
        lpath = paths[cc].substring(0, paths[cc].length()-"vtk.jar".length()-1);
        }
      }
    if ( lpath == null )
      {
      lpath = vtkSettings.GetVTKInstallLibDir();
      }
    return lpath;
    }

  public static String[] GetKits()
    {
    return vtkSettings.Split("CommonCore;CommonMath;CommonMisc;CommonSystem;CommonTransforms;CommonDataModel;CommonColor;CommonExecutionModel;FiltersCore;CommonComputationalGeometry;FiltersGeneral;ImagingCore;ImagingFourier;FiltersStatistics;FiltersExtraction;InfovisCore;FiltersGeometry;FiltersSources;RenderingCore;RenderingFreeType;RenderingContext2D;ChartsCore;IOCore;IOGeometry;IOXMLParser;IOXML;DomainsChemistry;IOImage;ImagingHybrid;RenderingOpenGL2;DomainsChemistryOpenGL2;IOLegacy;ParallelCore;FiltersAMR;FiltersFlowPaths;FiltersGeneric;ImagingSources;FiltersHybrid;FiltersHyperTree;ImagingGeneral;FiltersImaging;FiltersModeling;FiltersParallel;FiltersParallelImaging;FiltersProgrammable;FiltersSMP;FiltersSelection;FiltersTexture;FiltersVerdict;InfovisLayout;InteractionStyle;ImagingColor;RenderingAnnotation;RenderingVolume;InteractionWidgets;ViewsCore;GeovisCore;IOAMR;IOEnSight;IOExodus;RenderingLabel;IOExport;IOImport;IOInfovis;IOLSDyna;IOMINC;IOMovie;IONetCDF;IOPLY;IOParallel;IOParallelXML;IOSQL;IOVideo;ImagingMath;ImagingMorphological;ImagingStatistics;ImagingStencil;InteractionImage;RenderingContextOpenGL2;RenderingImage;RenderingLOD;RenderingVolumeOpenGL2;ViewsContext2D;ViewsInfovis", ";");
    }
}
