/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public abstract class ConvexSetProjector {
    protected final VectorSpace space;

    protected ConvexSetProjector(VectorSpace vsp) {
        this.space = vsp;
    }

    public VectorSpace getSpace() {
        return this.space;
    }

    public VectorSpace getInputSpace() {
        return this.space;
    }

    public VectorSpace getOutputSpace() {
        return this.space;
    }

    public void projectVariables(Vector xp, Vector x) {
        if (x == null || !x.belongsTo(this.space) || xp == null || !xp.belongsTo(this.space)) {
            throw new IncorrectSpaceException();
        }
        this._projectVariables(xp, x);
    }

    public void projectVariables(Vector x) {
        if (x == null || !x.belongsTo(this.space)) {
            throw new IncorrectSpaceException();
        }
        this._projectVariables(x, x);
    }

    protected abstract void _projectVariables(Vector var1, Vector var2);
}

