/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.BoundProjector;
import mitiv.optim.LBFGSOperator;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.ReverseCommunicationOptimizer;

public class BLMVM
extends ReverseCommunicationOptimizer {
    protected LBFGSOperator H = null;
    protected double delta = 0.01;
    protected double epsilon = 0.001;
    protected double grtol;
    protected double gatol;
    protected double pginit;
    protected double pnorm;
    protected double stpmin = 1.0E-20;
    protected double stpmax = 1.0E20;
    protected double sftol = 0.01;
    protected double[] bnd = new double[2];
    private boolean saveMemory = true;
    protected Vector x0 = null;
    protected double f0 = 0.0;
    protected Vector g0 = null;
    protected Vector pg0 = null;
    protected Vector pg = null;
    protected double pgnorm = 0.0;
    protected Vector tmp = null;
    protected Vector p = null;
    protected double alpha;
    protected final BoundProjector projector;

    public BLMVM(VectorSpace vsp, BoundProjector bp, int m) {
        this(new LBFGSOperator(vsp, m), bp);
    }

    public BLMVM(LinearOperator H0, BoundProjector bp, int m) {
        this(new LBFGSOperator(H0, m), bp);
    }

    private BLMVM(LBFGSOperator H, BoundProjector bp) {
        this.H = H;
        if (bp == null) {
            throw new IllegalArgumentException("Illegal null projector");
        }
        this.projector = bp;
        this.p = H.getOutputSpace().create();
        if (!this.saveMemory) {
            this.x0 = H.getOutputSpace().create();
            this.g0 = H.getInputSpace().create();
        }
        this.pg0 = H.getInputSpace().create();
        this.pg = H.getInputSpace().create();
        this.tmp = H.getInputSpace().create();
    }

    @Override
    public OptimTask start() {
        this.evaluations = 0;
        this.iterations = 0;
        this.restarts = 0;
        return this.begin();
    }

    @Override
    public OptimTask restart() {
        ++this.restarts;
        return this.begin();
    }

    private OptimTask begin() {
        this.H.reset();
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask iterate(Vector x, double f, Vector g) {
        switch (this.getTask()) {
            case COMPUTE_FG: {
                ++this.evaluations;
                this.projector.projectDirection(x, g, true, this.pg);
                this.pgnorm = this.pg.norm2();
                if (this.evaluations == 1) {
                    this.pginit = this.pgnorm;
                }
                if (this.pgnorm <= BLMVM.max(0.0, this.gatol, this.grtol * this.pginit)) {
                    return this.success(OptimTask.FINAL_X);
                }
                if (this.evaluations == 1) {
                    return this.success(OptimTask.NEW_X);
                }
                this.tmp.combine(1.0, x, -1.0, this.x0);
                if (f <= this.f0 + this.sftol * this.tmp.dot(this.g0)) {
                    ++this.iterations;
                    return this.success(OptimTask.NEW_X);
                }
                this.alpha /= 2.0;
                return this.nextStep(x);
            }
            case NEW_X: {
                if (this.iterations >= 1) {
                    this.H.update(x, this.x0, this.pg, this.pg0);
                }
            }
            case FINAL_X: {
                while (true) {
                    this.H.apply(this.p, g);
                    this.projector.projectDirection(x, this.p, true, this.tmp, this.bnd);
                    if (this.tmp.dot(g) > 0.0) break;
                    if (this.H.mp < 1) {
                        return this.failure(OptimStatus.BAD_PRECONDITIONER);
                    }
                    this.H.reset();
                    ++this.restarts;
                }
                this.alpha = BLMVM.min(this.initialStep(x, this.p.norm2()), this.bnd[1]);
                if (this.saveMemory) {
                    this.x0 = this.H.s(0);
                    this.g0 = this.H.y(0);
                    if (this.H.mp == this.H.m) {
                        --this.H.mp;
                    }
                }
                this.x0.copyFrom(x);
                this.g0.copyFrom(g);
                this.pg0.copyFrom(this.pg);
                this.f0 = f;
                return this.nextStep(x);
            }
        }
        return this.getTask();
    }

    protected OptimTask nextStep(Vector x) {
        x.combine(1.0, this.x0, -this.alpha, this.p);
        this.projector.projectVariables(x);
        return this.success(OptimTask.COMPUTE_FG);
    }

    protected double initialStep(Vector x, double dnorm) {
        double xnorm;
        if (this.H.mp >= 1 || this.H.rule == 0) {
            return 1.0;
        }
        if (0.0 < this.epsilon && this.epsilon < 1.0 && (xnorm = x.norm2()) > 0.0) {
            return xnorm / dnorm * this.epsilon;
        }
        return 1.0 / dnorm;
    }

    public void setAbsoluteTolerance(double gatol) {
        this.gatol = gatol;
    }

    public void setRelativeTolerance(double grtol) {
        this.grtol = grtol;
    }

    public double getAbsoluteTolerance() {
        return this.gatol;
    }

    public double getRelativeTolerance() {
        return this.grtol;
    }

    public Vector getProjectedGradient() {
        return this.evaluations >= 1 ? this.pg : null;
    }

    public double getProjectedGradientNorm2() {
        return this.evaluations >= 1 ? this.pgnorm : -1.0;
    }

    private static final double max(double a1, double a2, double a3) {
        if (a2 < a3) {
            a2 = a3;
        }
        return a1 >= a2 ? a1 : a2;
    }

    private static final double min(double a1, double a2) {
        return a1 <= a2 ? a1 : a2;
    }
}

